{ *********************************************************************** }
{                                                                         }
{ Delphi Runtime Library                                                  }
{                                                                         }
{ Copyright (c) 1999-2001 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

{*******************************************************}
{       OLEDB Interface Unit                            }
{*******************************************************}

unit OleDB;

interface

uses Windows, ActiveX;
{$HPPEMIT '#include <transact.h>"}
{$HPPEMIT '#include <oledb.h>"}

// *********************************************************************//
// GUID declarations                                                    //
// *********************************************************************//
const
  CLSID_OLEDB_ENUMERATOR: TGUID = '{C8B522D0-5CF3-11CE-ADE5-00AA0044773D}'; {MSDAENUM}
  CLSID_EXTENDEDERRORINFO: TGUID = '{C8B522CF-5CF3-11CE-ADE5-00AA0044773D}'; {MSDAERR}
  CLSID_MSDAVTM: TGUID = '{0C733A8E-2A1C-11CE-ADE5-00AA0044773D}'; {MSDAVTM}
  CLSID_OLEDB_CONVERSIONLIBRARY: TGUID = '{C8B522D1-5CF3-11CE-ADE5-00AA0044773D}'; {MSDADC}
  CLSID_OLEDB_ROWPOSITIONLIBRARY: TGUID = '{2048EEE6-7FA2-11D0-9E6A-00A0C9138C29}'; {RowPosition.RowPosition}
  CLSID_DATALINKS: TGUID = '{2206CDB2-19C1-11D1-89E0-00C04FD7A829}'; {DataLinks}

  IID_ITransaction: TGUID = '{0FB15084-AF41-11CE-BD2B-204C4F4F5020}';
  IID_ITransactionOptions: TGUID = '{3A6AD9E0-23B9-11CF-AD60-00AA00A74CCD}';
  IID_ITransactionDispenser: TGUID = '{3A6AD9E1-23B9-11CF-AD60-00AA00A74CCD}';
  IID_ITransactionOutcomeEvents: TGUID = '{3A6AD9E2-23B9-11CF-AD60-00AA00A74CCD}';
  IID_IAccessor: TGUID = '{0C733A8C-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowset: TGUID = '{0C733A7C-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetInfo: TGUID = '{0C733A55-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetLocate: TGUID = '{0C733A7D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetResynch: TGUID = '{0C733A84-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetScroll: TGUID = '{0C733A7E-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetChange: TGUID = '{0C733A05-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetUpdate: TGUID = '{0C733A6D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetIndex: TGUID = '{0C733A82-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IMultipleResults: TGUID = '{0C733A90-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IConvertType: TGUID = '{0C733A88-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandPrepare: TGUID = '{0C733A26-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandProperties: TGUID = '{0C733A79-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommand: TGUID = '{0C733A63-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandWithParameters: TGUID = '{0C733A10-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandText: TGUID = '{0C733A27-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IColumnsRowset: TGUID = '{0C733A10-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IColumnsInfo: TGUID = '{0C733A11-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBCreateCommand: TGUID = '{0C733A1D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBCreateSession: TGUID = '{0C733A5D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ISourcesRowset: TGUID = '{0C733A1E-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBProperties: TGUID = '{0C733A8A-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBInitialize: TGUID = '{0C733A8B-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBInfo: TGUID = '{0C733A89-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBDataSourceAdmin: TGUID = '{0C733A7A-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ISessionProperties: TGUID = '{0C733A85-2A1C-11CE-ADE5-00AA0044773d}';
  IID_IIndexDefinition: TGUID = '{0C733A68-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITableDefinition: TGUID = '{0C733A86-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IOpenRowset: TGUID = '{0C733A69-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IErrorLookup: TGUID = '{0C733A66-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ISQLErrorInfo: TGUID = '{0C733A74-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IGetDataSource: TGUID = '{0C733A75-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITransactionLocal: TGUID = '{0C733A5F-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITransactionJoin: TGUID = '{0C733A5E-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITransactionObject: TGUID = '{0C733A60-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBAsynchStatus: TGUID = '{0C733A95-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetFind: TGUID = '{0C733A9D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowPosition: TGUID = '{0C733A94-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowPositionChange: TGUID = '{0997A571-126E-11D0-9F8A-00A0C9A0631E}';
  IID_IViewRowset: TGUID = '{0C733A97-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IViewChapter: TGUID = '{0C733A98-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IViewSort: TGUID = '{0C733A9A-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IViewFilter: TGUID = '{0C733A9B-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetView: TGUID = '{0C733A99-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IMDFind: TGUID = '{A07CCCD2-8148-11D0-87BB-00C04FC33942}';
  IID_IMDRangeRowset: TGUID = '{0C733AA0-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IAlterTable: TGUID = '{0C733AA5-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IAlterIndex: TGUID = '{0C733AA6-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandPersist: TGUID = '{0C733AA7-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetChapterMember: TGUID = '{0C733AA8-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetRefresh: TGUID = '{0C733AA9-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IParentRowset: TGUID = '{0C733AAA-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITrusteeGroupAdmin: TGUID = '{0C733AA2-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IObjectAccessControl: TGUID = '{0C733AA3-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ISecurityInfo: TGUID = '{0C733AA4-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBPromptInitialize: TGUID = '{2206CCB0-19C1-11D1-89E0-00C04FD7A829}';
  IID_IDataInitialize: TGUID = '{2206CCB1-19C1-11D1-89E0-00C04FD7A829}';

  DBSCHEMA_TABLES_INFO: TGUID = '{C8B522E0-5CF3-11CE-ADE5-00AA0044773D}';
  MDGUID_MDX: TGUID = '{A07CCCD0-8148-11D0-87BB-00C04FC33942}';
  DBGUID_MDX: TGUID = '{A07CCCD0-8148-11D0-87BB-00C04FC33942}';
  MDSCHEMA_CUBES: TGUID = '{C8B522D8-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_DIMENSIONS: TGUID = '{C8B522D9-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_HIERARCHIES: TGUID = '{C8B522DA-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_LEVELS: TGUID = '{C8B522DB-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_MEASURES: TGUID = '{C8B522DC-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_PROPERTIES: TGUID = '{C8B522DD-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_MEMBERS: TGUID = '{C8B522DE-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_TRUSTEE: TGUID = '{C8B522E1-5CF3-11CE-ADE5-00AA0044773D}';

  DBOBJECT_TABLE: TGUID = '{C8B522E2-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_COLUMN: TGUID = '{C8B522E4-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_DATABASE: TGUID = '{C8B522E5-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_PROCEDURE: TGUID = '{C8B522E6-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_VIEW: TGUID = '{C8B522E7-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_SCHEMA: TGUID = '{C8B522E8-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_DOMAIN: TGUID = '{C8B522E9-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_COLLATION: TGUID = '{C8B522EA-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_TRUSTEE: TGUID = '{C8B522EB-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_SCHEMAROWSET: TGUID = '{C8B522EC-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_CHARACTERSET: TGUID = '{C8B522ED-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_TRANSLATION: TGUID = '{C8B522EE-5CF3-11CE-ADE5-00AA0044773D}';

  DB_PROPERTY_CHECK_OPTION: TGUID = '{C8B5220B-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_CONSTRAINT_CHECK_DEFERRED: TGUID = '{C8B521F0-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_DROP_CASCADE: TGUID = '{C8B521F3-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_UNIQUE: TGUID = '{C8B521F5-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_ON_COMMIT_PRESERVE_ROWS: TGUID = '{C8B52230-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_PRIMARY: TGUID = '{C8B521FC-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_CLUSTERED: TGUID = '{C8B521FF-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_NONCLUSTERED: TGUID = '{C8B52200-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_BTREE: TGUID = '{C8B52201-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_HASH: TGUID = '{C8B52202-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_FILLFACTOR: TGUID = '{C8B52203-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_INITIALSIZE: TGUID = '{C8B52204-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_DISALLOWNULL: TGUID = '{C8B52205-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_IGNORENULL: TGUID = '{C8B52206-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_IGNOREANYNULL: TGUID = '{C8B52207-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_SORTBOOKMARKS: TGUID = '{C8B52208-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_AUTOMATICUPDATE: TGUID = '{C8B52209-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_EXPLICITUPDATE: TGUID = '{C8B5220A-5CF3-11CE-ADE5-00AA0044773D}';

  DBGUID_LIKE_SQL: TGUID = '{C8B521F6-5CF3-11CE-ADE5-00AA0044773D}';
  DBGUID_LIKE_DOS: TGUID = '{C8B521F7-5CF3-11CE-ADE5-00AA0044773D}';
  DBGUID_LIKE_OFS: TGUID = '{C8B521F8-5CF3-11CE-ADE5-00AA0044773D}';
  DBGUID_LIKE_MAPI: TGUID = '{C8B521F9-5CF3-11CE-ADE5-00AA0044773D}';

  DBSCHEMA_ASSERTIONS: TGUID = '{C8B52210-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CATALOGS: TGUID = '{C8B52211-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CHARACTER_SETS: TGUID = '{C8B52212-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_COLLATIONS: TGUID = '{C8B52213-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_COLUMNS: TGUID = '{C8B52214-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CHECK_CONSTRAINTS: TGUID = '{C8B52215-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CONSTRAINT_COLUMN_USAGE: TGUID = '{C8B52216-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CONSTRAINT_TABLE_USAGE: TGUID = '{C8B52217-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_KEY_COLUMN_USAGE: TGUID = '{C8B52218-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_REFERENTIAL_CONSTRAINTS: TGUID = '{C8B52219-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_TABLE_CONSTRAINTS: TGUID = '{C8B5221A-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_COLUMN_DOMAIN_USAGE: TGUID = '{C8B5221B-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_INDEXES: TGUID = '{C8B5221E-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_COLUMN_PRIVILEGES: TGUID = '{C8B52221-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_TABLE_PRIVILEGES: TGUID = '{C8B52222-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_USAGE_PRIVILEGES: TGUID = '{C8B52223-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PROCEDURES: TGUID = '{C8B52224-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_SCHEMATA: TGUID = '{C8B52225-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_SQL_LANGUAGES: TGUID = '{C8B52226-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_STATISTICS: TGUID = '{C8B52227-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_TABLES: TGUID = '{C8B52229-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_TRANSLATIONS: TGUID = '{C8B5222A-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PROVIDER_TYPES: TGUID = '{C8B5222C-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_VIEWS: TGUID = '{C8B5222D-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_VIEW_COLUMN_USAGE: TGUID = '{C8B5222E-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_VIEW_TABLE_USAGE: TGUID = '{C8B5222F-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PROCEDURE_PARAMETERS: TGUID = '{C8B522B8-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_FOREIGN_KEYS: TGUID = '{C8B522C4-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PRIMARY_KEYS: TGUID = '{C8B522C5-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PROCEDURE_COLUMNS: TGUID = '{C8B522C9-5CF3-11CE-ADE5-00AA0044773D}';

  DBCOL_SELFCOLUMNS: TGUID = '{C8B52231-5CF3-11CE-ADE5-00AA0044773D}';
  DBCOL_SPECIALCOL: TGUID = '{C8B52232-5CF3-11CE-ADE5-00AA0044773D}';
  PSGUID_QUERY: TGUID = '{49691C90-7E17-101A-A91C-08002B2ECDA9}';

  DBPROPSET_COLUMN: TGUID = '{C8B522B9-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DATASOURCE: TGUID = '{C8B522BA-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DATASOURCEINFO: TGUID = '{C8B522BB-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_INDEX: TGUID = '{C8B522BD-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DBINIT: TGUID = '{C8B522BC-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_ROWSET: TGUID = '{C8B522BE-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_SESSION: TGUID = '{C8B522C6-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_TABLE: TGUID = '{C8B522BF-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_PROPERTIESINERROR: TGUID = '{C8B522D4-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_VIEW: TGUID = '{C8B522DF-5CF3-11CE-ADE5-00AA0044773D}';

  DBPROPSET_COLUMNALL = '{C8B522F0-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_CONSTRAINTALL = '{C8B522FA-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DATASOURCEALL: TGUID = '{C8B522C0-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DATASOURCEINFOALL: TGUID = '{C8B522C1-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DBINITALL: TGUID = '{C8B522CA-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_INDEXALL = '{C8B522F1-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_ROWSETALL: TGUID = '{C8B522C2-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_SESSIONALL: TGUID = '{C8B522C7-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_TABLEALL = '{C8B522F2-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_TRUSTEEALL = '{C8B522F3-5CF3-11CE-ADE5-00AA0044773D}';


  DBGUID_DEFAULT: TGUID = '{C8B521FB-5CF3-11CE-ADE5-00AA0044773D}';
  DBGUID_SQL: TGUID = '{C8B522D7-5CF3-11CE-ADE5-00AA0044773D}';

// *********************************************************************//
// Constant Declarations                                                //
// *********************************************************************//

const
  MAXCOLS = 4096;
  MAXBOUND = 65535; { High bound for arrays }
  OLEDBVER = $0210;
  {$EXTERNALSYM OLEDBVER}
  DB_INVALID_HACCESSOR = $00;
  {$EXTERNALSYM DB_INVALID_HACCESSOR}
  DB_NULL_HROW = $00;
  {$EXTERNALSYM DB_NULL_HROW}
  DBWATCHREGION_NULL = nil;
  {$EXTERNALSYM DBWATCHREGION_NULL}
  DB_NULL_HCHAPTER = $00;
  {$EXTERNALSYM DB_NULL_HCHAPTER}
  STD_BOOKMARKLENGTH = 1;
  {$EXTERNALSYM STD_BOOKMARKLENGTH}
  DB_INVALIDCOLUMN = HIGH(ULONG);
  {$EXTERNALSYM DB_INVALIDCOLUMN}
  DBCIDGUID: TGuid = '{0C733A81-2A1C-11CE-ADE5-00AA0044773D}';
  {$EXTERNALSYM DBCIDGUID}
  DB_NULLGUID: TGuid = '{00000000-0000-0000-0000-000000000000}';
  {$EXTERNALSYM DB_NULLGUID}
  DBPROPVAL_BMK_NUMERIC = $00000001;
  {$EXTERNALSYM DBPROPVAL_BMK_NUMERIC}
  DBPROPVAL_BMK_KEY = $00000002;
  {$EXTERNALSYM DBPROPVAL_BMK_KEY}
  DBPROPVAL_CL_START = $00000001;
  {$EXTERNALSYM DBPROPVAL_CL_START}
  DBPROPVAL_CL_END = $00000002;
  {$EXTERNALSYM DBPROPVAL_CL_END}
  DBPROPVAL_CU_DML_STATEMENTS = $00000001;
  {$EXTERNALSYM DBPROPVAL_CU_DML_STATEMENTS}
  DBPROPVAL_CU_TABLE_DEFINITION = $00000002;
  {$EXTERNALSYM DBPROPVAL_CU_TABLE_DEFINITION}
  DBPROPVAL_CU_INDEX_DEFINITION = $00000004;
  {$EXTERNALSYM DBPROPVAL_CU_INDEX_DEFINITION}
  DBPROPVAL_CU_PRIVILEGE_DEFINITION = $00000008;
  {$EXTERNALSYM DBPROPVAL_CU_PRIVILEGE_DEFINITION}
  DBPROPVAL_CD_NOTNULL = $00000001;
  {$EXTERNALSYM DBPROPVAL_CD_NOTNULL}
  DBPROPVAL_CB_NULL = $00000001;
  {$EXTERNALSYM DBPROPVAL_CB_NULL}
  DBPROPVAL_CB_NON_NULL = $00000002;
  {$EXTERNALSYM DBPROPVAL_CB_NON_NULL}
  DBPROPVAL_FU_NOT_SUPPORTED = $00000001;
  {$EXTERNALSYM DBPROPVAL_FU_NOT_SUPPORTED}
  DBPROPVAL_FU_COLUMN = $00000002;
  {$EXTERNALSYM DBPROPVAL_FU_COLUMN}
  DBPROPVAL_FU_TABLE = $00000004;
  {$EXTERNALSYM DBPROPVAL_FU_TABLE}
  DBPROPVAL_FU_CATALOG = $00000008;
  {$EXTERNALSYM DBPROPVAL_FU_CATALOG}
  DBPROPVAL_GB_NOT_SUPPORTED = $00000001;
  {$EXTERNALSYM DBPROPVAL_GB_NOT_SUPPORTED}
  DBPROPVAL_GB_EQUALS_SELECT = $00000002;
  {$EXTERNALSYM DBPROPVAL_GB_EQUALS_SELECT}
  DBPROPVAL_GB_CONTAINS_SELECT = $00000004;
  {$EXTERNALSYM DBPROPVAL_GB_CONTAINS_SELECT}
  DBPROPVAL_GB_NO_RELATION = $00000008;
  {$EXTERNALSYM DBPROPVAL_GB_NO_RELATION}
  DBPROPVAL_HT_DIFFERENT_CATALOGS = $00000001;
  {$EXTERNALSYM DBPROPVAL_HT_DIFFERENT_CATALOGS}
  DBPROPVAL_HT_DIFFERENT_PROVIDERS = $00000002;
  {$EXTERNALSYM DBPROPVAL_HT_DIFFERENT_PROVIDERS}
  DBPROPVAL_IC_UPPER = $00000001;
  {$EXTERNALSYM DBPROPVAL_IC_UPPER}
  DBPROPVAL_IC_LOWER = $00000002;
  {$EXTERNALSYM DBPROPVAL_IC_LOWER}
  DBPROPVAL_IC_SENSITIVE = $00000004;
  {$EXTERNALSYM DBPROPVAL_IC_SENSITIVE}
  DBPROPVAL_IC_MIXED = $00000008;
  {$EXTERNALSYM DBPROPVAL_IC_MIXED}
  DBPROPVAL_LM_NONE = $00000001;
  {$EXTERNALSYM DBPROPVAL_LM_NONE}
  DBPROPVAL_LM_READ = $00000002;
  {$EXTERNALSYM DBPROPVAL_LM_READ}
  DBPROPVAL_LM_INTENT = $00000004;
  {$EXTERNALSYM DBPROPVAL_LM_INTENT}
  DBPROPVAL_LM_RITE = $00000008;
  {$EXTERNALSYM DBPROPVAL_LM_RITE}
  DBPROPVAL_NP_OKTODO = $00000001;
  {$EXTERNALSYM DBPROPVAL_NP_OKTODO}
  DBPROPVAL_NP_ABOUTTODO = $00000002;
  {$EXTERNALSYM DBPROPVAL_NP_ABOUTTODO}
  DBPROPVAL_NP_SYNCHAFTER = $00000004;
  {$EXTERNALSYM DBPROPVAL_NP_SYNCHAFTER}
  DBPROPVAL_NP_FAILEDTODO = $00000008;
  {$EXTERNALSYM DBPROPVAL_NP_FAILEDTODO}
  DBPROPVAL_NP_DIDEVENT = $00000010;
  {$EXTERNALSYM DBPROPVAL_NP_DIDEVENT}
  DBPROPVAL_NC_END = $00000001;
  {$EXTERNALSYM DBPROPVAL_NC_END}
  DBPROPVAL_NC_HIGH = $00000002;
  {$EXTERNALSYM DBPROPVAL_NC_HIGH}
  DBPROPVAL_NC_LOW = $00000004;
  {$EXTERNALSYM DBPROPVAL_NC_LOW}
  DBPROPVAL_NC_START = $00000008;
  {$EXTERNALSYM DBPROPVAL_NC_START}
  DBPROPVAL_OO_BLOB = $00000001;
  {$EXTERNALSYM DBPROPVAL_OO_BLOB}
  DBPROPVAL_OO_IPERSIST = $00000002;
  {$EXTERNALSYM DBPROPVAL_OO_IPERSIST}
  DBPROPVAL_CB_DELETE = $00000001;
  {$EXTERNALSYM DBPROPVAL_CB_DELETE}
  DBPROPVAL_CB_PRESERVE = $00000002;
  {$EXTERNALSYM DBPROPVAL_CB_PRESERVE}
  DBPROPVAL_SU_DML_STATEMENTS = $00000001;
  {$EXTERNALSYM DBPROPVAL_SU_DML_STATEMENTS}
  DBPROPVAL_SU_TABLE_DEFINITION = $00000002;
  {$EXTERNALSYM DBPROPVAL_SU_TABLE_DEFINITION}
  DBPROPVAL_SU_INDEX_DEFINITION = $00000004;
  {$EXTERNALSYM DBPROPVAL_SU_INDEX_DEFINITION}
  DBPROPVAL_SU_PRIVILEGE_DEFINITION = $00000008;
  {$EXTERNALSYM DBPROPVAL_SU_PRIVILEGE_DEFINITION}
  DBPROPVAL_SQ_CORRELATEDSUBQUERIES = $00000001;
  {$EXTERNALSYM DBPROPVAL_SQ_CORRELATEDSUBQUERIES}
  DBPROPVAL_SQ_COMPARISON = $00000002;
  {$EXTERNALSYM DBPROPVAL_SQ_COMPARISON}
  DBPROPVAL_SQ_EXISTS = $00000004;
  {$EXTERNALSYM DBPROPVAL_SQ_EXISTS}
  DBPROPVAL_SQ_IN = $00000008;
  {$EXTERNALSYM DBPROPVAL_SQ_IN}
  DBPROPVAL_SQ_QUANTIFIED = $00000010;
  {$EXTERNALSYM DBPROPVAL_SQ_QUANTIFIED}
  DBPROPVAL_SS_ISEQUENTIALSTREAM = $00000001;
  {$EXTERNALSYM DBPROPVAL_SS_ISEQUENTIALSTREAM}
  DBPROPVAL_SS_ISTREAM = $00000002;
  {$EXTERNALSYM DBPROPVAL_SS_ISTREAM}
  DBPROPVAL_SS_ISTORAGE = $00000004;
  {$EXTERNALSYM DBPROPVAL_SS_ISTORAGE}
  DBPROPVAL_SS_ILOCKBYTES = $00000008;
  {$EXTERNALSYM DBPROPVAL_SS_ILOCKBYTES}
  DBPROPVAL_TI_CHAOS = $00000010;
  {$EXTERNALSYM DBPROPVAL_TI_CHAOS}
  DBPROPVAL_TI_READUNCOMMITTED = $00000100;
  {$EXTERNALSYM DBPROPVAL_TI_READUNCOMMITTED}
  DBPROPVAL_TI_BROWSE = $00000100;
  {$EXTERNALSYM DBPROPVAL_TI_BROWSE}
  DBPROPVAL_TI_CURSORSTABILITY = $00001000;
  {$EXTERNALSYM DBPROPVAL_TI_CURSORSTABILITY}
  DBPROPVAL_TI_READCOMMITTED = $00001000;
  {$EXTERNALSYM DBPROPVAL_TI_READCOMMITTED}
  DBPROPVAL_TI_REPEATABLEREAD = $00010000;
  {$EXTERNALSYM DBPROPVAL_TI_REPEATABLEREAD}
  DBPROPVAL_TI_SERIALIZABLE = $00100000;
  {$EXTERNALSYM DBPROPVAL_TI_SERIALIZABLE}
  DBPROPVAL_TI_ISOLATED = $00100000;
  {$EXTERNALSYM DBPROPVAL_TI_ISOLATED}
  DBPROPVAL_TR_COMMIT_DC = $00000001;
  {$EXTERNALSYM DBPROPVAL_TR_COMMIT_DC}
  DBPROPVAL_TR_COMMIT = $00000002;
  {$EXTERNALSYM DBPROPVAL_TR_COMMIT}
  DBPROPVAL_TR_COMMIT_NO = $00000004;
  {$EXTERNALSYM DBPROPVAL_TR_COMMIT_NO}
  DBPROPVAL_TR_ABORT_DC = $00000008;
  {$EXTERNALSYM DBPROPVAL_TR_ABORT_DC}
  DBPROPVAL_TR_ABORT = $00000010;
  {$EXTERNALSYM DBPROPVAL_TR_ABORT}
  DBPROPVAL_TR_ABORT_NO = $00000020;
  {$EXTERNALSYM DBPROPVAL_TR_ABORT_NO}
  DBPROPVAL_TR_DONTCARE = $00000040;
  {$EXTERNALSYM DBPROPVAL_TR_DONTCARE}
  DBPROPVAL_TR_BOTH = $00000080;
  {$EXTERNALSYM DBPROPVAL_TR_BOTH}
  DBPROPVAL_TR_NONE = $00000100;
  {$EXTERNALSYM DBPROPVAL_TR_NONE}
  DBPROPVAL_TR_OPTIMISTIC = $00000200;
  {$EXTERNALSYM DBPROPVAL_TR_OPTIMISTIC}
  DBPROPVAL_RT_FREETHREAD = $00000001;
  {$EXTERNALSYM DBPROPVAL_RT_FREETHREAD}
  DBPROPVAL_RT_APTMTTHREAD = $00000002;
  {$EXTERNALSYM DBPROPVAL_RT_APTMTTHREAD}
  DBPROPVAL_RT_SINGLETHREAD = $00000004;
  {$EXTERNALSYM DBPROPVAL_RT_SINGLETHREAD}
  DBPROPVAL_UP_CHANGE = $00000001;
  {$EXTERNALSYM DBPROPVAL_UP_CHANGE}
  DBPROPVAL_UP_DELETE = $00000002;
  {$EXTERNALSYM DBPROPVAL_UP_DELETE}
  DBPROPVAL_UP_INSERT = $00000004;
  {$EXTERNALSYM DBPROPVAL_UP_INSERT}
  DBPROPVAL_SQL_NONE = $00000000;
  {$EXTERNALSYM DBPROPVAL_SQL_NONE}
  DBPROPVAL_SQL_ODBC_MINIMUM = $00000001;
  {$EXTERNALSYM DBPROPVAL_SQL_ODBC_MINIMUM}
  DBPROPVAL_SQL_ODBC_CORE = $00000002;
  {$EXTERNALSYM DBPROPVAL_SQL_ODBC_CORE}
  DBPROPVAL_SQL_ODBC_EXTENDED = $00000004;
  {$EXTERNALSYM DBPROPVAL_SQL_ODBC_EXTENDED}
  DBPROPVAL_SQL_ANSI89_IEF = $00000008;
  {$EXTERNALSYM DBPROPVAL_SQL_ANSI89_IEF}
  DBPROPVAL_SQL_ANSI92_ENTRY = $00000010;
  {$EXTERNALSYM DBPROPVAL_SQL_ANSI92_ENTRY}
  DBPROPVAL_SQL_FIPS_TRANSITIONAL = $00000020;
  {$EXTERNALSYM DBPROPVAL_SQL_FIPS_TRANSITIONAL}
  DBPROPVAL_SQL_ANSI92_INTERMEDIATE = $00000040;
  {$EXTERNALSYM DBPROPVAL_SQL_ANSI92_INTERMEDIATE}
  DBPROPVAL_SQL_ANSI92_FULL = $00000080;
  {$EXTERNALSYM DBPROPVAL_SQL_ANSI92_FULL}
  DBPROPVAL_SQL_ESCAPECLAUSES = $00000100;
  {$EXTERNALSYM DBPROPVAL_SQL_ESCAPECLAUSES}
  DBPROPVAL_IT_BTREE = $00000001;
  {$EXTERNALSYM DBPROPVAL_IT_BTREE}
  DBPROPVAL_IT_HASH = $00000002;
  {$EXTERNALSYM DBPROPVAL_IT_HASH}
  DBPROPVAL_IT_CONTENT = $00000003;
  {$EXTERNALSYM DBPROPVAL_IT_CONTENT}
  DBPROPVAL_IT_OTHER = $00000004;
  {$EXTERNALSYM DBPROPVAL_IT_OTHER}
  DBPROPVAL_IN_DISALLOWNULL = $00000001;
  {$EXTERNALSYM DBPROPVAL_IN_DISALLOWNULL}
  DBPROPVAL_IN_IGNORENULL = $00000002;
  {$EXTERNALSYM DBPROPVAL_IN_IGNORENULL}
  DBPROPVAL_IN_IGNOREANYNULL = $00000004;
  {$EXTERNALSYM DBPROPVAL_IN_IGNOREANYNULL}
  DBPROPVAL_TC_NONE = $00000000;
  {$EXTERNALSYM DBPROPVAL_TC_NONE}
  DBPROPVAL_TC_DML = $00000001;
  {$EXTERNALSYM DBPROPVAL_TC_DML}
  DBPROPVAL_TC_DDL_COMMIT = $00000002;
  {$EXTERNALSYM DBPROPVAL_TC_DDL_COMMIT}
  DBPROPVAL_TC_DDL_IGNORE = $00000004;
  {$EXTERNALSYM DBPROPVAL_TC_DDL_IGNORE}
  DBPROPVAL_TC_ALL = $00000008;
  {$EXTERNALSYM DBPROPVAL_TC_ALL}
  DBPROPVAL_OA_NOTSUPPORTED = $00000001;
  {$EXTERNALSYM DBPROPVAL_OA_NOTSUPPORTED}
  DBPROPVAL_OA_ATEXECUTE = $00000002;
  {$EXTERNALSYM DBPROPVAL_OA_ATEXECUTE}
  DBPROPVAL_OA_ATROWRELEASE = $00000004;
  {$EXTERNALSYM DBPROPVAL_OA_ATROWRELEASE}
  DBPROPVAL_MR_NOTSUPPORTED = $00000000;
  {$EXTERNALSYM DBPROPVAL_MR_NOTSUPPORTED}
  DBPROPVAL_MR_SUPPORTED = $00000001;
  {$EXTERNALSYM DBPROPVAL_MR_SUPPORTED}
  DBPROPVAL_MR_CONCURRENT = $00000002;
  {$EXTERNALSYM DBPROPVAL_MR_CONCURRENT}
  DBPROPVAL_PT_GUID_NAME = $00000001;
  {$EXTERNALSYM DBPROPVAL_PT_GUID_NAME}
  DBPROPVAL_PT_GUID_PROPID = $00000002;
  {$EXTERNALSYM DBPROPVAL_PT_GUID_PROPID}
  DBPROPVAL_PT_NAME = $00000004;
  {$EXTERNALSYM DBPROPVAL_PT_NAME}
  DBPROPVAL_PT_GUID = $00000008;
  {$EXTERNALSYM DBPROPVAL_PT_GUID}
  DBPROPVAL_PT_PROPID = $00000010;
  {$EXTERNALSYM DBPROPVAL_PT_PROPID}
  DBPROPVAL_PT_PGUID_NAME = $00000020;
  {$EXTERNALSYM DBPROPVAL_PT_PGUID_NAME}
  DBPROPVAL_PT_PGUID_PROPID = $00000040;
  {$EXTERNALSYM DBPROPVAL_PT_PGUID_PROPID}
  DBPROPVAL_NT_SINGLEROW = $00000001;
  {$EXTERNALSYM DBPROPVAL_NT_SINGLEROW}
  DBPROPVAL_NT_MULTIPLEROWS = $00000002;
  {$EXTERNALSYM DBPROPVAL_NT_MULTIPLEROWS}
  DBPROPVAL_ASYNCH_INITIALIZE = $00000001;
  {$EXTERNALSYM DBPROPVAL_ASYNCH_INITIALIZE}
  DBPROPVAL_ASYNCH_SEQUENTIALPOPULATION = $00000002;
  {$EXTERNALSYM DBPROPVAL_ASYNCH_SEQUENTIALPOPULATION}
  DBPROPVAL_ASYNCH_RANDOMPOPULATION = $00000004;
  {$EXTERNALSYM DBPROPVAL_ASYNCH_RANDOMPOPULATION}
  DBPROPVAL_OP_EQUAL = $00000001;
  {$EXTERNALSYM DBPROPVAL_OP_EQUAL}
  DBPROPVAL_OP_RELATIVE = $00000002;
  {$EXTERNALSYM DBPROPVAL_OP_RELATIVE}
  DBPROPVAL_OP_STRING = $00000004;
  {$EXTERNALSYM DBPROPVAL_OP_STRING}
  DBPROPVAL_CO_EQUALITY = $00000001;
  {$EXTERNALSYM DBPROPVAL_CO_EQUALITY}
  DBPROPVAL_CO_STRING = $00000002;
  {$EXTERNALSYM DBPROPVAL_CO_STRING}
  DBPROPVAL_CO_CASESENSITIVE = $00000004;
  {$EXTERNALSYM DBPROPVAL_CO_CASESENSITIVE}
  DBPROPVAL_CO_CASEINSENSITIVE = $00000008;
  {$EXTERNALSYM DBPROPVAL_CO_CASEINSENSITIVE}
  DBPROPVAL_CO_CONTAINS = $00000010;
  {$EXTERNALSYM DBPROPVAL_CO_CONTAINS}
  DBPROPVAL_CO_BEGINSWITH = $00000020;
  {$EXTERNALSYM DBPROPVAL_CO_BEGINSWITH}
  DBPROPVAL_ASYNCH_BACKGROUNDPOPULATION = $00000008;
  {$EXTERNALSYM DBPROPVAL_ASYNCH_BACKGROUNDPOPULATION}
  DBPROPVAL_ASYNCH_PREPOPULATE = $00000010;
  {$EXTERNALSYM DBPROPVAL_ASYNCH_PREPOPULATE}
  DBPROPVAL_ASYNCH_POPULATEONDEMAND = $00000020;
  {$EXTERNALSYM DBPROPVAL_ASYNCH_POPULATEONDEMAND}
  DBPROPVAL_LM_SINGLEROW = $00000002;
  {$EXTERNALSYM DBPROPVAL_LM_SINGLEROW}
  DBPROPVAL_SQL_SUBMINIMUM = $00000200;
  {$EXTERNALSYM DBPROPVAL_SQL_SUBMINIMUM}
  DBPROPVAL_DST_TDP = $00000001;
  {$EXTERNALSYM DBPROPVAL_DST_TDP}
  DBPROPVAL_DST_MDP = $00000002;
  {$EXTERNALSYM DBPROPVAL_DST_MDP}
  DBPROPVAL_DST_TDPANDMDP = $00000003;
  {$EXTERNALSYM DBPROPVAL_DST_TDPANDMDP}
  MDPROPVAL_AU_UNSUPPORTED = $00000000;
  {$EXTERNALSYM MDPROPVAL_AU_UNSUPPORTED}
  MDPROPVAL_AU_UNCHANGED = $00000001;
  {$EXTERNALSYM MDPROPVAL_AU_UNCHANGED}
  MDPROPVAL_AU_UNKNOWN = $00000002;
  {$EXTERNALSYM MDPROPVAL_AU_UNKNOWN}
  MDPROPVAL_MF_WITH_CALCMEMBERS = $00000001;
  {$EXTERNALSYM MDPROPVAL_MF_WITH_CALCMEMBERS}
  MDPROPVAL_MF_WITH_NAMEDSETS = $00000002;
  {$EXTERNALSYM MDPROPVAL_MF_WITH_NAMEDSETS}
  MDPROPVAL_MF_CREATE_CALCMEMBERS = $00000004;
  {$EXTERNALSYM MDPROPVAL_MF_CREATE_CALCMEMBERS}
  MDPROPVAL_MF_CREATE_NAMEDSETS = $00000008;
  {$EXTERNALSYM MDPROPVAL_MF_CREATE_NAMEDSETS}
  MDPROPVAL_MF_SCOPE_SESSION = $00000010;
  {$EXTERNALSYM MDPROPVAL_MF_SCOPE_SESSION}
  MDPROPVAL_MF_SCOPE_GLOBAL = $00000020;
  {$EXTERNALSYM MDPROPVAL_MF_SCOPE_GLOBAL}
  MDPROPVAL_MMF_COUSIN = $00000001;
  {$EXTERNALSYM MDPROPVAL_MMF_COUSIN}
  MDPROPVAL_MMF_PARALLELPERIOD = $00000002;
  {$EXTERNALSYM MDPROPVAL_MMF_PARALLELPERIOD}
  MDPROPVAL_MMF_OPENINGPERIOD = $00000004;
  {$EXTERNALSYM MDPROPVAL_MMF_OPENINGPERIOD}
  MDPROPVAL_MMF_CLOSINGPERIOD = $00000008;
  {$EXTERNALSYM MDPROPVAL_MMF_CLOSINGPERIOD}
  MDPROPVAL_MNF_MEDIAN = $00000001;
  {$EXTERNALSYM MDPROPVAL_MNF_MEDIAN}
  MDPROPVAL_MNF_VAR = $00000002;
  {$EXTERNALSYM MDPROPVAL_MNF_VAR}
  MDPROPVAL_MNF_STDDEV = $00000004;
  {$EXTERNALSYM MDPROPVAL_MNF_STDDEV}
  MDPROPVAL_MNF_RANK = $00000008;
  {$EXTERNALSYM MDPROPVAL_MNF_RANK}
  MDPROPVAL_MNF_AGGREGATE = $00000010;
  {$EXTERNALSYM MDPROPVAL_MNF_AGGREGATE}
  MDPROPVAL_MNF_COVARIANCE = $00000020;
  {$EXTERNALSYM MDPROPVAL_MNF_COVARIANCE}
  MDPROPVAL_MNF_CORRELATION = $00000040;
  {$EXTERNALSYM MDPROPVAL_MNF_CORRELATION}
  MDPROPVAL_MNF_LINREGSLOPE = $00000080;
  {$EXTERNALSYM MDPROPVAL_MNF_LINREGSLOPE}
  MDPROPVAL_MNF_LINREGVARIANCE = $00000100;
  {$EXTERNALSYM MDPROPVAL_MNF_LINREGVARIANCE}
  MDPROPVAL_MNF_LINREG2 = $00000200;
  {$EXTERNALSYM MDPROPVAL_MNF_LINREG2}
  MDPROPVAL_MNF_LINREGPOINT = $00000400;
  {$EXTERNALSYM MDPROPVAL_MNF_LINREGPOINT}
  MDPROPVAL_MNF_DRILLDOWNLEVEL = $00000800;
  {$EXTERNALSYM MDPROPVAL_MNF_DRILLDOWNLEVEL}
  MDPROPVAL_MNF_DRILLDOWNMEMBERTOP = $00001000;
  {$EXTERNALSYM MDPROPVAL_MNF_DRILLDOWNMEMBERTOP}
  MDPROPVAL_MNF_DRILLDOWNMEMBERBOTTOM = $00002000;
  {$EXTERNALSYM MDPROPVAL_MNF_DRILLDOWNMEMBERBOTTOM}
  MDPROPVAL_MNF_DRILLDOWNLEVELTOP = $00004000;
  {$EXTERNALSYM MDPROPVAL_MNF_DRILLDOWNLEVELTOP}
  MDPROPVAL_MNF_DRILLDOWNLEVELBOTTOM = $00008000;
  {$EXTERNALSYM MDPROPVAL_MNF_DRILLDOWNLEVELBOTTOM}
  MDPROPVAL_MNF_DRILLUPMEMBER = $00010000;
  {$EXTERNALSYM MDPROPVAL_MNF_DRILLUPMEMBER}
  MDPROPVAL_MNF_DRILLUPLEVEL = $00020000;
  {$EXTERNALSYM MDPROPVAL_MNF_DRILLUPLEVEL}
  MDPROPVAL_MSF_TOPPERCENT = $00000001;
  {$EXTERNALSYM MDPROPVAL_MSF_TOPPERCENT}
  MDPROPVAL_MSF_BOTTOMPERCENT = $00000002;
  {$EXTERNALSYM MDPROPVAL_MSF_BOTTOMPERCENT}
  MDPROPVAL_MSF_TOPSUM = $00000004;
  {$EXTERNALSYM MDPROPVAL_MSF_TOPSUM}
  MDPROPVAL_MSF_BOTTOMSUM = $00000008;
  {$EXTERNALSYM MDPROPVAL_MSF_BOTTOMSUM}
  MDPROPVAL_MSF_PERIODSTODATE = $00000010;
  {$EXTERNALSYM MDPROPVAL_MSF_PERIODSTODATE}
  MDPROPVAL_MSF_LASTPERIODS = $00000020;
  {$EXTERNALSYM MDPROPVAL_MSF_LASTPERIODS}
  MDPROPVAL_MSF_YTD = $00000040;
  {$EXTERNALSYM MDPROPVAL_MSF_YTD}
  MDPROPVAL_MSF_QTD = $00000080;
  {$EXTERNALSYM MDPROPVAL_MSF_QTD}
  MDPROPVAL_MSF_MTD = $00000100;
  {$EXTERNALSYM MDPROPVAL_MSF_MTD}
  MDPROPVAL_MSF_WTD = $00000200;
  {$EXTERNALSYM MDPROPVAL_MSF_WTD}
  MDPROPVAL_MSF_DRILLDOWNMEMBBER = $00000400;
  {$EXTERNALSYM MDPROPVAL_MSF_DRILLDOWNMEMBBER}
  MDPROPVAL_MSF_DRILLDOWNLEVEL = $00000800;
  {$EXTERNALSYM MDPROPVAL_MSF_DRILLDOWNLEVEL}
  MDPROPVAL_MSF_DRILLDOWNMEMBERTOP = $00001000;
  {$EXTERNALSYM MDPROPVAL_MSF_DRILLDOWNMEMBERTOP}
  MDPROPVAL_MSF_DRILLDOWNMEMBERBOTTOM = $00002000;
  {$EXTERNALSYM MDPROPVAL_MSF_DRILLDOWNMEMBERBOTTOM}
  MDPROPVAL_MSF_DRILLDOWNLEVELTOP = $00004000;
  {$EXTERNALSYM MDPROPVAL_MSF_DRILLDOWNLEVELTOP}
  MDPROPVAL_MSF_DRILLDOWNLEVELBOTTOM = $00008000;
  {$EXTERNALSYM MDPROPVAL_MSF_DRILLDOWNLEVELBOTTOM}
  MDPROPVAL_MSF_DRILLUPMEMBER = $00010000;
  {$EXTERNALSYM MDPROPVAL_MSF_DRILLUPMEMBER}
  MDPROPVAL_MSF_DRILLUPLEVEL = $00020000;
  {$EXTERNALSYM MDPROPVAL_MSF_DRILLUPLEVEL}
  MDPROPVAL_MSF_TOGGLEDRILLSTATE = $00040000;
  {$EXTERNALSYM MDPROPVAL_MSF_TOGGLEDRILLSTATE}
  MDPROPVAL_MD_SELF = $00000001;
  {$EXTERNALSYM MDPROPVAL_MD_SELF}
  MDPROPVAL_MD_BEFORE = $00000002;
  {$EXTERNALSYM MDPROPVAL_MD_BEFORE}
  MDPROPVAL_MD_AFTER = $00000004;
  {$EXTERNALSYM MDPROPVAL_MD_AFTER}
  MDPROPVAL_MSC_LESSTHAN = $00000001;
  {$EXTERNALSYM MDPROPVAL_MSC_LESSTHAN}
  MDPROPVAL_MSC_GREATERTHAN = $00000002;
  {$EXTERNALSYM MDPROPVAL_MSC_GREATERTHAN}
  MDPROPVAL_MSC_LESSTHANEQUAL = $00000004;
  {$EXTERNALSYM MDPROPVAL_MSC_LESSTHANEQUAL}
  MDPROPVAL_MSC_GREATERTHANEQUAL = $00000008;
  {$EXTERNALSYM MDPROPVAL_MSC_GREATERTHANEQUAL}
  MDPROPVAL_MC_SINGLECASE = $00000001;
  {$EXTERNALSYM MDPROPVAL_MC_SINGLECASE}
  MDPROPVAL_MC_SEARCHEDCASE = $00000002;
  {$EXTERNALSYM MDPROPVAL_MC_SEARCHEDCASE}
  MDPROPVAL_MOQ_OUTERREFERENCE = $00000001;
  {$EXTERNALSYM MDPROPVAL_MOQ_OUTERREFERENCE}
  MDPROPVAL_MOQ_DATASOURCE_CUBE = $00000001;
  {$EXTERNALSYM MDPROPVAL_MOQ_DATASOURCE_CUBE}
  MDPROPVAL_MOQ_CATALOG_CUBE = $00000002;
  {$EXTERNALSYM MDPROPVAL_MOQ_CATALOG_CUBE}
  MDPROPVAL_MOQ_SCHEMA_CUBE = $00000004;
  {$EXTERNALSYM MDPROPVAL_MOQ_SCHEMA_CUBE}
  MDPROPVAL_MOQ_CUBE_DIM = $00000008;
  {$EXTERNALSYM MDPROPVAL_MOQ_CUBE_DIM}
  MDPROPVAL_MOQ_DIM_HIER = $00000010;
  {$EXTERNALSYM MDPROPVAL_MOQ_DIM_HIER}
  MDPROPVAL_MOQ_DIMHIER_LEVEL = $00000020;
  {$EXTERNALSYM MDPROPVAL_MOQ_DIMHIER_LEVEL}
  MDPROPVAL_MOQ_LEVEL_MEMBER = $00000040;
  {$EXTERNALSYM MDPROPVAL_MOQ_LEVEL_MEMBER}
  MDPROPVAL_MOQ_MEMBER_MEMBER = $00000080;
  {$EXTERNALSYM MDPROPVAL_MOQ_MEMBER_MEMBER}
  MDPROPVAL_FS_FULL_SUPPORT = $00000001;
  {$EXTERNALSYM MDPROPVAL_FS_FULL_SUPPORT}
  MDPROPVAL_FS_GENERATED_COLUMN = $00000002;
  {$EXTERNALSYM MDPROPVAL_FS_GENERATED_COLUMN}
  MDPROPVAL_FS_GENERATED_DIMENSION = $00000003;
  {$EXTERNALSYM MDPROPVAL_FS_GENERATED_DIMENSION}
  MDPROPVAL_FS_NO_SUPPORT = $00000004;
  {$EXTERNALSYM MDPROPVAL_FS_NO_SUPPORT}
  MDPROPVAL_NL_NAMEDLEVELS = $00000001;
  {$EXTERNALSYM MDPROPVAL_NL_NAMEDLEVELS}
  MDPROPVAL_NL_NUMBEREDLEVELS = $00000002;
  {$EXTERNALSYM MDPROPVAL_NL_NUMBEREDLEVELS}
  MDPROPVAL_MJC_SINGLECUBE = $00000001;
  {$EXTERNALSYM MDPROPVAL_MJC_SINGLECUBE}
  MDPROPVAL_MJC_MULTICUBES = $00000002;
  {$EXTERNALSYM MDPROPVAL_MJC_MULTICUBES}
  MDPROPVAL_MJC_IMPLICITCUBE = $00000004;
  {$EXTERNALSYM MDPROPVAL_MJC_IMPLICITCUBE}
  MDPROPVAL_RR_NORANGEROWSET = $00000001;
  {$EXTERNALSYM MDPROPVAL_RR_NORANGEROWSET}
  MDPROPVAL_RR_READONLY = $00000002;
  {$EXTERNALSYM MDPROPVAL_RR_READONLY}
  MDPROPVAL_RR_UPDATE = $00000004;
  {$EXTERNALSYM MDPROPVAL_RR_UPDATE}
  MDPROPVAL_MS_MULTIPLETUPLES = $00000001;
  {$EXTERNALSYM MDPROPVAL_MS_MULTIPLETUPLES}
  MDPROPVAL_MS_SINGLETUPLE = $00000002;
  {$EXTERNALSYM MDPROPVAL_MS_SINGLETUPLE}
  DBPROPVAL_AO_SEQUENTIAL = $00000000;
  {$EXTERNALSYM DBPROPVAL_AO_SEQUENTIAL}
  DBPROPVAL_AO_SEQUENTIALSTORAGEOBJECTS = $00000001;
  {$EXTERNALSYM DBPROPVAL_AO_SEQUENTIALSTORAGEOBJECTS}
  DBPROPVAL_AO_RANDOM = $00000002;
  {$EXTERNALSYM DBPROPVAL_AO_RANDOM}
  DBPROPVAL_BD_ROWSET = $00000000;
  {$EXTERNALSYM DBPROPVAL_BD_ROWSET}
  DBPROPVAL_BD_INTRANSACTION = $00000001;
  {$EXTERNALSYM DBPROPVAL_BD_INTRANSACTION}
  DBPROPVAL_BD_XTRANSACTION = $00000002;
  {$EXTERNALSYM DBPROPVAL_BD_XTRANSACTION}
  DBPROPVAL_BD_REORGANIZATION = $00000003;
  {$EXTERNALSYM DBPROPVAL_BD_REORGANIZATION}
  BMK_DURABILITY_ROWSET = DBPROPVAL_BD_ROWSET;
  {$EXTERNALSYM BMK_DURABILITY_ROWSET}
  BMK_DURABILITY_INTRANSACTION = DBPROPVAL_BD_INTRANSACTION;
  {$EXTERNALSYM BMK_DURABILITY_INTRANSACTION}
  BMK_DURABILITY_XTRANSACTION = DBPROPVAL_BD_XTRANSACTION;
  {$EXTERNALSYM BMK_DURABILITY_XTRANSACTION}
  BMK_DURABILITY_REORGANIZATION = DBPROPVAL_BD_REORGANIZATION;
  {$EXTERNALSYM BMK_DURABILITY_REORGANIZATION}
  DBPROPVAL_BO_NOLOG = $00000000;
  {$EXTERNALSYM DBPROPVAL_BO_NOLOG}
  DBPROPVAL_BO_NOINDEXUPDATE = $00000001;
  {$EXTERNALSYM DBPROPVAL_BO_NOINDEXUPDATE}
  DBPROPVAL_BO_REFINTEGRITY = $00000002;
  {$EXTERNALSYM DBPROPVAL_BO_REFINTEGRITY}
  DBPROPVAL_STGM_READ = OF_READ;
  {$EXTERNALSYM DBPROPVAL_STGM_READ}
  DBPROPVAL_STGM_WRITE = OF_WRITE;
  {$EXTERNALSYM DBPROPVAL_STGM_WRITE}
  DBPROPVAL_STGM_READWRITE = OF_READWRITE;
  {$EXTERNALSYM DBPROPVAL_STGM_READWRITE}
  DBPROPVAL_STGM_SHARE_DENY_NONE = OF_SHARE_DENY_NONE;
  {$EXTERNALSYM DBPROPVAL_STGM_SHARE_DENY_NONE}
  DBPROPVAL_STGM_SHARE_DENY_READ = OF_SHARE_DENY_READ;
  {$EXTERNALSYM DBPROPVAL_STGM_SHARE_DENY_READ}
  DBPROPVAL_STGM_SHARE_DENY_WRITE = OF_SHARE_DENY_WRITE;
  {$EXTERNALSYM DBPROPVAL_STGM_SHARE_DENY_WRITE}
  DBPROPVAL_STGM_SHARE_EXCLUSIVE = OF_SHARE_EXCLUSIVE;
  {$EXTERNALSYM DBPROPVAL_STGM_SHARE_EXCLUSIVE}
  DBPROPVAL_STGM_DIRECT = $00010000;
  {$EXTERNALSYM DBPROPVAL_STGM_DIRECT}
  DBPROPVAL_STGM_TRANSACTED = $00020000;
  {$EXTERNALSYM DBPROPVAL_STGM_TRANSACTED}
  DBPROPVAL_STGM_CREATE = OF_CREATE;
  {$EXTERNALSYM DBPROPVAL_STGM_CREATE}
  DBPROPVAL_STGM_CONVERT = $00040000;
  {$EXTERNALSYM DBPROPVAL_STGM_CONVERT}
  DBPROPVAL_STGM_FAILIFTHERE = $00080000;
  {$EXTERNALSYM DBPROPVAL_STGM_FAILIFTHERE}
  DBPROPVAL_STGM_PRIORITY = $00100000;
  {$EXTERNALSYM DBPROPVAL_STGM_PRIORITY}
  DBPROPVAL_STGM_DELETEONRELEASE = $00200000;
  {$EXTERNALSYM DBPROPVAL_STGM_DELETEONRELEASE}
  DBPROPVAL_GB_COLLATE = $00000010;
  {$EXTERNALSYM DBPROPVAL_GB_COLLATE}
  DBPROPVAL_CS_UNINITIALIZED = $00000000;
  {$EXTERNALSYM DBPROPVAL_CS_UNINITIALIZED}
  DBPROPVAL_CS_INITIALIZED = $00000001;
  {$EXTERNALSYM DBPROPVAL_CS_INITIALIZED}
  DBPROPVAL_CS_COMMUNICATIONFAILURE = $00000002;
  {$EXTERNALSYM DBPROPVAL_CS_COMMUNICATIONFAILURE}
  DBPROPVAL_RD_RESETALL = $ffffffff;
  {$EXTERNALSYM DBPROPVAL_RD_RESETALL}
  DBPROPVAL_OS_RESOURCEPOOLING = $00000001;
  {$EXTERNALSYM DBPROPVAL_OS_RESOURCEPOOLING}
  DBPROPVAL_OS_TXNENLISTMENT = $00000002;
  {$EXTERNALSYM DBPROPVAL_OS_TXNENLISTMENT}
  DBPROPVAL_OS_CLIENTCURSOR = $00000004;
  {$EXTERNALSYM DBPROPVAL_OS_CLIENTCURSOR}
  DBPROPVAL_OS_ENABLEALL = $ffffffff;
  {$EXTERNALSYM DBPROPVAL_OS_ENABLEALL}
  DBPROPVAL_BI_CROSSROWSET = $00000001;
  {$EXTERNALSYM DBPROPVAL_BI_CROSSROWSET}
  DB_IMP_LEVEL_ANONYMOUS = $00;
  {$EXTERNALSYM DB_IMP_LEVEL_ANONYMOUS}
  DB_IMP_LEVEL_IDENTIFY = $01;
  {$EXTERNALSYM DB_IMP_LEVEL_IDENTIFY}
  DB_IMP_LEVEL_IMPERSONATE = $02;
  {$EXTERNALSYM DB_IMP_LEVEL_IMPERSONATE}
  DB_IMP_LEVEL_DELEGATE = $03;
  {$EXTERNALSYM DB_IMP_LEVEL_DELEGATE}
  DBPROMPT_PROMPT = $01;
  {$EXTERNALSYM DBPROMPT_PROMPT}
  DBPROMPT_COMPLETE = $02;
  {$EXTERNALSYM DBPROMPT_COMPLETE}
  DBPROMPT_COMPLETEREQUIRED = $03;
  {$EXTERNALSYM DBPROMPT_COMPLETEREQUIRED}
  DBPROMPT_NOPROMPT = $04;
  {$EXTERNALSYM DBPROMPT_NOPROMPT}
  DB_PROT_LEVEL_NONE = $00;
  {$EXTERNALSYM DB_PROT_LEVEL_NONE}
  DB_PROT_LEVEL_CONNECT = $01;
  {$EXTERNALSYM DB_PROT_LEVEL_CONNECT}
  DB_PROT_LEVEL_CALL = $02;
  {$EXTERNALSYM DB_PROT_LEVEL_CALL}
  DB_PROT_LEVEL_PKT = $03;
  {$EXTERNALSYM DB_PROT_LEVEL_PKT}
  DB_PROT_LEVEL_PKT_INTEGRITY = $04;
  {$EXTERNALSYM DB_PROT_LEVEL_PKT_INTEGRITY}
  DB_PROT_LEVEL_PKT_PRIVACY = $05;
  {$EXTERNALSYM DB_PROT_LEVEL_PKT_PRIVACY}
  DB_MODE_READ = $01;
  {$EXTERNALSYM DB_MODE_READ}
  DB_MODE_WRITE = $02;
  {$EXTERNALSYM DB_MODE_WRITE}
  DB_MODE_READWRITE = $03;
  {$EXTERNALSYM DB_MODE_READWRITE}
  DB_MODE_SHARE_DENY_READ = $04;
  {$EXTERNALSYM DB_MODE_SHARE_DENY_READ}
  DB_MODE_SHARE_DENY_WRITE = $08;
  {$EXTERNALSYM DB_MODE_SHARE_DENY_WRITE}
  DB_MODE_SHARE_EXCLUSIVE = $0c;
  {$EXTERNALSYM DB_MODE_SHARE_EXCLUSIVE}
  DB_MODE_SHARE_DENY_NONE = $10;
  {$EXTERNALSYM DB_MODE_SHARE_DENY_NONE}
  DBCOMPUTEMODE_COMPUTED = $01;
  {$EXTERNALSYM DBCOMPUTEMODE_COMPUTED}
  DBCOMPUTEMODE_DYNAMIC = $02;
  {$EXTERNALSYM DBCOMPUTEMODE_DYNAMIC}
  DBCOMPUTEMODE_NOTCOMPUTED = $03;
  {$EXTERNALSYM DBCOMPUTEMODE_NOTCOMPUTED}
  DBPROPVAL_DF_INITIALLY_DEFERRED = $01;
  {$EXTERNALSYM DBPROPVAL_DF_INITIALLY_DEFERRED}
  DBPROPVAL_DF_INITIALLY_IMMEDIATE = $02;
  {$EXTERNALSYM DBPROPVAL_DF_INITIALLY_IMMEDIATE}
  DBPROPVAL_DF_NOT_DEFERRABLE = $03;
  {$EXTERNALSYM DBPROPVAL_DF_NOT_DEFERRABLE}
  DBPARAMTYPE_INPUT = $01;
  {$EXTERNALSYM DBPARAMTYPE_INPUT}
  DBPARAMTYPE_INPUTOUTPUT = $02;
  {$EXTERNALSYM DBPARAMTYPE_INPUTOUTPUT}
  DBPARAMTYPE_OUTPUT = $03;
  {$EXTERNALSYM DBPARAMTYPE_OUTPUT}
  DBPARAMTYPE_RETURNVALUE = $04;
  {$EXTERNALSYM DBPARAMTYPE_RETURNVALUE}
  DB_PT_UNKNOWN = $01;
  {$EXTERNALSYM DB_PT_UNKNOWN}
  DB_PT_PROCEDURE = $02;
  {$EXTERNALSYM DB_PT_PROCEDURE}
  DB_PT_FUNCTION = $03;
  {$EXTERNALSYM DB_PT_FUNCTION}
  DB_REMOTE = $01;
  {$EXTERNALSYM DB_REMOTE}
  DB_LOCAL_SHARED = $02;
  {$EXTERNALSYM DB_LOCAL_SHARED}
  DB_LOCAL_EXCLUSIVE = $03;
  {$EXTERNALSYM DB_LOCAL_EXCLUSIVE}
  DB_COLLATION_ASC = $01;
  {$EXTERNALSYM DB_COLLATION_ASC}
  DB_COLLATION_DESC = $02;
  {$EXTERNALSYM DB_COLLATION_DESC}
  DB_UNSEARCHABLE = $01;
  {$EXTERNALSYM DB_UNSEARCHABLE}
  DB_LIKE_ONLY = $02;
  {$EXTERNALSYM DB_LIKE_ONLY}
  DB_ALL_EXCEPT_LIKE = $03;
  {$EXTERNALSYM DB_ALL_EXCEPT_LIKE}
  DB_SEARCHABLE = $04;
  {$EXTERNALSYM DB_SEARCHABLE}
  MDTREEOP_CHILDREN = $01;
  {$EXTERNALSYM MDTREEOP_CHILDREN}
  MDTREEOP_SIBLINGS = $02;
  {$EXTERNALSYM MDTREEOP_SIBLINGS}
  MDTREEOP_PARENT = $04;
  {$EXTERNALSYM MDTREEOP_PARENT}
  MDTREEOP_SELF = $08;
  {$EXTERNALSYM MDTREEOP_SELF}
  MDTREEOP_DESCENDANTS = $10;
  {$EXTERNALSYM MDTREEOP_DESCENDANTS}
  MDTREEOP_ANCESTORS = $20;
  {$EXTERNALSYM MDTREEOP_ANCESTORS}
  MD_DIMTYPE_UNKNOWN = $00;
  {$EXTERNALSYM MD_DIMTYPE_UNKNOWN}
  MD_DIMTYPE_TIME = $01;
  {$EXTERNALSYM MD_DIMTYPE_TIME}
  MD_DIMTYPE_MEASURE = $02;
  {$EXTERNALSYM MD_DIMTYPE_MEASURE}
  MD_DIMTYPE_OTHER = $03;
  {$EXTERNALSYM MD_DIMTYPE_OTHER}
  MDLEVEL_TYPE_UNKNOWN = $0000;
  {$EXTERNALSYM MDLEVEL_TYPE_UNKNOWN}
  MDLEVEL_TYPE_REGULAR = $0000;
  {$EXTERNALSYM MDLEVEL_TYPE_REGULAR}
  MDLEVEL_TYPE_ALL = $0001;
  {$EXTERNALSYM MDLEVEL_TYPE_ALL}
  MDLEVEL_TYPE_CALCULATED = $0002;
  {$EXTERNALSYM MDLEVEL_TYPE_CALCULATED}
  MDLEVEL_TYPE_TIME = $0004;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME}
  MDLEVEL_TYPE_RESERVED1 = $0008;
  {$EXTERNALSYM MDLEVEL_TYPE_RESERVED1}
  MDLEVEL_TYPE_TIME_YEARS = $0014;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_YEARS}
  MDLEVEL_TYPE_TIME_HALF_YEAR = $0024;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_HALF_YEAR}
  MDLEVEL_TYPE_TIME_QUARTERS = $0044;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_QUARTERS}
  MDLEVEL_TYPE_TIME_MONTHS = $0084;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_MONTHS}
  MDLEVEL_TYPE_TIME_WEEKS = $0104;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_WEEKS}
  MDLEVEL_TYPE_TIME_DAYS = $0204;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_DAYS}
  MDLEVEL_TYPE_TIME_HOURS = $0304;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_HOURS}
  MDLEVEL_TYPE_TIME_MINUTES = $0404;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_MINUTES}
  MDLEVEL_TYPE_TIME_SECONDS = $0804;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_SECONDS}
  MDLEVEL_TYPE_TIME_UNDEFINED = $1004;
  {$EXTERNALSYM MDLEVEL_TYPE_TIME_UNDEFINED}
  MDMEASURE_AGGR_UNKNOWN = $00;
  {$EXTERNALSYM MDMEASURE_AGGR_UNKNOWN}
  MDMEASURE_AGGR_SUM = $01;
  {$EXTERNALSYM MDMEASURE_AGGR_SUM}
  MDMEASURE_AGGR_COUNT = $02;
  {$EXTERNALSYM MDMEASURE_AGGR_COUNT}
  MDMEASURE_AGGR_MIN = $03;
  {$EXTERNALSYM MDMEASURE_AGGR_MIN}
  MDMEASURE_AGGR_MAX = $04;
  {$EXTERNALSYM MDMEASURE_AGGR_MAX}
  MDMEASURE_AGGR_AVG = $05;
  {$EXTERNALSYM MDMEASURE_AGGR_AVG}
  MDMEASURE_AGGR_VAR = $06;
  {$EXTERNALSYM MDMEASURE_AGGR_VAR}
  MDMEASURE_AGGR_STD = $07;
  {$EXTERNALSYM MDMEASURE_AGGR_STD}
  MDMEASURE_AGGR_CALCULATED = $7f;
  {$EXTERNALSYM MDMEASURE_AGGR_CALCULATED}
  MDPROP_MEMBER = $01;
  {$EXTERNALSYM MDPROP_MEMBER}
  MDPROP_CELL = $02;
  {$EXTERNALSYM MDPROP_CELL}
  MDMEMBER_TYPE_UNKNOWN = $00;
  {$EXTERNALSYM MDMEMBER_TYPE_UNKNOWN}
  MDMEMBER_TYPE_REGULAR = $01;
  {$EXTERNALSYM MDMEMBER_TYPE_REGULAR}
  MDMEMBER_TYPE_ALL = $02;
  {$EXTERNALSYM MDMEMBER_TYPE_ALL}
  MDMEMBER_TYPE_MEASURE = $03;
  {$EXTERNALSYM MDMEMBER_TYPE_MEASURE}
  MDMEMBER_TYPE_FORMULA = $04;
  {$EXTERNALSYM MDMEMBER_TYPE_FORMULA}
  MDMEMBER_TYPE_RESERVE1 = $05;
  {$EXTERNALSYM MDMEMBER_TYPE_RESERVE1}
  MDMEMBER_TYPE_RESERVE2 = $06;
  {$EXTERNALSYM MDMEMBER_TYPE_RESERVE2}
  MDMEMBER_TYPE_RESERVE3 = $07;
  {$EXTERNALSYM MDMEMBER_TYPE_RESERVE3}
  MDMEMBER_TYPE_RESERVE4 = $08;
  {$EXTERNALSYM MDMEMBER_TYPE_RESERVE4}
  MDDISPINFO_DRILLED_DOWN = $00010000;
  {$EXTERNALSYM MDDISPINFO_DRILLED_DOWN}
  MDDISPINFO_PARENT_SAME_AS_PREV = $00020000;
  {$EXTERNALSYM MDDISPINFO_PARENT_SAME_AS_PREV}
  DB_COUNTUNAVAILABLE = -1;
  {$EXTERNALSYM DB_COUNTUNAVAILABLE}
  MDFF_BOLD = $01;
  {$EXTERNALSYM MDFF_BOLD}
  MDFF_ITALIC = $02;
  {$EXTERNALSYM MDFF_ITALIC}
  MDFF_UNDERLINE = $04;
  {$EXTERNALSYM MDFF_UNDERLINE}
  MDFF_STRIKEOUT = $08;
  {$EXTERNALSYM MDFF_STRIKEOUT}
  MDAXIS_COLUMNS = $00000000;
  {$EXTERNALSYM MDAXIS_COLUMNS}
  MDAXIS_ROWS = $00000001;
  {$EXTERNALSYM MDAXIS_ROWS}
  MDAXIS_PAGES = $00000002;
  {$EXTERNALSYM MDAXIS_PAGES}
  MDAXIS_SECTIONS = $00000003;
  {$EXTERNALSYM MDAXIS_SECTIONS}
  MDAXIS_CHAPTERS = $00000004;
  {$EXTERNALSYM MDAXIS_CHAPTERS}
  MDAXIS_SLICERS = $ffffffff;
  {$EXTERNALSYM MDAXIS_SLICERS}
  GENERATE_METHOD_EXACT = 0;
  {$EXTERNALSYM GENERATE_METHOD_EXACT}
  GENERATE_METHOD_PREFIX = 1;
  {$EXTERNALSYM GENERATE_METHOD_PREFIX}
  GENERATE_METHOD_INFLECT = 2;
  {$EXTERNALSYM GENERATE_METHOD_INFLECT}
  PROPID_QUERY_RANKVECTOR = $2;
  {$EXTERNALSYM PROPID_QUERY_RANKVECTOR}
  PROPID_QUERY_RANK = $3;
  {$EXTERNALSYM PROPID_QUERY_RANK}
  PROPID_QUERY_HITCOUNT = $4;
  {$EXTERNALSYM PROPID_QUERY_HITCOUNT}
  PROPID_QUERY_ALL = $6;
  {$EXTERNALSYM PROPID_QUERY_ALL}
  PROPID_STG_CONTENTS = $13;
  {$EXTERNALSYM PROPID_STG_CONTENTS}
  VECTOR_RANK_MIN = 0;
  {$EXTERNALSYM VECTOR_RANK_MIN}
  VECTOR_RANK_MAX = 1;
  {$EXTERNALSYM VECTOR_RANK_MAX}
  VECTOR_RANK_INNER = 2;
  {$EXTERNALSYM VECTOR_RANK_INNER}
  VECTOR_RANK_DICE = 3;
  {$EXTERNALSYM VECTOR_RANK_DICE}
  VECTOR_RANK_JACCARD = 4;
  {$EXTERNALSYM VECTOR_RANK_JACCARD}
  DBSETFUNC_NONE = $0;
  {$EXTERNALSYM DBSETFUNC_NONE}
  DBSETFUNC_ALL = $1;
  {$EXTERNALSYM DBSETFUNC_ALL}
  DBSETFUNC_DISTINCT = $2;
  {$EXTERNALSYM DBSETFUNC_DISTINCT}
  PROXIMITY_UNIT_WORD = 0;
  {$EXTERNALSYM PROXIMITY_UNIT_WORD}
  PROXIMITY_UNIT_SENTENCE = 1;
  {$EXTERNALSYM PROXIMITY_UNIT_SENTENCE}
  PROXIMITY_UNIT_PARAGRAPH = 2;
  {$EXTERNALSYM PROXIMITY_UNIT_PARAGRAPH}
  PROXIMITY_UNIT_CHAPTER = 3;
  {$EXTERNALSYM PROXIMITY_UNIT_CHAPTER}
  CRESTRICTIONS_DBSCHEMA_ASSERTIONS = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_ASSERTIONS}
  CRESTRICTIONS_DBSCHEMA_CATALOGS = 1;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_CATALOGS}
  CRESTRICTIONS_DBSCHEMA_CHARACTER_SETS = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_CHARACTER_SETS}
  CRESTRICTIONS_DBSCHEMA_COLLATIONS = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_COLLATIONS}
  CRESTRICTIONS_DBSCHEMA_COLUMNS = 4;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_COLUMNS}
  CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS}
  CRESTRICTIONS_DBSCHEMA_CONSTRAINT_COLUMN_USAGE = 4;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_CONSTRAINT_COLUMN_USAGE}
  CRESTRICTIONS_DBSCHEMA_CONSTRAINT_TABLE_USAGE = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_CONSTRAINT_TABLE_USAGE}
  CRESTRICTIONS_DBSCHEMA_KEY_COLUMN_USAGE = 7;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_KEY_COLUMN_USAGE}
  CRESTRICTIONS_DBSCHEMA_REFERENTIAL_CONSTRAINTS = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_REFERENTIAL_CONSTRAINTS}
  CRESTRICTIONS_DBSCHEMA_TABLE_CONSTRAINTS = 7;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_TABLE_CONSTRAINTS}
  CRESTRICTIONS_DBSCHEMA_COLUMN_DOMAIN_USAGE = 4;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_COLUMN_DOMAIN_USAGE}
  CRESTRICTIONS_DBSCHEMA_INDEXES = 5;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_INDEXES}
  CRESTRICTIONS_DBSCHEMA_OBJECT_ACTIONS = 1;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_OBJECT_ACTIONS}
  CRESTRICTIONS_DBSCHEMA_OBJECTS = 1;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_OBJECTS}
  CRESTRICTIONS_DBSCHEMA_COLUMN_PRIVILEGES = 6;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_COLUMN_PRIVILEGES}
  CRESTRICTIONS_DBSCHEMA_TABLE_PRIVILEGES = 5;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_TABLE_PRIVILEGES}
  CRESTRICTIONS_DBSCHEMA_USAGE_PRIVILEGES = 6;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_USAGE_PRIVILEGES}
  CRESTRICTIONS_DBSCHEMA_PROCEDURES = 4;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_PROCEDURES}
  CRESTRICTIONS_DBSCHEMA_SCHEMATA = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_SCHEMATA}
  CRESTRICTIONS_DBSCHEMA_SQL_LANGUAGES = 0;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_SQL_LANGUAGES}
  CRESTRICTIONS_DBSCHEMA_STATISTICS = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_STATISTICS}
  CRESTRICTIONS_DBSCHEMA_TABLES = 4;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_TABLES}
  CRESTRICTIONS_DBSCHEMA_TRANSLATIONS = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_TRANSLATIONS}
  CRESTRICTIONS_DBSCHEMA_PROVIDER_TYPES = 2;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_PROVIDER_TYPES}
  CRESTRICTIONS_DBSCHEMA_VIEWS = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_VIEWS}
  CRESTRICTIONS_DBSCHEMA_VIEW_COLUMN_USAGE = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_VIEW_COLUMN_USAGE}
  CRESTRICTIONS_DBSCHEMA_VIEW_TABLE_USAGE = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_VIEW_TABLE_USAGE}
  CRESTRICTIONS_DBSCHEMA_PROCEDURE_PARAMETERS = 4;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_PROCEDURE_PARAMETERS}
  CRESTRICTIONS_DBSCHEMA_FOREIGN_KEYS = 6;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_FOREIGN_KEYS}
  CRESTRICTIONS_DBSCHEMA_PRIMARY_KEYS = 3;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_PRIMARY_KEYS}
  CRESTRICTIONS_DBSCHEMA_PROCEDURE_COLUMNS = 4;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_PROCEDURE_COLUMNS}
  CRESTRICTIONS_DBSCHEMA_TABLES_INFO = 4;
  {$EXTERNALSYM CRESTRICTIONS_DBSCHEMA_TABLES_INFO}
  CRESTRICTIONS_MDSCHEMA_CUBES = 3;
  {$EXTERNALSYM CRESTRICTIONS_MDSCHEMA_CUBES}
  CRESTRICTIONS_MDSCHEMA_DIMENSIONS = 5;
  {$EXTERNALSYM CRESTRICTIONS_MDSCHEMA_DIMENSIONS}
  CRESTRICTIONS_MDSCHEMA_HIERARCHIES = 6;
  {$EXTERNALSYM CRESTRICTIONS_MDSCHEMA_HIERARCHIES}
  CRESTRICTIONS_MDSCHEMA_LEVELS = 7;
  {$EXTERNALSYM CRESTRICTIONS_MDSCHEMA_LEVELS}
  CRESTRICTIONS_MDSCHEMA_MEASURES = 5;
  {$EXTERNALSYM CRESTRICTIONS_MDSCHEMA_MEASURES}
  CRESTRICTIONS_MDSCHEMA_PROPERTIES = 9;
  {$EXTERNALSYM CRESTRICTIONS_MDSCHEMA_PROPERTIES}
  CRESTRICTIONS_MDSCHEMA_MEMBERS = 12;
  {$EXTERNALSYM CRESTRICTIONS_MDSCHEMA_MEMBERS}

// *********************************************************************//
// Declaration of Enumerations                                          //
// *********************************************************************//

// TX_MISC_CONSTANTS constants

type
  TOldOleEnum = Integer;
  TOleEnum = LongWord;
  TX_MISC_CONSTANTS = TOleEnum;
  {$EXTERNALSYM TX_MISC_CONSTANTS}
const
  MAX_TRAN_DESC = $00000028;
  {$EXTERNALSYM MAX_TRAN_DESC}

// ISOLATIONLEVEL constants
type
  ISOLATIONLEVEL = TOleEnum;
  {$EXTERNALSYM ISOLATIONLEVEL}
const
  ISOLATIONLEVEL_UNSPECIFIED = $FFFFFFFF;
  {$EXTERNALSYM ISOLATIONLEVEL_UNSPECIFIED}
  ISOLATIONLEVEL_CHAOS = $00000010;
  {$EXTERNALSYM ISOLATIONLEVEL_CHAOS}
  ISOLATIONLEVEL_READUNCOMMITTED = $00000100;
  {$EXTERNALSYM ISOLATIONLEVEL_READUNCOMMITTED}
  ISOLATIONLEVEL_BROWSE = $00000100;
  {$EXTERNALSYM ISOLATIONLEVEL_BROWSE}
  ISOLATIONLEVEL_CURSORSTABILITY = $00001000;
  {$EXTERNALSYM ISOLATIONLEVEL_CURSORSTABILITY}
  ISOLATIONLEVEL_READCOMMITTED = $00001000;
  {$EXTERNALSYM ISOLATIONLEVEL_READCOMMITTED}
  ISOLATIONLEVEL_REPEATABLEREAD = $00010000;
  {$EXTERNALSYM ISOLATIONLEVEL_REPEATABLEREAD}
  ISOLATIONLEVEL_SERIALIZABLE = $00100000;
  {$EXTERNALSYM ISOLATIONLEVEL_SERIALIZABLE}
  ISOLATIONLEVEL_ISOLATED = $00100000;
  {$EXTERNALSYM ISOLATIONLEVEL_ISOLATED}

// ISOFLAG constants
type
  ISOFLAG = TOleEnum;
  {$EXTERNALSYM ISOFLAG}
const
  ISOFLAG_RETAIN_COMMIT_DC = $00000001;
  {$EXTERNALSYM ISOFLAG_RETAIN_COMMIT_DC}
  ISOFLAG_RETAIN_COMMIT = $00000002;
  {$EXTERNALSYM ISOFLAG_RETAIN_COMMIT}
  ISOFLAG_RETAIN_COMMIT_NO = $00000003;
  {$EXTERNALSYM ISOFLAG_RETAIN_COMMIT_NO}
  ISOFLAG_RETAIN_ABORT_DC = $00000004;
  {$EXTERNALSYM ISOFLAG_RETAIN_ABORT_DC}
  ISOFLAG_RETAIN_ABORT = $00000008;
  {$EXTERNALSYM ISOFLAG_RETAIN_ABORT}
  ISOFLAG_RETAIN_ABORT_NO = $0000000C;
  {$EXTERNALSYM ISOFLAG_RETAIN_ABORT_NO}
  ISOFLAG_RETAIN_DONTCARE = $00000005;
  {$EXTERNALSYM ISOFLAG_RETAIN_ABORT_NO}
  ISOFLAG_RETAIN_BOTH = $0000000A;
  {$EXTERNALSYM ISOFLAG_RETAIN_BOTH}
  ISOFLAG_RETAIN_NONE = $0000000F;
  {$EXTERNALSYM ISOFLAG_RETAIN_NONE}
  ISOFLAG_OPTIMISTIC = $00000010;
  {$EXTERNALSYM ISOFLAG_OPTIMISTIC}
  ISOFLAG_READONLY = $00000020;
  {$EXTERNALSYM ISOFLAG_READONLY}

// XACTTC constants
type
  XACTTC = TOleEnum;
  {$EXTERNALSYM XACTTC}
const
  XACTTC_SYNC_PHASEONE = $00000001;
  {$EXTERNALSYM XACTTC_SYNC_PHASEONE}
  XACTTC_SYNC_PHASETWO = $00000002;
  {$EXTERNALSYM XACTTC_SYNC_PHASETWO}
  XACTTC_SYNC = $00000002;
  {$EXTERNALSYM XACTTC_SYNC}
  XACTTC_ASYNC_PHASEONE = $00000004;
  {$EXTERNALSYM XACTTC_ASYNC_PHASEONE}
  XACTTC_ASYNC = $00000004;
  {$EXTERNALSYM XACTTC_ASYNC}

// XACTRM constants
type
  XACTRM = TOleEnum;
  {$EXTERNALSYM XACTRM}
const
  XACTRM_OPTIMISTICLASTWINS = $00000001;
  {$EXTERNALSYM XACTRM_OPTIMISTICLASTWINS}
  XACTRM_NOREADONLYPREPARES = $00000002;
  {$EXTERNALSYM XACTRM_NOREADONLYPREPARES}

// XACTCONST constants
type
  XACTCONST = TOleEnum;
  {$EXTERNALSYM XACTCONST}
const
  XACTCONST_TIMEOUTINFINITE = $00000000;
  {$EXTERNALSYM XACTCONST_TIMEOUTINFINITE}

// XACTHEURISTIC constants
type
  XACTHEURISTIC = TOleEnum;
  {$EXTERNALSYM XACTHEURISTIC}
const
  XACTHEURISTIC_ABORT = $00000001;
  {$EXTERNALSYM XACTHEURISTIC_ABORT}
  XACTHEURISTIC_COMMIT = $00000002;
  {$EXTERNALSYM XACTHEURISTIC_COMMIT}
  XACTHEURISTIC_DAMAGE = $00000003;
  {$EXTERNALSYM XACTHEURISTIC_DAMAGE}
  XACTHEURISTIC_DANGER = $00000004;
  {$EXTERNALSYM XACTHEURISTIC_DANGER}

// XACTSTAT constants
type
  XACTSTAT = TOleEnum;
  {$EXTERNALSYM XACTSTAT}
const
  XACTSTAT_NONE = $00000000;
  {$EXTERNALSYM XACTSTAT_NONE}
  XACTSTAT_OPENNORMAL = $00000001;
  {$EXTERNALSYM XACTSTAT_OPENNORMAL}
  XACTSTAT_OPENREFUSED = $00000002;
  {$EXTERNALSYM XACTSTAT_OPENREFUSED}
  XACTSTAT_PREPARING = $00000004;
  {$EXTERNALSYM XACTSTAT_PREPARING}
  XACTSTAT_PREPARED = $00000008;
  {$EXTERNALSYM XACTSTAT_PREPARED}
  XACTSTAT_PREPARERETAINING = $00000010;
  {$EXTERNALSYM XACTSTAT_PREPARERETAINING}
  XACTSTAT_PREPARERETAINED = $00000020;
  {$EXTERNALSYM XACTSTAT_PREPARERETAINED}
  XACTSTAT_COMMITTING = $00000040;
  {$EXTERNALSYM XACTSTAT_COMMITTING}
  XACTSTAT_COMMITRETAINING = $00000080;
  {$EXTERNALSYM XACTSTAT_COMMITRETAINING}
  XACTSTAT_ABORTING = $00000100;
  {$EXTERNALSYM XACTSTAT_ABORTING}
  XACTSTAT_ABORTED = $00000200;
  {$EXTERNALSYM XACTSTAT_ABORTED}
  XACTSTAT_COMMITTED = $00000400;
  {$EXTERNALSYM XACTSTAT_COMMITTED}
  XACTSTAT_HEURISTIC_ABORT = $00000800;
  {$EXTERNALSYM XACTSTAT_HEURISTIC_ABORT}
  XACTSTAT_HEURISTIC_COMMIT = $00001000;
  {$EXTERNALSYM XACTSTAT_HEURISTIC_COMMIT}
  XACTSTAT_HEURISTIC_DAMAGE = $00002000;
  {$EXTERNALSYM XACTSTAT_HEURISTIC_DAMAGE}
  XACTSTAT_HEURISTIC_DANGER = $00004000;
  {$EXTERNALSYM XACTSTAT_HEURISTIC_DANGER}
  XACTSTAT_FORCED_ABORT = $00008000;
  {$EXTERNALSYM XACTSTAT_FORCED_ABORT}
  XACTSTAT_FORCED_COMMIT = $00010000;
  {$EXTERNALSYM XACTSTAT_FORCED_COMMIT}
  XACTSTAT_INDOUBT = $00020000;
  {$EXTERNALSYM XACTSTAT_INDOUBT}
  XACTSTAT_CLOSED = $00040000;
  {$EXTERNALSYM XACTSTAT_CLOSED}
  XACTSTAT_OPEN = $00000003;
  {$EXTERNALSYM XACTSTAT_OPEN}
  XACTSTAT_NOTPREPARED = $0007FFC3;
  {$EXTERNALSYM XACTSTAT_NOTPREPARED}
  XACTSTAT_ALL = $0007FFFF;
  {$EXTERNALSYM XACTSTAT_ALL}

// XACT_E constants
type
  XACT_E = TOleEnum;
  {$EXTERNALSYM XACT_E}
const
  XACT_E_FIRST = $8004D000;
  {$EXTERNALSYM XACT_E_FIRST}
  XACT_E_LAST = $8004D01E;
  {$EXTERNALSYM XACT_E_LAST}
  XACT_S_FIRST = $0004D000;
  {$EXTERNALSYM XACT_S_FIRST}
  XACT_S_LAST = $0004D009;
  {$EXTERNALSYM XACT_S_LAST}
  XACT_E_ALREADYOTHERSINGLEPHASE = $8004D000;
  {$EXTERNALSYM XACT_E_ALREADYOTHERSINGLEPHASE}
  XACT_E_CANTRETAIN = $8004D001;
  {$EXTERNALSYM XACT_E_CANTRETAIN}
  XACT_E_COMMITFAILED = $8004D002;
  {$EXTERNALSYM XACT_E_COMMITFAILED}
  XACT_E_COMMITPREVENTED = $8004D003;
  {$EXTERNALSYM XACT_E_COMMITPREVENTED}
  XACT_E_HEURISTICABORT = $8004D004;
  {$EXTERNALSYM XACT_E_HEURISTICABORT}
  XACT_E_HEURISTICCOMMIT = $8004D005;
  {$EXTERNALSYM XACT_E_HEURISTICCOMMIT}
  XACT_E_HEURISTICDAMAGE = $8004D006;
  {$EXTERNALSYM XACT_E_HEURISTICDAMAGE}
  XACT_E_HEURISTICDANGER = $8004D007;
  {$EXTERNALSYM XACT_E_HEURISTICDANGER}
  XACT_E_ISOLATIONLEVEL = $8004D008;
  {$EXTERNALSYM XACT_E_ISOLATIONLEVEL}
  XACT_E_NOASYNC = $8004D009;
  {$EXTERNALSYM XACT_E_NOASYNC}
  XACT_E_NOENLIST = $8004D00A;
  {$EXTERNALSYM XACT_E_NOENLIST}
  XACT_E_NOISORETAIN = $8004D00B;
  {$EXTERNALSYM XACT_E_NOISORETAIN}
  XACT_E_NORESOURCE = $8004D00C;
  {$EXTERNALSYM XACT_E_NORESOURCE}
  XACT_E_NOTCURRENT = $8004D00D;
  {$EXTERNALSYM XACT_E_NOTCURRENT}
  XACT_E_NOTRANSACTION = $8004D00E;
  {$EXTERNALSYM XACT_E_NOTRANSACTION}
  XACT_E_NOTSUPPORTED = $8004D00F;
  {$EXTERNALSYM XACT_E_NOTSUPPORTED}
  XACT_E_UNKNOWNRMGRID = $8004D010;
  {$EXTERNALSYM XACT_E_UNKNOWNRMGRID}
  XACT_E_WRONGSTATE = $8004D011;
  {$EXTERNALSYM XACT_E_WRONGSTATE}
  XACT_E_WRONGUOW = $8004D012;
  {$EXTERNALSYM XACT_E_WRONGUOW}
  XACT_E_XTIONEXISTS = $8004D013;
  {$EXTERNALSYM XACT_E_XTIONEXISTS}
  XACT_E_NOIMPORTOBJECT = $8004D014;
  {$EXTERNALSYM XACT_E_NOIMPORTOBJECT}
  XACT_E_INVALIDCOOKIE = $8004D015;
  {$EXTERNALSYM XACT_E_INVALIDCOOKIE}
  XACT_E_INDOUBT = $8004D016;
  {$EXTERNALSYM XACT_E_INDOUBT}
  XACT_E_NOTIMEOUT = $8004D017;
  {$EXTERNALSYM XACT_E_NOTIMEOUT}
  XACT_E_ALREADYINPROGRESS = $8004D018;
  {$EXTERNALSYM XACT_E_ALREADYINPROGRESS}
  XACT_E_ABORTED = $8004D019;
  {$EXTERNALSYM XACT_E_ABORTED}
  XACT_E_LOGFULL = $8004D01A;
  {$EXTERNALSYM XACT_E_LOGFULL}
  XACT_E_TMNOTAVAILABLE = $8004D01B;
  {$EXTERNALSYM XACT_E_TMNOTAVAILABLE}
  XACT_E_CONNECTION_DOWN = $8004D01C;
  {$EXTERNALSYM XACT_E_CONNECTION_DOWN}
  XACT_E_CONNECTION_DENIED = $8004D01D;
  {$EXTERNALSYM XACT_E_CONNECTION_DENIED}
  XACT_E_REENLISTTIMEOUT = $8004D01E;
  {$EXTERNALSYM XACT_E_REENLISTTIMEOUT}
  XACT_S_ASYNC = $0004D000;
  {$EXTERNALSYM XACT_S_ASYNC}
  XACT_S_DEFECT = $0004D001;
  {$EXTERNALSYM XACT_S_DEFECT}
  XACT_S_READONLY = $0004D002;
  {$EXTERNALSYM XACT_S_READONLY}
  XACT_S_SOMENORETAIN = $0004D003;
  {$EXTERNALSYM XACT_S_SOMENORETAIN}
  XACT_S_OKINFORM = $0004D004;
  {$EXTERNALSYM XACT_S_OKINFORM}
  XACT_S_MADECHANGESCONTENT = $0004D005;
  {$EXTERNALSYM XACT_S_MADECHANGESCONTENT}
  XACT_S_MADECHANGESINFORM = $0004D006;
  {$EXTERNALSYM XACT_S_MADECHANGESINFORM}
  XACT_S_ALLNORETAIN = $0004D007;
  {$EXTERNALSYM XACT_S_ALLNORETAIN}
  XACT_S_ABORTING = $0004D008;
  {$EXTERNALSYM XACT_S_ABORTING}
  XACT_S_SINGLEPHASE = $0004D009;
  {$EXTERNALSYM XACT_S_SINGLEPHASE}

// DBKINDENUM constants
type
  DBKINDENUM = TOleEnum;
  {$EXTERNALSYM DBKINDENUM}
const
  DBKIND_GUID_NAME = $00000000;
  {$EXTERNALSYM DBKIND_GUID_NAME}
  DBKIND_GUID_PROPID = $00000001;
  {$EXTERNALSYM DBKIND_GUID_PROPID}
  DBKIND_NAME = $00000002;
  {$EXTERNALSYM DBKIND_NAME}
  DBKIND_PGUID_NAME = $00000003;
  {$EXTERNALSYM DBKIND_PGUID_NAME}
  DBKIND_PGUID_PROPID = $00000004;
  {$EXTERNALSYM DBKIND_PGUID_PROPID}
  DBKIND_PROPID = $00000005;
  {$EXTERNALSYM DBKIND_PROPID}
  DBKIND_GUID = $00000006;
  {$EXTERNALSYM DBKIND_GUID}

// DBTYPEENUM constants
type
  DBTYPEENUM = TOleEnum;
  {$EXTERNALSYM DBTYPEENUM}
const
  DBTYPE_EMPTY = $00000000;
  {$EXTERNALSYM DBTYPE_EMPTY}
  DBTYPE_NULL = $00000001;
  {$EXTERNALSYM DBTYPE_NULL}
  DBTYPE_I2 = $00000002;
  {$EXTERNALSYM DBTYPE_I2}
  DBTYPE_I4 = $00000003;
  {$EXTERNALSYM DBTYPE_I4}
  DBTYPE_R4 = $00000004;
  {$EXTERNALSYM DBTYPE_R4}
  DBTYPE_R8 = $00000005;
  {$EXTERNALSYM DBTYPE_R8}
  DBTYPE_CY = $00000006;
  {$EXTERNALSYM DBTYPE_CY}
  DBTYPE_DATE = $00000007;
  {$EXTERNALSYM DBTYPE_DATE}
  DBTYPE_BSTR = $00000008;
  {$EXTERNALSYM DBTYPE_BSTR}
  DBTYPE_IDISPATCH = $00000009;
  {$EXTERNALSYM DBTYPE_IDISPATCH}
  DBTYPE_ERROR = $0000000A;
  {$EXTERNALSYM DBTYPE_ERROR}
  DBTYPE_BOOL = $0000000B;
  {$EXTERNALSYM DBTYPE_BOOL}
  DBTYPE_VARIANT = $0000000C;
  {$EXTERNALSYM DBTYPE_VARIANT}
  DBTYPE_IUNKNOWN = $0000000D;
  {$EXTERNALSYM DBTYPE_IUNKNOWN}
  DBTYPE_DECIMAL = $0000000E;
  {$EXTERNALSYM DBTYPE_DECIMAL}
  DBTYPE_UI1 = $00000011;
  {$EXTERNALSYM DBTYPE_UI1}
  DBTYPE_ARRAY = $00002000;
  {$EXTERNALSYM DBTYPE_ARRAY}
  DBTYPE_BYREF = $00004000;
  {$EXTERNALSYM DBTYPE_BYREF}
  DBTYPE_I1 = $00000010;
  {$EXTERNALSYM DBTYPE_I1}
  DBTYPE_UI2 = $00000012;
  {$EXTERNALSYM DBTYPE_UI2}
  DBTYPE_UI4 = $00000013;
  {$EXTERNALSYM DBTYPE_UI4}
  DBTYPE_I8 = $00000014;
  {$EXTERNALSYM DBTYPE_I8}
  DBTYPE_UI8 = $00000015;
  {$EXTERNALSYM DBTYPE_UI8}
  DBTYPE_GUID = $00000048;
  {$EXTERNALSYM DBTYPE_GUID}
  DBTYPE_VECTOR = $00001000;
  {$EXTERNALSYM DBTYPE_VECTOR}
  DBTYPE_RESERVED = $00008000;
  {$EXTERNALSYM DBTYPE_RESERVED}
  DBTYPE_BYTES = $00000080;
  {$EXTERNALSYM DBTYPE_BYTES}
  DBTYPE_STR = $00000081;
  {$EXTERNALSYM DBTYPE_STR}
  DBTYPE_WSTR = $00000082;
  {$EXTERNALSYM DBTYPE_WSTR}
  DBTYPE_NUMERIC = $00000083;
  {$EXTERNALSYM DBTYPE_NUMERIC}
  DBTYPE_UDT = $00000084;
  {$EXTERNALSYM DBTYPE_UDT}
  DBTYPE_DBDATE = $00000085;
  {$EXTERNALSYM DBTYPE_DBDATE}
  DBTYPE_DBTIME = $00000086;
  {$EXTERNALSYM DBTYPE_DBTIME}
  DBTYPE_DBTIMESTAMP = $00000087;
  {$EXTERNALSYM DBTYPE_DBTIMESTAMP}

// DBTYPEENUM15 constants
type
  DBTYPEENUM15 = TOleEnum;
  {$EXTERNALSYM DBTYPEENUM15}
const
  DBTYPE_HCHAPTER = $00000088;
  {$EXTERNALSYM DBTYPE_HCHAPTER}

// DBTYPEENUM20 constants
type
  DBTYPEENUM20 = TOleEnum;
  {$EXTERNALSYM DBTYPEENUM20}
const
  DBTYPE_FILETIME = $00000040;
  {$EXTERNALSYM DBTYPE_FILETIME}
  DBTYPE_DBFILETIME = $00000089;
  {$EXTERNALSYM DBTYPE_DBFILETIME}
  DBTYPE_PROPVARIANT = $0000008A;
  {$EXTERNALSYM DBTYPE_PROPVARIANT}
  DBTYPE_VARNUMERIC = $0000008B;
  {$EXTERNALSYM DBTYPE_VARNUMERIC}

// DBPARTENUM constants
type
  DBPARTENUM = TOleEnum;
  {$EXTERNALSYM DBPARTENUM}
const
  DBPART_INVALID = $00000000;
  {$EXTERNALSYM DBPART_INVALID}
  DBPART_VALUE = $00000001;
  {$EXTERNALSYM DBPART_VALUE}
  DBPART_LENGTH = $00000002;
  {$EXTERNALSYM DBPART_LENGTH}
  DBPART_STATUS = $00000004;
  {$EXTERNALSYM DBPART_STATUS}

// DBPARAMIOENUM constants
type
  DBPARAMIOENUM = TOleEnum;
  {$EXTERNALSYM DBPARAMIOENUM}
const
  DBPARAMIO_NOTPARAM = $00000000;
  {$EXTERNALSYM DBPARAMIO_NOTPARAM}
  DBPARAMIO_INPUT = $00000001;
  {$EXTERNALSYM DBPARAMIO_INPUT}
  DBPARAMIO_OUTPUT = $00000002;
  {$EXTERNALSYM DBPARAMIO_OUTPUT}

// DBBINDFLAGENUM constants
type
  DBBINDFLAGENUM = TOleEnum;
  {$EXTERNALSYM DBBINDFLAGENUM}
const
  DBBINDFLAG_HTML = $00000001;
  {$EXTERNALSYM DBBINDFLAG_HTML}

// DBMEMOWNERENUM constants
type
  DBMEMOWNERENUM = TOleEnum;
  {$EXTERNALSYM DBMEMOWNERENUM}
const
  DBMEMOWNER_CLIENTOWNED = $00000000;
  {$EXTERNALSYM DBMEMOWNER_CLIENTOWNED}
  DBMEMOWNER_PROVIDEROWNED = $00000001;
  {$EXTERNALSYM DBMEMOWNER_PROVIDEROWNED}

// DBSTATUSENUM constants
type
  DBSTATUSENUM = TOleEnum;
  {$EXTERNALSYM DBSTATUSENUM}
const
  DBSTATUS_S_OK = $00000000;
  {$EXTERNALSYM DBSTATUS_S_OK}
  DBSTATUS_E_BADACCESSOR = $00000001;
  {$EXTERNALSYM DBSTATUS_E_BADACCESSOR}
  DBSTATUS_E_CANTCONVERTVALUE = $00000002;
  {$EXTERNALSYM DBSTATUS_E_CANTCONVERTVALUE}
  DBSTATUS_S_ISNULL = $00000003;
  {$EXTERNALSYM DBSTATUS_S_ISNULL}
  DBSTATUS_S_TRUNCATED = $00000004;
  {$EXTERNALSYM DBSTATUS_S_TRUNCATED}
  DBSTATUS_E_SIGNMISMATCH = $00000005;
  {$EXTERNALSYM DBSTATUS_E_SIGNMISMATCH}
  DBSTATUS_E_DATAOVERFLOW = $00000006;
  {$EXTERNALSYM DBSTATUS_E_DATAOVERFLOW}
  DBSTATUS_E_CANTCREATE = $00000007;
  {$EXTERNALSYM DBSTATUS_E_CANTCREATE}
  DBSTATUS_E_UNAVAILABLE = $00000008;
  {$EXTERNALSYM DBSTATUS_E_UNAVAILABLE}
  DBSTATUS_E_PERMISSIONDENIED = $00000009;
  {$EXTERNALSYM DBSTATUS_E_PERMISSIONDENIED}
  DBSTATUS_E_INTEGRITYVIOLATION = $0000000A;
  {$EXTERNALSYM DBSTATUS_E_INTEGRITYVIOLATION}
  DBSTATUS_E_SCHEMAVIOLATION = $0000000B;
  {$EXTERNALSYM DBSTATUS_E_SCHEMAVIOLATION}
  DBSTATUS_E_BADSTATUS = $0000000C;
  {$EXTERNALSYM DBSTATUS_E_BADSTATUS}
  DBSTATUS_S_DEFAULT = $0000000D;
  {$EXTERNALSYM DBSTATUS_S_DEFAULT}

// DBSTATUSENUM20 constants
type
  DBSTATUSENUM20 = TOleEnum;
  {$EXTERNALSYM DBSTATUSENUM20}
const
  MDSTATUS_S_CELLEMPTY = $0000000E;
  {$EXTERNALSYM MDSTATUS_S_CELLEMPTY}
  DBSTATUS_S_IGNORE = $0000000F;
  {$EXTERNALSYM DBSTATUS_S_IGNORE}

// DBROWSTATUSENUM constants
type
  DBROWSTATUSENUM = TOleEnum;
  {$EXTERNALSYM DBROWSTATUSENUM}
const
  DBROWSTATUS_S_OK = $00000000;
  {$EXTERNALSYM DBROWSTATUS_S_OK}
  DBROWSTATUS_S_MULTIPLECHANGES = $00000002;
  {$EXTERNALSYM DBROWSTATUS_S_MULTIPLECHANGES}
  DBROWSTATUS_S_PENDINGCHANGES = $00000003;
  {$EXTERNALSYM DBROWSTATUS_S_PENDINGCHANGES}
  DBROWSTATUS_E_CANCELED = $00000004;
  {$EXTERNALSYM DBROWSTATUS_E_CANCELED}
  DBROWSTATUS_E_CANTRELEASE = $00000006;
  {$EXTERNALSYM DBROWSTATUS_E_CANTRELEASE}
  DBROWSTATUS_E_CONCURRENCYVIOLATION = $00000007;
  {$EXTERNALSYM DBROWSTATUS_E_CONCURRENCYVIOLATION}
  DBROWSTATUS_E_DELETED = $00000008;
  {$EXTERNALSYM DBROWSTATUS_E_DELETED}
  DBROWSTATUS_E_PENDINGINSERT = $00000009;
  {$EXTERNALSYM DBROWSTATUS_E_PENDINGINSERT}
  DBROWSTATUS_E_NEWLYINSERTED = $0000000A;
  {$EXTERNALSYM DBROWSTATUS_E_NEWLYINSERTED}
  DBROWSTATUS_E_INTEGRITYVIOLATION = $0000000B;
  {$EXTERNALSYM DBROWSTATUS_E_INTEGRITYVIOLATION}
  DBROWSTATUS_E_INVALID = $0000000C;
  {$EXTERNALSYM DBROWSTATUS_E_INVALID}
  DBROWSTATUS_E_MAXPENDCHANGESEXCEEDED = $0000000D;
  {$EXTERNALSYM DBROWSTATUS_E_MAXPENDCHANGESEXCEEDED}
  DBROWSTATUS_E_OBJECTOPEN = $0000000E;
  {$EXTERNALSYM DBROWSTATUS_E_OBJECTOPEN}
  DBROWSTATUS_E_OUTOFMEMORY = $0000000F;
  {$EXTERNALSYM DBROWSTATUS_E_OUTOFMEMORY}
  DBROWSTATUS_E_PERMISSIONDENIED = $00000010;
  {$EXTERNALSYM DBROWSTATUS_E_PERMISSIONDENIED}
  DBROWSTATUS_E_LIMITREACHED = $00000011;
  {$EXTERNALSYM DBROWSTATUS_E_LIMITREACHED}
  DBROWSTATUS_E_SCHEMAVIOLATION = $00000012;
  {$EXTERNALSYM DBROWSTATUS_E_SCHEMAVIOLATION}
  DBROWSTATUS_E_FAIL = $00000013;
  {$EXTERNALSYM DBROWSTATUS_E_FAIL}

// DBROWSTATUSENUM20 constants
type
  DBROWSTATUSENUM20 = TOleEnum;
  {$EXTERNALSYM DBROWSTATUSENUM20}
const
  DBROWSTATUS_S_NOCHANGE = $00000014;
  {$EXTERNALSYM DBROWSTATUS_S_NOCHANGE}

// DBCOLUMNFLAGSENUM constants
type
  DBCOLUMNFLAGSENUM = TOleEnum;
  {$EXTERNALSYM DBCOLUMNFLAGSENUM}
const
  DBCOLUMNFLAGS_ISBOOKMARK = $00000001;
  {$EXTERNALSYM DBCOLUMNFLAGS_ISBOOKMARK}
  DBCOLUMNFLAGS_MAYDEFER = $00000002;
  {$EXTERNALSYM DBCOLUMNFLAGS_MAYDEFER}
  DBCOLUMNFLAGS_WRITE = $00000004;
  {$EXTERNALSYM DBCOLUMNFLAGS_WRITE}
  DBCOLUMNFLAGS_WRITEUNKNOWN = $00000008;
  {$EXTERNALSYM DBCOLUMNFLAGS_WRITEUNKNOWN}
  DBCOLUMNFLAGS_ISFIXEDLENGTH = $00000010;
  {$EXTERNALSYM DBCOLUMNFLAGS_ISFIXEDLENGTH}
  DBCOLUMNFLAGS_ISNULLABLE = $00000020;
  {$EXTERNALSYM DBCOLUMNFLAGS_ISNULLABLE}
  DBCOLUMNFLAGS_MAYBENULL = $00000040;
  {$EXTERNALSYM DBCOLUMNFLAGS_MAYBENULL}
  DBCOLUMNFLAGS_ISLONG = $00000080;
  {$EXTERNALSYM DBCOLUMNFLAGS_ISLONG}
  DBCOLUMNFLAGS_ISROWID = $00000100;
  {$EXTERNALSYM DBCOLUMNFLAGS_ISROWID}
  DBCOLUMNFLAGS_ISROWVER = $00000200;
  {$EXTERNALSYM DBCOLUMNFLAGS_ISROWVER}
  DBCOLUMNFLAGS_CACHEDEFERRED = $00001000;
  {$EXTERNALSYM DBCOLUMNFLAGS_CACHEDEFERRED}

// DBCOLUMNFLAGSENUM20 constants
type
  DBCOLUMNFLAGSENUM20 = TOleEnum;
  {$EXTERNALSYM DBCOLUMNFLAGSENUM20}
const
  DBCOLUMNFLAGS_SCALEISNEGATIVE = $00004000;
  {$EXTERNALSYM DBCOLUMNFLAGS_SCALEISNEGATIVE}
  DBCOLUMNFLAGS_KEYCOLUMN = $00008000;
  {$EXTERNALSYM DBCOLUMNFLAGS_KEYCOLUMN}

// DBCOLUMNFLAGS15ENUM constants
type
  DBCOLUMNFLAGS15ENUM = TOleEnum;
  {$EXTERNALSYM DBCOLUMNFLAGS15ENUM}
const
  DBCOLUMNFLAGS_ISCHAPTER = $00002000;
  {$EXTERNALSYM DBCOLUMNFLAGS_ISCHAPTER}

// DBBOOKMARK constants
type
  DBBOOKMARK = TOleEnum;
  {$EXTERNALSYM DBBOOKMARK}
const
  DBBMK_INVALID = $00000000;
  {$EXTERNALSYM DBBMK_INVALID}
  DBBMK_FIRST = $00000001;
  {$EXTERNALSYM DBBMK_FIRST}
  DBBMK_LAST = $00000002;
  {$EXTERNALSYM DBBMK_LAST}

// DBPROPENUM constants
type
  DBPROPENUM = TOleEnum;
  {$EXTERNALSYM DBPROPENUM}
const
  DBPROP_ABORTPRESERVE = $00000002;
  {$EXTERNALSYM DBPROP_ABORTPRESERVE}
  DBPROP_ACTIVESESSIONS = $00000003;
  {$EXTERNALSYM DBPROP_ACTIVESESSIONS}
  DBPROP_APPENDONLY = $000000BB;
  {$EXTERNALSYM DBPROP_APPENDONLY}
  DBPROP_ASYNCTXNABORT = $000000A8;
  {$EXTERNALSYM DBPROP_ASYNCTXNABORT}
  DBPROP_ASYNCTXNCOMMIT = $00000004;
  {$EXTERNALSYM DBPROP_ASYNCTXNCOMMIT}
  DBPROP_AUTH_CACHE_AUTHINFO = $00000005;
  {$EXTERNALSYM DBPROP_AUTH_CACHE_AUTHINFO}
  DBPROP_AUTH_ENCRYPT_PASSWORD = $00000006;
  {$EXTERNALSYM DBPROP_AUTH_ENCRYPT_PASSWORD}
  DBPROP_AUTH_INTEGRATED = $00000007;
  {$EXTERNALSYM DBPROP_AUTH_INTEGRATED}
  DBPROP_AUTH_MASK_PASSWORD = $00000008;
  {$EXTERNALSYM DBPROP_AUTH_MASK_PASSWORD}
  DBPROP_AUTH_PASSWORD = $00000009;
  {$EXTERNALSYM DBPROP_AUTH_PASSWORD}
  DBPROP_AUTH_PERSIST_ENCRYPTED = $0000000A;
  {$EXTERNALSYM DBPROP_AUTH_PERSIST_ENCRYPTED}
  DBPROP_AUTH_PERSIST_SENSITIVE_AUTHINFO = $0000000B;
  {$EXTERNALSYM DBPROP_AUTH_PERSIST_SENSITIVE_AUTHINFO}
  DBPROP_AUTH_USERID = $0000000C;
  {$EXTERNALSYM DBPROP_AUTH_USERID}
  DBPROP_BLOCKINGSTORAGEOBJECTS = $0000000D;
  {$EXTERNALSYM DBPROP_BLOCKINGSTORAGEOBJECTS}
  DBPROP_BOOKMARKS = $0000000E;
  {$EXTERNALSYM DBPROP_BOOKMARKS}
  DBPROP_BOOKMARKSKIPPED = $0000000F;
  {$EXTERNALSYM DBPROP_BOOKMARKSKIPPED}
  DBPROP_BOOKMARKTYPE = $00000010;
  {$EXTERNALSYM DBPROP_BOOKMARKTYPE}
  DBPROP_BYREFACCESSORS = $00000078;
  {$EXTERNALSYM DBPROP_BYREFACCESSORS}
  DBPROP_CACHEDEFERRED = $00000011;
  {$EXTERNALSYM DBPROP_CACHEDEFERRED}
  DBPROP_CANFETCHBACKWARDS = $00000012;
  {$EXTERNALSYM DBPROP_CANFETCHBACKWARDS}
  DBPROP_CANHOLDROWS = $00000013;
  {$EXTERNALSYM DBPROP_CANHOLDROWS}
  DBPROP_CANSCROLLBACKWARDS = $00000015;
  {$EXTERNALSYM DBPROP_CANSCROLLBACKWARDS}
  DBPROP_CATALOGLOCATION = $00000016;
  {$EXTERNALSYM DBPROP_CATALOGLOCATION}
  DBPROP_CATALOGTERM = $00000017;
  {$EXTERNALSYM DBPROP_CATALOGTERM}
  DBPROP_CATALOGUSAGE = $00000018;
  {$EXTERNALSYM DBPROP_CATALOGUSAGE}
  DBPROP_CHANGEINSERTEDROWS = $000000BC;
  {$EXTERNALSYM DBPROP_CHANGEINSERTEDROWS}
  DBPROP_COL_AUTOINCREMENT = $0000001A;
  {$EXTERNALSYM DBPROP_COL_AUTOINCREMENT}
  DBPROP_COL_DEFAULT = $0000001B;
  {$EXTERNALSYM DBPROP_COL_DEFAULT}
  DBPROP_COL_DESCRIPTION = $0000001C;
  {$EXTERNALSYM DBPROP_COL_DESCRIPTION}
  DBPROP_COL_FIXEDLENGTH = $000000A7;
  {$EXTERNALSYM DBPROP_COL_FIXEDLENGTH}
  DBPROP_COL_NULLABLE = $0000001D;
  {$EXTERNALSYM DBPROP_COL_NULLABLE}
  DBPROP_COL_PRIMARYKEY = $0000001E;
  {$EXTERNALSYM DBPROP_COL_PRIMARYKEY}
  DBPROP_COL_UNIQUE = $0000001F;
  {$EXTERNALSYM DBPROP_COL_UNIQUE}
  DBPROP_COLUMNDEFINITION = $00000020;
  {$EXTERNALSYM DBPROP_COLUMNDEFINITION}
  DBPROP_COLUMNRESTRICT = $00000021;
  {$EXTERNALSYM DBPROP_COLUMNRESTRICT}
  DBPROP_COMMANDTIMEOUT = $00000022;
  {$EXTERNALSYM DBPROP_COMMANDTIMEOUT}
  DBPROP_COMMITPRESERVE = $00000023;
  {$EXTERNALSYM DBPROP_COMMITPRESERVE}
  DBPROP_CONCATNULLBEHAVIOR = $00000024;
  {$EXTERNALSYM DBPROP_CONCATNULLBEHAVIOR}
  DBPROP_CURRENTCATALOG = $00000025;
  {$EXTERNALSYM DBPROP_CURRENTCATALOG}
  DBPROP_DATASOURCENAME = $00000026;
  {$EXTERNALSYM DBPROP_DATASOURCENAME}
  DBPROP_DATASOURCEREADONLY = $00000027;
  {$EXTERNALSYM DBPROP_DATASOURCEREADONLY}
  DBPROP_DBMSNAME = $00000028;
  {$EXTERNALSYM DBPROP_DBMSNAME}
  DBPROP_DBMSVER = $00000029;
  {$EXTERNALSYM DBPROP_DBMSVER}
  DBPROP_DEFERRED = $0000002A;
  {$EXTERNALSYM DBPROP_DEFERRED}
  DBPROP_DELAYSTORAGEOBJECTS = $0000002B;
  {$EXTERNALSYM DBPROP_DELAYSTORAGEOBJECTS}
  DBPROP_DSOTHREADMODEL = $000000A9;
  {$EXTERNALSYM DBPROP_DSOTHREADMODEL}
  DBPROP_GROUPBY = $0000002C;
  {$EXTERNALSYM DBPROP_GROUPBY}
  DBPROP_HETEROGENEOUSTABLES = $0000002D;
  {$EXTERNALSYM DBPROP_HETEROGENEOUSTABLES}
  DBPROP_IAccessor = $00000079;
  {$EXTERNALSYM DBPROP_IAccessor}
  DBPROP_IColumnsInfo = $0000007A;
  {$EXTERNALSYM DBPROP_IColumnsInfo}
  DBPROP_IColumnsRowset = $0000007B;
  {$EXTERNALSYM DBPROP_IColumnsRowset}
  DBPROP_IConnectionPointContainer = $0000007C;
  {$EXTERNALSYM DBPROP_IConnectionPointContainer}
  DBPROP_IConvertType = $000000C2;
  {$EXTERNALSYM DBPROP_IConvertType}
  DBPROP_IRowset = $0000007E;
  {$EXTERNALSYM DBPROP_IRowset}
  DBPROP_IRowsetChange = $0000007F;
  {$EXTERNALSYM DBPROP_IRowsetChange}
  DBPROP_IRowsetIdentity = $00000080;
  {$EXTERNALSYM DBPROP_IRowsetIdentity}
  DBPROP_IRowsetIndex = $0000009F;
  {$EXTERNALSYM DBPROP_IRowsetIndex}
  DBPROP_IRowsetInfo = $00000081;
  {$EXTERNALSYM DBPROP_IRowsetInfo}
  DBPROP_IRowsetLocate = $00000082;
  {$EXTERNALSYM DBPROP_IRowsetLocate}
  DBPROP_IRowsetResynch = $00000084;
  {$EXTERNALSYM DBPROP_IRowsetResynch}
  DBPROP_IRowsetScroll = $00000085;
  {$EXTERNALSYM DBPROP_IRowsetScroll}
  DBPROP_IRowsetUpdate = $00000086;
  {$EXTERNALSYM DBPROP_IRowsetUpdate}
  DBPROP_ISupportErrorInfo = $00000087;
  {$EXTERNALSYM DBPROP_ISupportErrorInfo}
  DBPROP_ILockBytes = $00000088;
  {$EXTERNALSYM DBPROP_ILockBytes}
  DBPROP_ISequentialStream = $00000089;
  {$EXTERNALSYM DBPROP_ISequentialStream}
  DBPROP_IStorage = $0000008A;
  {$EXTERNALSYM DBPROP_IStorage}
  DBPROP_IStream = $0000008B;
  {$EXTERNALSYM DBPROP_IStream}
  DBPROP_IDENTIFIERCASE = $0000002E;
  {$EXTERNALSYM DBPROP_IDENTIFIERCASE}
  DBPROP_IMMOBILEROWS = $0000002F;
  {$EXTERNALSYM DBPROP_IMMOBILEROWS}
  DBPROP_INDEX_AUTOUPDATE = $00000030;
  {$EXTERNALSYM DBPROP_INDEX_AUTOUPDATE}
  DBPROP_INDEX_CLUSTERED = $00000031;
  {$EXTERNALSYM DBPROP_INDEX_CLUSTERED}
  DBPROP_INDEX_FILLFACTOR = $00000032;
  {$EXTERNALSYM DBPROP_INDEX_FILLFACTOR}
  DBPROP_INDEX_INITIALSIZE = $00000033;
  {$EXTERNALSYM DBPROP_INDEX_INITIALSIZE}
  DBPROP_INDEX_NULLCOLLATION = $00000034;
  {$EXTERNALSYM DBPROP_INDEX_NULLCOLLATION}
  DBPROP_INDEX_NULLS = $00000035;
  {$EXTERNALSYM DBPROP_INDEX_NULLS}
  DBPROP_INDEX_PRIMARYKEY = $00000036;
  {$EXTERNALSYM DBPROP_INDEX_PRIMARYKEY}
  DBPROP_INDEX_SORTBOOKMARKS = $00000037;
  {$EXTERNALSYM DBPROP_INDEX_SORTBOOKMARKS}
  DBPROP_INDEX_TEMPINDEX = $000000A3;
  {$EXTERNALSYM DBPROP_INDEX_TEMPINDEX}
  DBPROP_INDEX_TYPE = $00000038;
  {$EXTERNALSYM DBPROP_INDEX_TYPE}
  DBPROP_INDEX_UNIQUE = $00000039;
  {$EXTERNALSYM DBPROP_INDEX_UNIQUE}
  DBPROP_INIT_DATASOURCE = $0000003B;
  {$EXTERNALSYM DBPROP_INIT_DATASOURCE}
  DBPROP_INIT_HWND = $0000003C;
  {$EXTERNALSYM DBPROP_INIT_HWND}
  DBPROP_INIT_IMPERSONATION_LEVEL = $0000003D;
  {$EXTERNALSYM DBPROP_INIT_IMPERSONATION_LEVEL}
  DBPROP_INIT_LCID = $000000BA;
  {$EXTERNALSYM DBPROP_INIT_LCID}
  DBPROP_INIT_LOCATION = $0000003E;
  {$EXTERNALSYM DBPROP_INIT_LOCATION}
  DBPROP_INIT_MODE = $0000003F;
  {$EXTERNALSYM DBPROP_INIT_MODE}
  DBPROP_INIT_PROMPT = $00000040;
  {$EXTERNALSYM DBPROP_INIT_PROMPT}
  DBPROP_INIT_PROTECTION_LEVEL = $00000041;
  {$EXTERNALSYM DBPROP_INIT_PROTECTION_LEVEL}
  DBPROP_INIT_PROVIDERSTRING = $000000A0;
  {$EXTERNALSYM DBPROP_INIT_PROVIDERSTRING}
  DBPROP_INIT_TIMEOUT = $00000042;
  {$EXTERNALSYM DBPROP_INIT_TIMEOUT}
  DBPROP_LITERALBOOKMARKS = $00000043;
  {$EXTERNALSYM DBPROP_LITERALBOOKMARKS}
  DBPROP_LITERALIDENTITY = $00000044;
  {$EXTERNALSYM DBPROP_LITERALIDENTITY}
  DBPROP_MARSHALLABLE = $000000C5;
  {$EXTERNALSYM DBPROP_MARSHALLABLE}
  DBPROP_MAXINDEXSIZE = $00000046;
  {$EXTERNALSYM DBPROP_MAXINDEXSIZE}
  DBPROP_MAXOPENROWS = $00000047;
  {$EXTERNALSYM DBPROP_MAXOPENROWS}
  DBPROP_MAXPENDINGROWS = $00000048;
  {$EXTERNALSYM DBPROP_MAXPENDINGROWS}
  DBPROP_MAXROWS = $00000049;
  {$EXTERNALSYM DBPROP_MAXROWS}
  DBPROP_MAXROWSIZE = $0000004A;
  {$EXTERNALSYM DBPROP_MAXROWSIZE}
  DBPROP_MAXROWSIZEINCLUDESBLOB = $0000004B;
  {$EXTERNALSYM DBPROP_MAXROWSIZEINCLUDESBLOB}
  DBPROP_MAXTABLESINSELECT = $0000004C;
  {$EXTERNALSYM DBPROP_MAXTABLESINSELECT}
  DBPROP_MAYWRITECOLUMN = $0000004D;
  {$EXTERNALSYM DBPROP_MAYWRITECOLUMN}
  DBPROP_MEMORYUSAGE = $0000004E;
  {$EXTERNALSYM DBPROP_MEMORYUSAGE}
  DBPROP_MULTIPLEPARAMSETS = $000000BF;
  {$EXTERNALSYM DBPROP_MULTIPLEPARAMSETS}
  DBPROP_MULTIPLERESULTS = $000000C4;
  {$EXTERNALSYM DBPROP_MULTIPLERESULTS}
  DBPROP_MULTIPLESTORAGEOBJECTS = $00000050;
  {$EXTERNALSYM DBPROP_MULTIPLESTORAGEOBJECTS}
  DBPROP_MULTITABLEUPDATE = $00000051;
  {$EXTERNALSYM DBPROP_MULTITABLEUPDATE}
  DBPROP_NOTIFICATIONGRANULARITY = $000000C6;
  {$EXTERNALSYM DBPROP_NOTIFICATIONGRANULARITY}
  DBPROP_NOTIFICATIONPHASES = $00000052;
  {$EXTERNALSYM DBPROP_NOTIFICATIONPHASES}
  DBPROP_NOTIFYCOLUMNSET = $000000AB;
  {$EXTERNALSYM DBPROP_NOTIFYCOLUMNSET}
  DBPROP_NOTIFYROWDELETE = $000000AD;
  {$EXTERNALSYM DBPROP_NOTIFYROWDELETE}
  DBPROP_NOTIFYROWFIRSTCHANGE = $000000AE;
  {$EXTERNALSYM DBPROP_NOTIFYROWFIRSTCHANGE}
  DBPROP_NOTIFYROWINSERT = $000000AF;
  {$EXTERNALSYM DBPROP_NOTIFYROWINSERT}
  DBPROP_NOTIFYROWRESYNCH = $000000B1;
  {$EXTERNALSYM DBPROP_NOTIFYROWRESYNCH}
  DBPROP_NOTIFYROWSETCHANGED = $000000D3;
  {$EXTERNALSYM DBPROP_NOTIFYROWSETCHANGED}
  DBPROP_NOTIFYROWSETRELEASE = $000000B2;
  {$EXTERNALSYM DBPROP_NOTIFYROWSETRELEASE}
  DBPROP_NOTIFYROWSETFETCHPOSITIONCHANGE = $000000B3;
  {$EXTERNALSYM DBPROP_NOTIFYROWSETFETCHPOSITIONCHANGE}
  DBPROP_NOTIFYROWUNDOCHANGE = $000000B4;
  {$EXTERNALSYM DBPROP_NOTIFYROWUNDOCHANGE}
  DBPROP_NOTIFYROWUNDODELETE = $000000B5;
  {$EXTERNALSYM DBPROP_NOTIFYROWUNDODELETE}
  DBPROP_NOTIFYROWUNDOINSERT = $000000B6;
  {$EXTERNALSYM DBPROP_NOTIFYROWUNDOINSERT}
  DBPROP_NOTIFYROWUPDATE = $000000B7;
  {$EXTERNALSYM DBPROP_NOTIFYROWUPDATE}
  DBPROP_NULLCOLLATION = $00000053;
  {$EXTERNALSYM DBPROP_NULLCOLLATION}
  DBPROP_OLEOBJECTS = $00000054;
  {$EXTERNALSYM DBPROP_OLEOBJECTS}
  DBPROP_ORDERBYCOLUMNSINSELECT = $00000055;
  {$EXTERNALSYM DBPROP_ORDERBYCOLUMNSINSELECT}
  DBPROP_ORDEREDBOOKMARKS = $00000056;
  {$EXTERNALSYM DBPROP_ORDEREDBOOKMARKS}
  DBPROP_OTHERINSERT = $00000057;
  {$EXTERNALSYM DBPROP_OTHERINSERT}
  DBPROP_OTHERUPDATEDELETE = $00000058;
  {$EXTERNALSYM DBPROP_OTHERUPDATEDELETE}
  DBPROP_OUTPUTPARAMETERAVAILABILITY = $000000B8;
  {$EXTERNALSYM DBPROP_OUTPUTPARAMETERAVAILABILITY}
  DBPROP_OWNINSERT = $00000059;
  {$EXTERNALSYM DBPROP_OWNINSERT}
  DBPROP_OWNUPDATEDELETE = $0000005A;
  {$EXTERNALSYM DBPROP_OWNUPDATEDELETE}
  DBPROP_PERSISTENTIDTYPE = $000000B9;
  {$EXTERNALSYM DBPROP_PERSISTENTIDTYPE}
  DBPROP_PREPAREABORTBEHAVIOR = $0000005B;
  {$EXTERNALSYM DBPROP_PREPAREABORTBEHAVIOR}
  DBPROP_PREPARECOMMITBEHAVIOR = $0000005C;
  {$EXTERNALSYM DBPROP_PREPARECOMMITBEHAVIOR}
  DBPROP_PROCEDURETERM = $0000005D;
  {$EXTERNALSYM DBPROP_PROCEDURETERM}
  DBPROP_PROVIDERNAME = $00000060;
  {$EXTERNALSYM DBPROP_PROVIDERNAME}
  DBPROP_PROVIDERFILENAME = DBPROP_PROVIDERNAME;
  {$EXTERNALSYM DBPROP_PROVIDERFILENAME}
  DBPROP_PROVIDEROLEDBVER = $00000061;
  {$EXTERNALSYM DBPROP_PROVIDEROLEDBVER}
  DBPROP_PROVIDERVER = $00000062;
  {$EXTERNALSYM DBPROP_PROVIDERVER}
  DBPROP_QUICKRESTART = $00000063;
  {$EXTERNALSYM DBPROP_QUICKRESTART}
  DBPROP_QUOTEDIDENTIFIERCASE = $00000064;
  {$EXTERNALSYM DBPROP_QUOTEDIDENTIFIERCASE}
  DBPROP_REENTRANTEVENTS = $00000065;
  {$EXTERNALSYM DBPROP_REENTRANTEVENTS}
  DBPROP_REMOVEDELETED = $00000066;
  {$EXTERNALSYM DBPROP_REMOVEDELETED}
  DBPROP_REPORTMULTIPLECHANGES = $00000067;
  {$EXTERNALSYM DBPROP_REPORTMULTIPLECHANGES}
  DBPROP_RETURNPENDINGINSERTS = $000000BD;
  {$EXTERNALSYM DBPROP_RETURNPENDINGINSERTS}
  DBPROP_ROWRESTRICT = $00000068;
  {$EXTERNALSYM DBPROP_ROWRESTRICT}
  DBPROP_ROWSETCONVERSIONSONCOMMAND = $000000C0;
  {$EXTERNALSYM DBPROP_ROWSETCONVERSIONSONCOMMAND}
  DBPROP_ROWTHREADMODEL = $00000069;
  {$EXTERNALSYM DBPROP_ROWTHREADMODEL}
  DBPROP_SCHEMATERM = $0000006A;
  {$EXTERNALSYM DBPROP_SCHEMATERM}
  DBPROP_SCHEMAUSAGE = $0000006B;
  {$EXTERNALSYM DBPROP_SCHEMAUSAGE}
  DBPROP_SERVERCURSOR = $0000006C;
  {$EXTERNALSYM DBPROP_SERVERCURSOR}
  DBPROP_SESS_AUTOCOMMITISOLEVELS = $000000BE;
  {$EXTERNALSYM DBPROP_SESS_AUTOCOMMITISOLEVELS}
  DBPROP_SQLSUPPORT = $0000006D;
  {$EXTERNALSYM DBPROP_SQLSUPPORT}
  DBPROP_STRONGIDENTITY = $00000077;
  {$EXTERNALSYM DBPROP_STRONGIDENTITY}
  DBPROP_STRUCTUREDSTORAGE = $0000006F;
  {$EXTERNALSYM DBPROP_STRUCTUREDSTORAGE}
  DBPROP_SUBQUERIES = $00000070;
  {$EXTERNALSYM DBPROP_SUBQUERIES}
  DBPROP_SUPPORTEDTXNDDL = $000000A1;
  {$EXTERNALSYM DBPROP_SUPPORTEDTXNDDL}
  DBPROP_SUPPORTEDTXNISOLEVELS = $00000071;
  {$EXTERNALSYM DBPROP_SUPPORTEDTXNISOLEVELS}
  DBPROP_SUPPORTEDTXNISORETAIN = $00000072;
  {$EXTERNALSYM DBPROP_SUPPORTEDTXNISORETAIN}
  DBPROP_TABLETERM = $00000073;
  {$EXTERNALSYM DBPROP_TABLETERM}
  DBPROP_TBL_TEMPTABLE = $0000008C;
  {$EXTERNALSYM DBPROP_TBL_TEMPTABLE}
  DBPROP_TRANSACTEDOBJECT = $00000074;
  {$EXTERNALSYM DBPROP_TRANSACTEDOBJECT}
  DBPROP_UPDATABILITY = $00000075;
  {$EXTERNALSYM DBPROP_UPDATABILITY}
  DBPROP_USERNAME = $00000076;
  {$EXTERNALSYM DBPROP_USERNAME}

// DBPROPENUM15 constants
type
  DBPROPENUM15 = TOleEnum;
  {$EXTERNALSYM DBPROPENUM15}
const
  DBPROP_FILTEROPS = $000000D0;
  {$EXTERNALSYM DBPROP_FILTEROPS}
  DBPROP_FILTERCOMPAREOPS = $000000D1;
  {$EXTERNALSYM DBPROP_FILTERCOMPAREOPS}
  DBPROP_FINDCOMPAREOPS = $000000D2;
  {$EXTERNALSYM DBPROP_FINDCOMPAREOPS}
  DBPROP_IChapteredRowset = $000000CA;
  {$EXTERNALSYM DBPROP_IChapteredRowset}
  DBPROP_IDBAsynchStatus = $000000CB;
  {$EXTERNALSYM DBPROP_IDBAsynchStatus}
  DBPROP_IRowsetFind = $000000CC;
  {$EXTERNALSYM DBPROP_IRowsetFind}
  DBPROP_IRowsetView = $000000D4;
  {$EXTERNALSYM DBPROP_IRowsetView}
  DBPROP_IViewChapter = $000000D5;
  {$EXTERNALSYM DBPROP_IViewChapter}
  DBPROP_IViewFilter = $000000D6;
  {$EXTERNALSYM DBPROP_IViewFilter}
  DBPROP_IViewRowset = $000000D7;
  {$EXTERNALSYM DBPROP_IViewRowset}
  DBPROP_IViewSort = $000000D8;
  {$EXTERNALSYM DBPROP_IViewSort}
  DBPROP_INIT_ASYNCH = $000000C8;
  {$EXTERNALSYM DBPROP_INIT_ASYNCH}
  DBPROP_MAXOPENCHAPTERS = $000000C7;
  {$EXTERNALSYM DBPROP_MAXOPENCHAPTERS}
  DBPROP_MAXORSINFILTER = $000000CD;
  {$EXTERNALSYM DBPROP_MAXORSINFILTER}
  DBPROP_MAXSORTCOLUMNS = $000000CE;
  {$EXTERNALSYM DBPROP_MAXSORTCOLUMNS}
  DBPROP_ROWSET_ASYNCH = $000000C9;
  {$EXTERNALSYM DBPROP_ROWSET_ASYNCH}
  DBPROP_SORTONINDEX = $000000CF;
  {$EXTERNALSYM DBPROP_SORTONINDEX}

// DBPROPENUM20 constants
type
  DBPROPENUM20 = TOleEnum;
  {$EXTERNALSYM DBPROPENUM20}
const
  DBPROP_IMultipleResults = $000000D9;
  {$EXTERNALSYM DBPROP_IMultipleResults}
  DBPROP_DATASOURCE_TYPE = $000000FB;
  {$EXTERNALSYM DBPROP_DATASOURCE_TYPE}
  MDPROP_AXES = $000000FC;
  {$EXTERNALSYM MDPROP_AXES}
  MDPROP_FLATTENING_SUPPORT = $000000FD;
  {$EXTERNALSYM MDPROP_FLATTENING_SUPPORT}
  MDPROP_MDX_JOINCUBES = $000000FE;
  {$EXTERNALSYM MDPROP_MDX_JOINCUBES}
  MDPROP_NAMED_LEVELS = $000000FF;
  {$EXTERNALSYM MDPROP_NAMED_LEVELS}
  MDPROP_RANGEROWSET = $00000100;
  {$EXTERNALSYM MDPROP_RANGEROWSET}
  MDPROP_MDX_SLICER = $000000DA;
  {$EXTERNALSYM MDPROP_MDX_SLICER}
  MDPROP_MDX_CUBEQUALIFICATION = $000000DB;
  {$EXTERNALSYM MDPROP_MDX_CUBEQUALIFICATION}
  MDPROP_MDX_OUTERREFERENCE = $000000DC;
  {$EXTERNALSYM MDPROP_MDX_OUTERREFERENCE}
  MDPROP_MDX_QUERYBYPROPERTY = $000000DD;
  {$EXTERNALSYM MDPROP_MDX_QUERYBYPROPERTY}
  MDPROP_MDX_CASESUPPORT = $000000DE;
  {$EXTERNALSYM MDPROP_MDX_CASESUPPORT}
  MDPROP_MDX_STRING_COMPOP = $000000E0;
  {$EXTERNALSYM MDPROP_MDX_STRING_COMPOP}
  MDPROP_MDX_DESCFLAGS = $000000E1;
  {$EXTERNALSYM MDPROP_MDX_DESCFLAGS}
  MDPROP_MDX_SET_FUNCTIONS = $000000E2;
  {$EXTERNALSYM MDPROP_MDX_SET_FUNCTIONS}
  MDPROP_MDX_MEMBER_FUNCTIONS = $000000E3;
  {$EXTERNALSYM MDPROP_MDX_MEMBER_FUNCTIONS}
  MDPROP_MDX_NUMERIC_FUNCTIONS = $000000E4;
  {$EXTERNALSYM MDPROP_MDX_NUMERIC_FUNCTIONS}
  MDPROP_MDX_FORMULAS = $000000E5;
  {$EXTERNALSYM MDPROP_MDX_FORMULAS}
  MDPROP_MDX_AGGREGATECELL_UPDATE = $000000E6;
  {$EXTERNALSYM MDPROP_MDX_AGGREGATECELL_UPDATE}
  DBPROP_ACCESSORDER = $000000E7;
  {$EXTERNALSYM DBPROP_ACCESSORDER}
  DBPROP_BOOKMARKINFO = $000000E8;
  {$EXTERNALSYM DBPROP_BOOKMARKINFO}
  DBPROP_INIT_CATALOG = $000000E9;
  {$EXTERNALSYM DBPROP_INIT_CATALOG}
  DBPROP_ROW_BULKOPS = $000000EA;
  {$EXTERNALSYM DBPROP_ROW_BULKOPS}
  DBPROP_PROVIDERFRIENDLYNAME = $000000EB;
  {$EXTERNALSYM DBPROP_PROVIDERFRIENDLYNAME}
  DBPROP_LOCKMODE = $000000EC;
  {$EXTERNALSYM DBPROP_LOCKMODE}
  DBPROP_MULTIPLECONNECTIONS = $000000ED;
  {$EXTERNALSYM DBPROP_MULTIPLECONNECTIONS}
  DBPROP_UNIQUEROWS = $000000EE;
  {$EXTERNALSYM DBPROP_UNIQUEROWS}
  DBPROP_SERVERDATAONINSERT = $000000EF;
  {$EXTERNALSYM DBPROP_SERVERDATAONINSERT}
  DBPROP_STORAGEFLAGS = $000000F0;
  {$EXTERNALSYM DBPROP_STORAGEFLAGS}
  DBPROP_CONNECTIONSTATUS = $000000F4;
  {$EXTERNALSYM DBPROP_CONNECTIONSTATUS}
  DBPROP_ALTERCOLUMN = $000000F5;
  {$EXTERNALSYM DBPROP_ALTERCOLUMN}
  DBPROP_COLUMNLCID = $000000F6;
  {$EXTERNALSYM DBPROP_COLUMNLCID}
  DBPROP_RESETDATASOURCE = $000000F7;
  {$EXTERNALSYM DBPROP_RESETDATASOURCE}
  DBPROP_INIT_OLEDBSERVICES = $000000F8;
  {$EXTERNALSYM DBPROP_INIT_OLEDBSERVICES}
  DBPROP_IRowsetRefresh = $000000F9;
  {$EXTERNALSYM DBPROP_IRowsetRefresh}
  DBPROP_SERVERNAME = $000000FA;
  {$EXTERNALSYM DBPROP_SERVERNAME}
  DBPROP_IParentRowset = $00000101;
  {$EXTERNALSYM DBPROP_IParentRowset}
  DBPROP_HIDDENCOLUMNS = $00000102;
  {$EXTERNALSYM DBPROP_HIDDENCOLUMNS}
  DBPROP_PROVIDERMEMORY = $00000103;
  {$EXTERNALSYM DBPROP_PROVIDERMEMORY}
  DBPROP_CLIENTCURSOR = $00000104;
  {$EXTERNALSYM DBPROP_CLIENTCURSOR}

// DBPROPENUM21 constants
type
  DBPROPENUM21 = TOleEnum;
  {$EXTERNALSYM DBPROPENUM21}
const
  DBPROP_TRUSTEE_USERNAME = $000000F1;
  {$EXTERNALSYM DBPROP_TRUSTEE_USERNAME}
  DBPROP_TRUSTEE_AUTHENTICATION = $000000F2;
  {$EXTERNALSYM DBPROP_TRUSTEE_AUTHENTICATION}
  DBPROP_TRUSTEE_NEWAUTHENTICATION = $000000F3;
  {$EXTERNALSYM DBPROP_TRUSTEE_NEWAUTHENTICATION}

// DBPROPENUM25 constants
type
  DBPROPENUM25 = TOleEnum;
  {$EXTERNALSYM DBPROPENUM25}
const
  DBPROP_ICommandCost = $0000008D;
  {$EXTERNALSYM DBPROP_ICommandCost}
  DBPROP_ICommandTree = $0000008E;
  {$EXTERNALSYM DBPROP_ICommandTree}
  DBPROP_ICommandValidate = $0000008F;
  {$EXTERNALSYM DBPROP_ICommandValidate}
  DBPROP_IDBSchemaCommand = $00000090;
  {$EXTERNALSYM DBPROP_IDBSchemaCommand}
  DBPROP_IProvideMoniker = $0000007D;
  {$EXTERNALSYM DBPROP_IProvideMoniker}
  DBPROP_IQuery = $00000092;
  {$EXTERNALSYM DBPROP_IQuery}
  DBPROP_IReadData = $00000093;
  {$EXTERNALSYM DBPROP_IReadData}
  DBPROP_IRowsetAsynch = $00000094;
  {$EXTERNALSYM DBPROP_IRowsetAsynch}
  DBPROP_IRowsetKeys = $00000097;
  {$EXTERNALSYM DBPROP_IRowsetKeys}
  DBPROP_IRowsetNewRowAfter = $00000098;
  {$EXTERNALSYM DBPROP_IRowsetNewRowAfter}
  DBPROP_IRowsetNextRowset = $00000099;
  {$EXTERNALSYM DBPROP_IRowsetNextRowset}
  DBPROP_IRowsetWatchAll = $0000009B;
  {$EXTERNALSYM DBPROP_IRowsetWatchAll}
  DBPROP_IRowsetWatchNotify = $0000009C;
  {$EXTERNALSYM DBPROP_IRowsetWatchNotify}
  DBPROP_IRowsetWatchRegion = $0000009D;
  {$EXTERNALSYM DBPROP_IRowsetWatchRegion}
  DBPROP_IRowsetWithParameters = $0000009E;
  {$EXTERNALSYM DBPROP_IRowsetWithParameters}

// DBPROPENUMDEPRECATED constants
type
  DBPROPENUMDEPRECATED = TOleEnum;
  {$EXTERNALSYM DBPROPENUMDEPRECATED}
const
  DBPROP_IRowsetExactScroll = $0000009A;
  {$EXTERNALSYM DBPROP_IRowsetExactScroll}

// DBCOMMANDOPENUM constants
type
  DBCOMMANDOPENUM = TOleEnum;
  {$EXTERNALSYM DBCOMMANDOPENUM}
const
  DBOP_scalar_constant = $00000000;
  {$EXTERNALSYM DBOP_scalar_constant}
  DBOP_DEFAULT = $00000001;
  {$EXTERNALSYM DBOP_DEFAULT}
  DBOP_NULL = $00000002;
  {$EXTERNALSYM DBOP_NULL}
  DBOP_bookmark_name = $00000003;
  {$EXTERNALSYM DBOP_bookmark_name}
  DBOP_catalog_name = $00000004;
  {$EXTERNALSYM DBOP_catalog_name}
  DBOP_column_name = $00000005;
  {$EXTERNALSYM DBOP_column_name}
  DBOP_schema_name = $00000006;
  {$EXTERNALSYM DBOP_schema_name}
  DBOP_outall_name = $00000007;
  {$EXTERNALSYM DBOP_outall_name}
  DBOP_qualifier_name = $00000008;
  {$EXTERNALSYM DBOP_qualifier_name}
  DBOP_qualified_column_name = $00000009;
  {$EXTERNALSYM DBOP_qualified_column_name}
  DBOP_table_name = $0000000A;
  {$EXTERNALSYM DBOP_table_name}
  DBOP_nested_table_name = $0000000B;
  {$EXTERNALSYM DBOP_nested_table_name}
  DBOP_nested_column_name = $0000000C;
  {$EXTERNALSYM DBOP_nested_column_name}
  DBOP_row = $0000000D;
  {$EXTERNALSYM DBOP_row}
  DBOP_table = $0000000E;
  {$EXTERNALSYM DBOP_table}
  DBOP_sort = $0000000F;
  {$EXTERNALSYM DBOP_sort}
  DBOP_distinct = $00000010;
  {$EXTERNALSYM DBOP_distinct}
  DBOP_distinct_order_preserving = $00000011;
  {$EXTERNALSYM DBOP_distinct_order_preserving}
  DBOP_alias = $00000012;
  {$EXTERNALSYM DBOP_alias}
  DBOP_cross_join = $00000013;
  {$EXTERNALSYM DBOP_cross_join}
  DBOP_union_join = $00000014;
  {$EXTERNALSYM DBOP_union_join}
  DBOP_inner_join = $00000015;
  {$EXTERNALSYM DBOP_inner_join}
  DBOP_left_semi_join = $00000016;
  {$EXTERNALSYM DBOP_left_semi_join}
  DBOP_right_semi_join = $00000017;
  {$EXTERNALSYM DBOP_right_semi_join}
  DBOP_left_anti_semi_join = $00000018;
  {$EXTERNALSYM DBOP_left_anti_semi_join}
  DBOP_right_anti_semi_join = $00000019;
  {$EXTERNALSYM DBOP_right_anti_semi_join}
  DBOP_left_outer_join = $0000001A;
  {$EXTERNALSYM DBOP_left_outer_join}
  DBOP_right_outer_join = $0000001B;
  {$EXTERNALSYM DBOP_right_outer_join}
  DBOP_full_outer_join = $0000001C;
  {$EXTERNALSYM DBOP_full_outer_join}
  DBOP_natural_join = $0000001D;
  {$EXTERNALSYM DBOP_natural_join}
  DBOP_natural_left_outer_join = $0000001E;
  {$EXTERNALSYM DBOP_natural_left_outer_join}
  DBOP_natural_right_outer_join = $0000001F;
  {$EXTERNALSYM DBOP_natural_right_outer_join}
  DBOP_natural_full_outer_join = $00000020;
  {$EXTERNALSYM DBOP_natural_full_outer_join}
  DBOP_set_intersection = $00000021;
  {$EXTERNALSYM DBOP_set_intersection}
  DBOP_set_union = $00000022;
  {$EXTERNALSYM DBOP_set_union}
  DBOP_set_left_difference = $00000023;
  {$EXTERNALSYM DBOP_set_left_difference}
  DBOP_set_right_difference = $00000024;
  {$EXTERNALSYM DBOP_set_right_difference}
  DBOP_set_anti_difference = $00000025;
  {$EXTERNALSYM DBOP_set_anti_difference}
  DBOP_bag_intersection = $00000026;
  {$EXTERNALSYM DBOP_bag_intersection}
  DBOP_bag_union = $00000027;
  {$EXTERNALSYM DBOP_bag_union}
  DBOP_bag_left_difference = $00000028;
  {$EXTERNALSYM DBOP_bag_left_difference}
  DBOP_bag_right_difference = $00000029;
  {$EXTERNALSYM DBOP_bag_right_difference}
  DBOP_bag_anti_difference = $0000002A;
  {$EXTERNALSYM DBOP_bag_anti_difference}
  DBOP_division = $0000002B;
  {$EXTERNALSYM DBOP_division}
  DBOP_relative_sampling = $0000002C;
  {$EXTERNALSYM DBOP_relative_sampling}
  DBOP_absolute_sampling = $0000002D;
  {$EXTERNALSYM DBOP_absolute_sampling}
  DBOP_transitive_closure = $0000002E;
  {$EXTERNALSYM DBOP_transitive_closure}
  DBOP_recursive_union = $0000002F;
  {$EXTERNALSYM DBOP_recursive_union}
  DBOP_aggregate = $00000030;
  {$EXTERNALSYM DBOP_aggregate}
  DBOP_remote_table = $00000031;
  {$EXTERNALSYM DBOP_remote_table}
  DBOP_select = $00000032;
  {$EXTERNALSYM DBOP_select}
  DBOP_order_preserving_select = $00000033;
  {$EXTERNALSYM DBOP_order_preserving_select}
  DBOP_project = $00000034;
  {$EXTERNALSYM DBOP_project}
  DBOP_project_order_preserving = $00000035;
  {$EXTERNALSYM DBOP_project_order_preserving}
  DBOP_top = $00000036;
  {$EXTERNALSYM DBOP_top}
  DBOP_top_percent = $00000037;
  {$EXTERNALSYM DBOP_top_percent}
  DBOP_top_plus_ties = $00000038;
  {$EXTERNALSYM DBOP_top_plus_ties}
  DBOP_top_percent_plus_ties = $00000039;
  {$EXTERNALSYM DBOP_top_percent_plus_ties}
  DBOP_rank = $0000003A;
  {$EXTERNALSYM DBOP_rank}
  DBOP_rank_ties_equally = $0000003B;
  {$EXTERNALSYM DBOP_rank_ties_equally}
  DBOP_rank_ties_equally_and_skip = $0000003C;
  {$EXTERNALSYM DBOP_rank_ties_equally_and_skip}
  DBOP_navigate = $0000003D;
  {$EXTERNALSYM DBOP_navigate}
  DBOP_nesting = $0000003E;
  {$EXTERNALSYM DBOP_nesting}
  DBOP_unnesting = $0000003F;
  {$EXTERNALSYM DBOP_unnesting}
  DBOP_nested_apply = $00000040;
  {$EXTERNALSYM DBOP_nested_apply}
  DBOP_cross_tab = $00000041;
  {$EXTERNALSYM DBOP_cross_tab}
  DBOP_is_NULL = $00000042;
  {$EXTERNALSYM DBOP_is_NULL}
  DBOP_is_NOT_NULL = $00000043;
  {$EXTERNALSYM DBOP_is_NOT_NULL}
  DBOP_equal = $00000044;
  {$EXTERNALSYM DBOP_equal}
  DBOP_not_equal = $00000045;
  {$EXTERNALSYM DBOP_not_equal}
  DBOP_less = $00000046;
  {$EXTERNALSYM DBOP_less}
  DBOP_less_equal = $00000047;
  {$EXTERNALSYM DBOP_less_equal}
  DBOP_greater = $00000048;
  {$EXTERNALSYM DBOP_greater}
  DBOP_greater_equal = $00000049;
  {$EXTERNALSYM DBOP_greater_equal}
  DBOP_equal_all = $0000004A;
  {$EXTERNALSYM DBOP_equal_all}
  DBOP_not_equal_all = $0000004B;
  {$EXTERNALSYM DBOP_not_equal_all}
  DBOP_less_all = $0000004C;
  {$EXTERNALSYM DBOP_less_all}
  DBOP_less_equal_all = $0000004D;
  {$EXTERNALSYM DBOP_less_equal_all}
  DBOP_greater_all = $0000004E;
  {$EXTERNALSYM DBOP_greater_all}
  DBOP_greater_equal_all = $0000004F;
  {$EXTERNALSYM DBOP_greater_equal_all}
  DBOP_equal_any = $00000050;
  {$EXTERNALSYM DBOP_equal_any}
  DBOP_not_equal_any = $00000051;
  {$EXTERNALSYM DBOP_not_equal_any}
  DBOP_less_any = $00000052;
  {$EXTERNALSYM DBOP_less_any}
  DBOP_less_equal_any = $00000053;
  {$EXTERNALSYM DBOP_less_equal_any}
  DBOP_greater_any = $00000054;
  {$EXTERNALSYM DBOP_greater_any}
  DBOP_greater_equal_any = $00000055;
  {$EXTERNALSYM DBOP_greater_equal_any}
  DBOP_anybits = $00000056;
  {$EXTERNALSYM DBOP_anybits}
  DBOP_allbits = $00000057;
  {$EXTERNALSYM DBOP_allbits}
  DBOP_anybits_any = $00000058;
  {$EXTERNALSYM DBOP_anybits_any}
  DBOP_allbits_any = $00000059;
  {$EXTERNALSYM DBOP_allbits_any}
  DBOP_anybits_all = $0000005A;
  {$EXTERNALSYM DBOP_anybits_all}
  DBOP_allbits_all = $0000005B;
  {$EXTERNALSYM DBOP_allbits_all}
  DBOP_between = $0000005C;
  {$EXTERNALSYM DBOP_between}
  DBOP_between_unordered = $0000005D;
  {$EXTERNALSYM DBOP_between_unordered}
  DBOP_match = $0000005E;
  {$EXTERNALSYM DBOP_match}
  DBOP_match_unique = $0000005F;
  {$EXTERNALSYM DBOP_match_unique}
  DBOP_match_partial = $00000060;
  {$EXTERNALSYM DBOP_match_partial}
  DBOP_match_partial_unique = $00000061;
  {$EXTERNALSYM DBOP_match_partial_unique}
  DBOP_match_full = $00000062;
  {$EXTERNALSYM DBOP_match_full}
  DBOP_match_full_unique = $00000063;
  {$EXTERNALSYM DBOP_match_full_unique}
  DBOP_scalar_parameter = $00000064;
  {$EXTERNALSYM DBOP_scalar_parameter}
  DBOP_scalar_function = $00000065;
  {$EXTERNALSYM DBOP_scalar_function}
  DBOP_plus = $00000066;
  {$EXTERNALSYM DBOP_plus}
  DBOP_minus = $00000067;
  {$EXTERNALSYM DBOP_minus}
  DBOP_times = $00000068;
  {$EXTERNALSYM DBOP_times}
  DBOP_over = $00000069;
  {$EXTERNALSYM DBOP_over}
  DBOP_div = $0000006A;
  {$EXTERNALSYM DBOP_div}
  DBOP_modulo = $0000006B;
  {$EXTERNALSYM DBOP_modulo}
  DBOP_power = $0000006C;
  {$EXTERNALSYM DBOP_power}
  DBOP_like = $0000006D;
  {$EXTERNALSYM DBOP_like}
  DBOP_sounds_like = $0000006E;
  {$EXTERNALSYM DBOP_sounds_like}
  DBOP_like_any = $0000006F;
  {$EXTERNALSYM DBOP_like_any}
  DBOP_like_all = $00000070;
  {$EXTERNALSYM DBOP_like_all}
  DBOP_is_INVALID = $00000071;
  {$EXTERNALSYM DBOP_is_INVALID}
  DBOP_is_TRUE = $00000072;
  {$EXTERNALSYM DBOP_is_TRUE}
  DBOP_is_FALSE = $00000073;
  {$EXTERNALSYM DBOP_is_FALSE}
  DBOP_and = $00000074;
  {$EXTERNALSYM DBOP_and}
  DBOP_or = $00000075;
  {$EXTERNALSYM DBOP_or}
  DBOP_xor = $00000076;
  {$EXTERNALSYM DBOP_xor}
  DBOP_equivalent = $00000077;
  {$EXTERNALSYM DBOP_equivalent}
  DBOP_not = $00000078;
  {$EXTERNALSYM DBOP_not}
  DBOP_implies = $00000079;
  {$EXTERNALSYM DBOP_implies}
  DBOP_overlaps = $0000007A;
  {$EXTERNALSYM DBOP_overlaps}
  DBOP_case_condition = $0000007B;
  {$EXTERNALSYM DBOP_case_condition}
  DBOP_case_value = $0000007C;
  {$EXTERNALSYM DBOP_case_value}
  DBOP_nullif = $0000007D;
  {$EXTERNALSYM DBOP_nullif}
  DBOP_cast = $0000007E;
  {$EXTERNALSYM DBOP_cast}
  DBOP_coalesce = $0000007F;
  {$EXTERNALSYM DBOP_coalesce}
  DBOP_position = $00000080;
  {$EXTERNALSYM DBOP_position}
  DBOP_extract = $00000081;
  {$EXTERNALSYM DBOP_extract}
  DBOP_char_length = $00000082;
  {$EXTERNALSYM DBOP_char_length}
  DBOP_octet_length = $00000083;
  {$EXTERNALSYM DBOP_octet_length}
  DBOP_bit_length = $00000084;
  {$EXTERNALSYM DBOP_bit_length}
  DBOP_substring = $00000085;
  {$EXTERNALSYM DBOP_substring}
  DBOP_upper = $00000086;
  {$EXTERNALSYM DBOP_upper}
  DBOP_lower = $00000087;
  {$EXTERNALSYM DBOP_lower}
  DBOP_trim = $00000088;
  {$EXTERNALSYM DBOP_trim}
  DBOP_translate = $00000089;
  {$EXTERNALSYM DBOP_translate}
  DBOP_convert = $0000008A;
  {$EXTERNALSYM DBOP_convert}
  DBOP_string_concat = $0000008B;
  {$EXTERNALSYM DBOP_string_concat}
  DBOP_current_date = $0000008C;
  {$EXTERNALSYM DBOP_current_date}
  DBOP_current_time = $0000008D;
  {$EXTERNALSYM DBOP_current_time}
  DBOP_current_timestamp = $0000008E;
  {$EXTERNALSYM DBOP_current_timestamp}
  DBOP_content_select = $0000008F;
  {$EXTERNALSYM DBOP_content_select}
  DBOP_content = $00000090;
  {$EXTERNALSYM DBOP_content}
  DBOP_content_freetext = $00000091;
  {$EXTERNALSYM DBOP_content_freetext}
  DBOP_content_proximity = $00000092;
  {$EXTERNALSYM DBOP_content_proximity}
  DBOP_content_vector_or = $00000093;
  {$EXTERNALSYM DBOP_content_vector_or}
  DBOP_delete = $00000094;
  {$EXTERNALSYM DBOP_delete}
  DBOP_update = $00000095;
  {$EXTERNALSYM DBOP_update}
  DBOP_insert = $00000096;
  {$EXTERNALSYM DBOP_insert}
  DBOP_min = $00000097;
  {$EXTERNALSYM DBOP_min}
  DBOP_max = $00000098;
  {$EXTERNALSYM DBOP_max}
  DBOP_count = $00000099;
  {$EXTERNALSYM DBOP_count}
  DBOP_sum = $0000009A;
  {$EXTERNALSYM DBOP_sum}
  DBOP_avg = $0000009B;
  {$EXTERNALSYM DBOP_avg}
  DBOP_any_sample = $0000009C;
  {$EXTERNALSYM DBOP_any_sample}
  DBOP_stddev = $0000009D;
  {$EXTERNALSYM DBOP_stddev}
  DBOP_stddev_pop = $0000009E;
  {$EXTERNALSYM DBOP_stddev_pop}
  DBOP_var = $0000009F;
  {$EXTERNALSYM DBOP_var}
  DBOP_var_pop = $000000A0;
  {$EXTERNALSYM DBOP_var_pop}
  DBOP_first = $000000A1;
  {$EXTERNALSYM DBOP_first}
  DBOP_last = $000000A2;
  {$EXTERNALSYM DBOP_last}
  DBOP_in = $000000A3;
  {$EXTERNALSYM DBOP_in}
  DBOP_exists = $000000A4;
  {$EXTERNALSYM DBOP_exists}
  DBOP_unique = $000000A5;
  {$EXTERNALSYM DBOP_unique}
  DBOP_subset = $000000A6;
  {$EXTERNALSYM DBOP_subset}
  DBOP_proper_subset = $000000A7;
  {$EXTERNALSYM DBOP_proper_subset}
  DBOP_superset = $000000A8;
  {$EXTERNALSYM DBOP_superset}
  DBOP_proper_superset = $000000A9;
  {$EXTERNALSYM DBOP_proper_superset}
  DBOP_disjoint = $000000AA;
  {$EXTERNALSYM DBOP_disjoint}
  DBOP_pass_through = $000000AB;
  {$EXTERNALSYM DBOP_pass_through}
  DBOP_defined_by_GUID = $000000AC;
  {$EXTERNALSYM DBOP_defined_by_GUID}
  DBOP_text_command = $000000AD;
  {$EXTERNALSYM DBOP_text_command}
  DBOP_SQL_select = $000000AE;
  {$EXTERNALSYM DBOP_SQL_select}
  DBOP_prior_command_tree = $000000AF;
  {$EXTERNALSYM DBOP_prior_command_tree}
  DBOP_add_columns = $000000B0;
  {$EXTERNALSYM DBOP_add_columns}
  DBOP_column_list_anchor = $000000B1;
  {$EXTERNALSYM DBOP_column_list_anchor}
  DBOP_column_list_element = $000000B2;
  {$EXTERNALSYM DBOP_column_list_element}
  DBOP_command_list_anchor = $000000B3;
  {$EXTERNALSYM DBOP_command_list_anchor}
  DBOP_command_list_element = $000000B4;
  {$EXTERNALSYM DBOP_command_list_element}
  DBOP_from_list_anchor = $000000B5;
  {$EXTERNALSYM DBOP_from_list_anchor}
  DBOP_from_list_element = $000000B6;
  {$EXTERNALSYM DBOP_from_list_element}
  DBOP_project_list_anchor = $000000B7;
  {$EXTERNALSYM DBOP_project_list_anchor}
  DBOP_project_list_element = $000000B8;
  {$EXTERNALSYM DBOP_project_list_element}
  DBOP_row_list_anchor = $000000B9;
  {$EXTERNALSYM DBOP_row_list_anchor}
  DBOP_row_list_element = $000000BA;
  {$EXTERNALSYM DBOP_row_list_element}
  DBOP_scalar_list_anchor = $000000BB;
  {$EXTERNALSYM DBOP_scalar_list_anchor}
  DBOP_scalar_list_element = $000000BC;
  {$EXTERNALSYM DBOP_scalar_list_element}
  DBOP_set_list_anchor = $000000BD;
  {$EXTERNALSYM DBOP_set_list_anchor}
  DBOP_set_list_element = $000000BE;
  {$EXTERNALSYM DBOP_set_list_element}
  DBOP_sort_list_anchor = $000000BF;
  {$EXTERNALSYM DBOP_sort_list_anchor}
  DBOP_sort_list_element = $000000C0;
  {$EXTERNALSYM DBOP_sort_list_element}
  DBOP_alter_character_set = $000000C1;
  {$EXTERNALSYM DBOP_alter_character_set}
  DBOP_alter_collation = $000000C2;
  {$EXTERNALSYM DBOP_alter_collation}
  DBOP_alter_domain = $000000C3;
  {$EXTERNALSYM DBOP_alter_domain}
  DBOP_alter_index = $000000C4;
  {$EXTERNALSYM DBOP_alter_index}
  DBOP_alter_procedure = $000000C5;
  {$EXTERNALSYM DBOP_alter_procedure}
  DBOP_alter_schema = $000000C6;
  {$EXTERNALSYM DBOP_alter_schema}
  DBOP_alter_table = $000000C7;
  {$EXTERNALSYM DBOP_alter_table}
  DBOP_alter_trigger = $000000C8;
  {$EXTERNALSYM DBOP_alter_trigger}
  DBOP_alter_view = $000000C9;
  {$EXTERNALSYM DBOP_alter_view}
  DBOP_coldef_list_anchor = $000000CA;
  {$EXTERNALSYM DBOP_coldef_list_anchor}
  DBOP_coldef_list_element = $000000CB;
  {$EXTERNALSYM DBOP_coldef_list_element}
  DBOP_create_assertion = $000000CC;
  {$EXTERNALSYM DBOP_create_assertion}
  DBOP_create_character_set = $000000CD;
  {$EXTERNALSYM DBOP_create_character_set}
  DBOP_create_collation = $000000CE;
  {$EXTERNALSYM DBOP_create_collation}
  DBOP_create_domain = $000000CF;
  {$EXTERNALSYM DBOP_create_domain}
  DBOP_create_index = $000000D0;
  {$EXTERNALSYM DBOP_create_index}
  DBOP_create_procedure = $000000D1;
  {$EXTERNALSYM DBOP_create_procedure}
  DBOP_create_schema = $000000D2;
  {$EXTERNALSYM DBOP_create_schema}
  DBOP_create_synonym = $000000D3;
  {$EXTERNALSYM DBOP_create_synonym}
  DBOP_create_table = $000000D4;
  {$EXTERNALSYM DBOP_create_table}
  DBOP_create_temporary_table = $000000D5;
  {$EXTERNALSYM DBOP_create_temporary_table}
  DBOP_create_translation = $000000D6;
  {$EXTERNALSYM DBOP_create_translation}
  DBOP_create_trigger = $000000D7;
  {$EXTERNALSYM DBOP_create_trigger}
  DBOP_create_view = $000000D8;
  {$EXTERNALSYM DBOP_create_view}
  DBOP_drop_assertion = $000000D9;
  {$EXTERNALSYM DBOP_drop_assertion}
  DBOP_drop_character_set = $000000DA;
  {$EXTERNALSYM DBOP_drop_character_set}
  DBOP_drop_collation = $000000DB;
  {$EXTERNALSYM DBOP_drop_collation}
  DBOP_drop_domain = $000000DC;
  {$EXTERNALSYM DBOP_drop_domain}
  DBOP_drop_index = $000000DD;
  {$EXTERNALSYM DBOP_drop_index}
  DBOP_drop_procedure = $000000DE;
  {$EXTERNALSYM DBOP_drop_procedure}
  DBOP_drop_schema = $000000DF;
  {$EXTERNALSYM DBOP_drop_schema}
  DBOP_drop_synonym = $000000E0;
  {$EXTERNALSYM DBOP_drop_synonym}
  DBOP_drop_table = $000000E1;
  {$EXTERNALSYM DBOP_drop_table}
  DBOP_drop_translation = $000000E2;
  {$EXTERNALSYM DBOP_drop_translation}
  DBOP_drop_trigger = $000000E3;
  {$EXTERNALSYM DBOP_drop_trigger}
  DBOP_drop_view = $000000E4;
  {$EXTERNALSYM DBOP_drop_view}
  DBOP_foreign_key = $000000E5;
  {$EXTERNALSYM DBOP_foreign_key}
  DBOP_grant_privileges = $000000E6;
  {$EXTERNALSYM DBOP_grant_privileges}
  DBOP_index_list_anchor = $000000E7;
  {$EXTERNALSYM DBOP_index_list_anchor}
  DBOP_index_list_element = $000000E8;
  {$EXTERNALSYM DBOP_index_list_element}
  DBOP_primary_key = $000000E9;
  {$EXTERNALSYM DBOP_primary_key}
  DBOP_property_list_anchor = $000000EA;
  {$EXTERNALSYM DBOP_property_list_anchor}
  DBOP_property_list_element = $000000EB;
  {$EXTERNALSYM DBOP_property_list_element}
  DBOP_referenced_table = $000000EC;
  {$EXTERNALSYM DBOP_referenced_table}
  DBOP_rename_object = $000000ED;
  {$EXTERNALSYM DBOP_rename_object}
  DBOP_revoke_privileges = $000000EE;
  {$EXTERNALSYM DBOP_revoke_privileges}
  DBOP_schema_authorization = $000000EF;
  {$EXTERNALSYM DBOP_schema_authorization}
  DBOP_unique_key = $000000F0;
  {$EXTERNALSYM DBOP_unique_key}

// DBPARAMFLAGSENUM constants
type
  DBPARAMFLAGSENUM = TOleEnum;
  {$EXTERNALSYM DBPARAMFLAGSENUM}
const
  DBPARAMFLAGS_ISINPUT = $00000001;
  {$EXTERNALSYM DBPARAMFLAGS_ISINPUT}
  DBPARAMFLAGS_ISOUTPUT = $00000002;
  {$EXTERNALSYM DBPARAMFLAGS_ISOUTPUT}
  DBPARAMFLAGS_ISSIGNED = $00000010;
  {$EXTERNALSYM DBPARAMFLAGS_ISSIGNED}
  DBPARAMFLAGS_ISNULLABLE = $00000040;
  {$EXTERNALSYM DBPARAMFLAGS_ISNULLABLE}
  DBPARAMFLAGS_ISLONG = $00000080;
  {$EXTERNALSYM DBPARAMFLAGS_ISLONG}

// DBPARAMFLAGSENUM20 constants
type
  DBPARAMFLAGSENUM20 = TOleEnum;
  {$EXTERNALSYM DBPARAMFLAGSENUM20}
const
  DBPARAMFLAGS_SCALEISNEGATIVE = $00000100;
  {$EXTERNALSYM DBPARAMFLAGS_SCALEISNEGATIVE}

// DBPROPFLAGSENUM constants
type
  DBPROPFLAGSENUM = TOleEnum;
  {$EXTERNALSYM DBPROPFLAGSENUM}
const
  DBPROPFLAGS_NOTSUPPORTED = $00000000;
  {$EXTERNALSYM DBPROPFLAGS_NOTSUPPORTED}
  DBPROPFLAGS_COLUMN = $00000001;
  {$EXTERNALSYM DBPROPFLAGS_COLUMN}
  DBPROPFLAGS_DATASOURCE = $00000002;
  {$EXTERNALSYM DBPROPFLAGS_DATASOURCE}
  DBPROPFLAGS_DATASOURCECREATE = $00000004;
  {$EXTERNALSYM DBPROPFLAGS_DATASOURCECREATE}
  DBPROPFLAGS_DATASOURCEINFO = $00000008;
  {$EXTERNALSYM DBPROPFLAGS_DATASOURCEINFO}
  DBPROPFLAGS_DBINIT = $00000010;
  {$EXTERNALSYM DBPROPFLAGS_DBINIT}
  DBPROPFLAGS_INDEX = $00000020;
  {$EXTERNALSYM DBPROPFLAGS_INDEX}
  DBPROPFLAGS_ROWSET = $00000040;
  {$EXTERNALSYM DBPROPFLAGS_ROWSET}
  DBPROPFLAGS_TABLE = $00000080;
  {$EXTERNALSYM DBPROPFLAGS_TABLE}
  DBPROPFLAGS_COLUMNOK = $00000100;
  {$EXTERNALSYM DBPROPFLAGS_COLUMNOK}
  DBPROPFLAGS_READ = $00000200;
  {$EXTERNALSYM DBPROPFLAGS_READ}
  DBPROPFLAGS_WRITE = $00000400;
  {$EXTERNALSYM DBPROPFLAGS_WRITE}
  DBPROPFLAGS_REQUIRED = $00000800;
  {$EXTERNALSYM DBPROPFLAGS_REQUIRED}
  DBPROPFLAGS_SESSION = $00001000;
  {$EXTERNALSYM DBPROPFLAGS_SESSION}

// DBPROPFLAGSENUM21 constants
type
  DBPROPFLAGSENUM21 = TOleEnum;
  {$EXTERNALSYM DBPROPFLAGSENUM21}
const
  DBPROPFLAGS_TRUSTEE = $00002000;
  {$EXTERNALSYM DBPROPFLAGS_TRUSTEE}

// DBPROPOPTIONSENUM constants
type
  DBPROPOPTIONSENUM = TOleEnum;
  {$EXTERNALSYM DBPROPOPTIONSENUM}
const
  DBPROPOPTIONS_REQUIRED = $00000000;
  {$EXTERNALSYM DBPROPOPTIONS_REQUIRED}
  DBPROPOPTIONS_SETIFCHEAP = $00000001;
  {$EXTERNALSYM DBPROPOPTIONS_SETIFCHEAP}
  DBPROPOPTIONS_OPTIONAL = $00000001;
  {$EXTERNALSYM DBPROPOPTIONS_OPTIONAL}

// DBPROPSTATUSENUM constants
type
  DBPROPSTATUSENUM = TOleEnum;
  {$EXTERNALSYM DBPROPSTATUSENUM}
const
  DBPROPSTATUS_OK = $00000000;
  {$EXTERNALSYM DBPROPSTATUS_OK}
  DBPROPSTATUS_NOTSUPPORTED = $00000001;
  {$EXTERNALSYM DBPROPSTATUS_NOTSUPPORTED}
  DBPROPSTATUS_BADVALUE = $00000002;
  {$EXTERNALSYM DBPROPSTATUS_BADVALUE}
  DBPROPSTATUS_BADOPTION = $00000003;
  {$EXTERNALSYM DBPROPSTATUS_BADOPTION}
  DBPROPSTATUS_BADCOLUMN = $00000004;
  {$EXTERNALSYM DBPROPSTATUS_BADCOLUMN}
  DBPROPSTATUS_NOTALLSETTABLE = $00000005;
  {$EXTERNALSYM DBPROPSTATUS_NOTALLSETTABLE}
  DBPROPSTATUS_NOTSETTABLE = $00000006;
  {$EXTERNALSYM DBPROPSTATUS_NOTSETTABLE}
  DBPROPSTATUS_NOTSET = $00000007;
  {$EXTERNALSYM DBPROPSTATUS_NOTSET}
  DBPROPSTATUS_CONFLICTING = $00000008;
  {$EXTERNALSYM DBPROPSTATUS_CONFLICTING}

// DBPROPSTATUSENUM21 constants
type
  DBPROPSTATUSENUM21 = TOleEnum;
  {$EXTERNALSYM DBPROPSTATUSENUM21}
const
  DBPROPSTATUS_NOTAVAILAVLE = $00000009;
  {$EXTERNALSYM DBPROPSTATUS_NOTAVAILAVLE}

// DBINDEX_COL_ORDERENUM constants
type
  DBINDEX_COL_ORDERENUM = TOleEnum;
  {$EXTERNALSYM DBINDEX_COL_ORDERENUM}
const
  DBINDEX_COL_ORDER_ASC = $00000000;
  {$EXTERNALSYM DBINDEX_COL_ORDER_ASC}
  DBINDEX_COL_ORDER_DESC = $00000001;
  {$EXTERNALSYM DBINDEX_COL_ORDER_DESC}

// DBCOLUMNDESCFLAGSENUM constants
type
  DBCOLUMNDESCFLAGSENUM = TOleEnum;
  {$EXTERNALSYM DBCOLUMNDESCFLAGSENUM}
const
  DBCOLUMNDESCFLAGS_TYPENAME = $00000001;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS_TYPENAME}
  DBCOLUMNDESCFLAGS_ITYPEINFO = $00000002;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS_ITYPEINFO}
  DBCOLUMNDESCFLAGS_PROPERTIES = $00000004;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS_PROPERTIES}
  DBCOLUMNDESCFLAGS_CLSID = $00000008;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS_CLSID}
  DBCOLUMNDESCFLAGS_COLSIZE = $00000010;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS_COLSIZE}
  DBCOLUMNDESCFLAGS_DBCID = $00000020;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS_DBCID}
  DBCOLUMNDESCFLAGS_WTYPE = $00000040;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS_WTYPE}
  DBCOLUMNDESCFLAGS_PRECISION = $00000080;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS_PRECISION}
  DBCOLUMNDESCFLAGS_SCALE = $00000100;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS_SCALE}

// DBEVENTPHASEENUM constants
type
  DBEVENTPHASEENUM = TOleEnum;
  {$EXTERNALSYM DBEVENTPHASEENUM}
const
  DBEVENTPHASE_OKTODO = $00000000;
  {$EXTERNALSYM DBEVENTPHASE_OKTODO}
  DBEVENTPHASE_ABOUTTODO = $00000001;
  {$EXTERNALSYM DBEVENTPHASE_ABOUTTODO}
  DBEVENTPHASE_SYNCHAFTER = $00000002;
  {$EXTERNALSYM DBEVENTPHASE_SYNCHAFTER}
  DBEVENTPHASE_FAILEDTODO = $00000003;
  {$EXTERNALSYM DBEVENTPHASE_FAILEDTODO}
  DBEVENTPHASE_DIDEVENT = $00000004;
  {$EXTERNALSYM DBEVENTPHASE_DIDEVENT}

// DBREASONENUM constants
type
  DBREASONENUM = TOleEnum;
  {$EXTERNALSYM DBREASONENUM}
const
  DBREASON_ROWSET_FETCHPOSITIONCHANGE = $00000000;
  {$EXTERNALSYM DBREASON_ROWSET_FETCHPOSITIONCHANGE}
  DBREASON_ROWSET_RELEASE = $00000001;
  {$EXTERNALSYM DBREASON_ROWSET_RELEASE}
  DBREASON_COLUMN_SET = $00000002;
  {$EXTERNALSYM DBREASON_COLUMN_SET}
  DBREASON_COLUMN_RECALCULATED = $00000003;
  {$EXTERNALSYM DBREASON_COLUMN_RECALCULATED}
  DBREASON_ROW_ACTIVATE = $00000004;
  {$EXTERNALSYM DBREASON_ROW_ACTIVATE}
  DBREASON_ROW_RELEASE = $00000005;
  {$EXTERNALSYM DBREASON_ROW_RELEASE}
  DBREASON_ROW_DELETE = $00000006;
  {$EXTERNALSYM DBREASON_ROW_DELETE}
  DBREASON_ROW_FIRSTCHANGE = $00000007;
  {$EXTERNALSYM DBREASON_ROW_FIRSTCHANGE}
  DBREASON_ROW_INSERT = $00000008;
  {$EXTERNALSYM DBREASON_ROW_INSERT}
  DBREASON_ROW_RESYNCH = $00000009;
  {$EXTERNALSYM DBREASON_ROW_RESYNCH}
  DBREASON_ROW_UNDOCHANGE = $0000000A;
  {$EXTERNALSYM DBREASON_ROW_UNDOCHANGE}
  DBREASON_ROW_UNDOINSERT = $0000000B;
  {$EXTERNALSYM DBREASON_ROW_UNDOINSERT}
  DBREASON_ROW_UNDODELETE = $0000000C;
  {$EXTERNALSYM DBREASON_ROW_UNDODELETE}
  DBREASON_ROW_UPDATE = $0000000D;
  {$EXTERNALSYM DBREASON_ROW_UPDATE}
  DBREASON_ROWSET_CHANGED = $0000000E;
  {$EXTERNALSYM DBREASON_ROWSET_CHANGED}

// DBREASONENUM15 constants
type
  DBREASONENUM15 = TOleEnum;
  {$EXTERNALSYM DBREASONENUM15}
const
  DBREASON_ROWPOSITION_CHANGED = $0000000F;
  {$EXTERNALSYM DBREASON_ROWPOSITION_CHANGED}
  DBREASON_ROWPOSITION_CHAPTERCHANGED = $00000010;
  {$EXTERNALSYM DBREASON_ROWPOSITION_CHAPTERCHANGED}
  DBREASON_ROWPOSITION_CLEARED = $00000011;
  {$EXTERNALSYM DBREASON_ROWPOSITION_CLEARED}
  DBREASON_ROW_ASYNCHINSERT = $00000012;
  {$EXTERNALSYM DBREASON_ROW_ASYNCHINSERT}

// DBREASONENUM25 constants
type
  DBREASONENUM25 = TOleEnum;
  {$EXTERNALSYM DBREASONENUM25}
const
  DBREASON_ROWSET_ROWSADDED = $00000013;
  {$EXTERNALSYM DBREASON_ROWSET_ROWSADDED}
  DBREASON_ROWSET_POPULATIONCOMPLETE = $00000014;
  {$EXTERNALSYM DBREASON_ROWSET_POPULATIONCOMPLETE}
  DBREASON_ROWSET_POPULATIONSTOPPED = $00000015;
  {$EXTERNALSYM DBREASON_ROWSET_POPULATIONSTOPPED}

// DBCOMPAREOPSENUM constants
type
  DBCOMPAREOPSENUM = TOleEnum;
  {$EXTERNALSYM DBCOMPAREOPSENUM}
const
  DBCOMPAREOPS_LT = $00000000;
  {$EXTERNALSYM DBCOMPAREOPS_LT}
  DBCOMPAREOPS_LE = $00000001;
  {$EXTERNALSYM DBCOMPAREOPS_LE}
  DBCOMPAREOPS_EQ = $00000002;
  {$EXTERNALSYM DBCOMPAREOPS_EQ}
  DBCOMPAREOPS_GE = $00000003;
  {$EXTERNALSYM DBCOMPAREOPS_GE}
  DBCOMPAREOPS_GT = $00000004;
  {$EXTERNALSYM DBCOMPAREOPS_GT}
  DBCOMPAREOPS_BEGINSWITH = $00000005;
  {$EXTERNALSYM DBCOMPAREOPS_BEGINSWITH}
  DBCOMPAREOPS_CONTAINS = $00000006;
  {$EXTERNALSYM DBCOMPAREOPS_CONTAINS}
  DBCOMPAREOPS_NE = $00000007;
  {$EXTERNALSYM DBCOMPAREOPS_NE}
  DBCOMPAREOPS_IGNORE = $00000008;
  {$EXTERNALSYM DBCOMPAREOPS_IGNORE}
  DBCOMPAREOPS_CASESENSITIVE = $00001000;
  {$EXTERNALSYM DBCOMPAREOPS_CASESENSITIVE}
  DBCOMPAREOPS_CASEINSENSITIVE = $00002000;
  {$EXTERNALSYM DBCOMPAREOPS_CASEINSENSITIVE}

// DBCOMPAREOPSENUM20 constants
type
  DBCOMPAREOPSENUM20 = TOleEnum;
  {$EXTERNALSYM DBCOMPAREOPSENUM20}
const
  DBCOMPAREOPS_NOTBEGINSWITH = $00000009;
  {$EXTERNALSYM DBCOMPAREOPS_NOTBEGINSWITH}
  DBCOMPAREOPS_NOTCONTAINS = $0000000A;
  {$EXTERNALSYM DBCOMPAREOPS_NOTCONTAINS}

// DBASYNCHOPENUM constants
type
  DBASYNCHOPENUM = TOleEnum;
  {$EXTERNALSYM DBASYNCHOPENUM}
const
  DBASYNCHOP_OPEN = $00000000;
  {$EXTERNALSYM DBASYNCHOP_OPEN}

// DBASYNCHPHASEENUM constants
type
  DBASYNCHPHASEENUM = TOleEnum;
  {$EXTERNALSYM DBASYNCHPHASEENUM}
const
  DBASYNCHPHASE_INITIALIZATION = $00000000;
  {$EXTERNALSYM DBASYNCHPHASE_INITIALIZATION}
  DBASYNCHPHASE_POPULATION = $00000001;
  {$EXTERNALSYM DBASYNCHPHASE_POPULATION}
  DBASYNCHPHASE_COMPLETE = $00000002;
  {$EXTERNALSYM DBASYNCHPHASE_COMPLETE}
  DBASYNCHPHASE_CANCELED = $00000003;
  {$EXTERNALSYM DBASYNCHPHASE_CANCELED}

// DBSORTENUM constants
type
  DBSORTENUM = TOleEnum;
  {$EXTERNALSYM DBSORTENUM}
const
  DBSORT_ASCENDING = $00000000;
  {$EXTERNALSYM DBSORT_ASCENDING}
  DBSORT_DESCENDING = $00000001;
  {$EXTERNALSYM DBSORT_DESCENDING}

// DBACCESSORFLAGSENUM constants
type
  DBACCESSORFLAGSENUM = TOleEnum;
  {$EXTERNALSYM DBACCESSORFLAGSENUM}
const
  DBACCESSOR_INVALID = $00000000;
  {$EXTERNALSYM DBACCESSOR_INVALID}
  DBACCESSOR_PASSBYREF = $00000001;
  {$EXTERNALSYM DBACCESSOR_PASSBYREF}
  DBACCESSOR_ROWDATA = $00000002;
  {$EXTERNALSYM DBACCESSOR_ROWDATA}
  DBACCESSOR_PARAMETERDATA = $00000004;
  {$EXTERNALSYM DBACCESSOR_PARAMETERDATA}
  DBACCESSOR_OPTIMIZED = $00000008;
  {$EXTERNALSYM DBACCESSOR_OPTIMIZED}

// DBACCESSORFLAGSENUM25 constants
type
  DBACCESSORFLAGSENUM25 = TOleEnum;
  {$EXTERNALSYM DBACCESSORFLAGSENUM25}
const
  DBACCESSOR_INHERITED = $00000010;
  {$EXTERNALSYM DBACCESSOR_INHERITED}

// DBBINDSTATUSENUM constants
type
  DBBINDSTATUSENUM = TOleEnum;
  {$EXTERNALSYM DBBINDSTATUSENUM}
const
  DBBINDSTATUS_OK = $00000000;
  {$EXTERNALSYM DBBINDSTATUS_OK}
  DBBINDSTATUS_BADORDINAL = $00000001;
  {$EXTERNALSYM DBBINDSTATUS_BADORDINAL}
  DBBINDSTATUS_UNSUPPORTEDCONVERSION = $00000002;
  {$EXTERNALSYM DBBINDSTATUS_UNSUPPORTEDCONVERSION}
  DBBINDSTATUS_BADBINDINFO = $00000003;
  {$EXTERNALSYM DBBINDSTATUS_BADBINDINFO}
  DBBINDSTATUS_BADSTORAGEFLAGS = $00000004;
  {$EXTERNALSYM DBBINDSTATUS_BADSTORAGEFLAGS}
  DBBINDSTATUS_NOINTERFACE = $00000005;
  {$EXTERNALSYM DBBINDSTATUS_NOINTERFACE}
  DBBINDSTATUS_MULTIPLESTORAGE = $00000006;
  {$EXTERNALSYM DBBINDSTATUS_MULTIPLESTORAGE}

// DBCOMPAREENUM constants
type
  DBCOMPAREENUM = TOleEnum;
  {$EXTERNALSYM DBCOMPAREENUM}
const
  DBCOMPARE_LT = $00000000;
  {$EXTERNALSYM DBCOMPARE_LT}
  DBCOMPARE_EQ = $00000001;
  {$EXTERNALSYM DBCOMPARE_EQ}
  DBCOMPARE_GT = $00000002;
  {$EXTERNALSYM DBCOMPARE_GT}
  DBCOMPARE_NE = $00000003;
  {$EXTERNALSYM DBCOMPARE_NE}
  DBCOMPARE_NOTCOMPARABLE = $00000004;
  {$EXTERNALSYM DBCOMPARE_NOTCOMPARABLE}

// DBPOSITIONFLAGSENUM constants
type
  DBPOSITIONFLAGSENUM = TOleEnum;
  {$EXTERNALSYM DBPOSITIONFLAGSENUM}
const
  DBPOSITION_OK = $00000000;
  {$EXTERNALSYM DBPOSITION_OK}
  DBPOSITION_NOROW = $00000001;
  {$EXTERNALSYM DBPOSITION_NOROW}
  DBPOSITION_BOF = $00000002;
  {$EXTERNALSYM DBPOSITION_BOF}
  DBPOSITION_EOF = $00000003;
  {$EXTERNALSYM DBPOSITION_EOF}

// DBPENDINGSTATUSENUM constants
type
  DBPENDINGSTATUSENUM = TOleEnum;
  {$EXTERNALSYM DBPENDINGSTATUSENUM}
const
  DBPENDINGSTATUS_NEW = $00000001;
  {$EXTERNALSYM DBPENDINGSTATUS_NEW}
  DBPENDINGSTATUS_CHANGED = $00000002;
  {$EXTERNALSYM DBPENDINGSTATUS_CHANGED}
  DBPENDINGSTATUS_DELETED = $00000004;
  {$EXTERNALSYM DBPENDINGSTATUS_DELETED}
  DBPENDINGSTATUS_UNCHANGED = $00000008;
  {$EXTERNALSYM DBPENDINGSTATUS_UNCHANGED}
  DBPENDINGSTATUS_INVALIDROW = $00000010;
  {$EXTERNALSYM DBPENDINGSTATUS_INVALIDROW}

// DBSEEKENUM constants
type
  DBSEEKENUM = TOleEnum;
  {$EXTERNALSYM DBSEEKENUM}
const
  DBSEEK_INVALID = $00000000;
  {$EXTERNALSYM DBSEEK_INVALID}
  DBSEEK_FIRSTEQ = $00000001;
  {$EXTERNALSYM DBSEEK_FIRSTEQ}
  DBSEEK_LASTEQ = $00000002;
  {$EXTERNALSYM DBSEEK_LASTEQ}
  DBSEEK_GE = $00000004;
  {$EXTERNALSYM DBSEEK_GE}
  DBSEEK_GT = $00000008;
  {$EXTERNALSYM DBSEEK_GT}
  DBSEEK_LE = $00000010;
  {$EXTERNALSYM DBSEEK_LE}
  DBSEEK_LT = $00000020;
  {$EXTERNALSYM DBSEEK_LT}

// DBRANGEENUM constants
type
  DBRANGEENUM = TOleEnum;
  {$EXTERNALSYM DBRANGEENUM}
const
  DBRANGE_INCLUSIVESTART = $00000000;
  {$EXTERNALSYM DBRANGE_INCLUSIVESTART}
  DBRANGE_INCLUSIVEEND = $00000000;
  {$EXTERNALSYM DBRANGE_INCLUSIVEEND}
  DBRANGE_EXCLUSIVESTART = $00000001;
  {$EXTERNALSYM DBRANGE_EXCLUSIVESTART}
  DBRANGE_EXCLUSIVEEND = $00000002;
  {$EXTERNALSYM DBRANGE_EXCLUSIVEEND}
  DBRANGE_EXCLUDENULLS = $00000004;
  {$EXTERNALSYM DBRANGE_EXCLUDENULLS}
  DBRANGE_PREFIX = $00000008;
  {$EXTERNALSYM DBRANGE_PREFIX}
  DBRANGE_MATCH = $00000010;
  {$EXTERNALSYM DBRANGE_MATCH}

// DBRANGEENUM20 constants
type
  DBRANGEENUM20 = TOleEnum;
  {$EXTERNALSYM DBRANGEENUM20}
const
  DBRANGE_MATCH_N_SHIFT = $00000018;
  {$EXTERNALSYM DBRANGE_MATCH_N_SHIFT}
  DBRANGE_MATCH_N_MASK = $000000FF;
  {$EXTERNALSYM DBRANGE_MATCH_N_MASK}

// DBWATCHNOTIFYENUM constants
type
  DBWATCHNOTIFYENUM = TOleEnum;
  {$EXTERNALSYM DBWATCHNOTIFYENUM}
const
  DBWATCHNOTIFY_ROWSCHANGED = $00000001;
  {$EXTERNALSYM DBWATCHNOTIFY_ROWSCHANGED}
  DBWATCHNOTIFY_QUERYDONE = $00000002;
  {$EXTERNALSYM DBWATCHNOTIFY_QUERYDONE}
  DBWATCHNOTIFY_QUERYREEXECUTED = $00000003;
  {$EXTERNALSYM DBWATCHNOTIFY_QUERYREEXECUTED}

// DBWATCHMODEENUM constants
type
  DBWATCHMODEENUM = TOleEnum;
  {$EXTERNALSYM DBWATCHMODEENUM}
const
  DBWATCHMODE_ALL = $00000001;
  {$EXTERNALSYM DBWATCHMODE_ALL}
  DBWATCHMODE_EXTEND = $00000002;
  {$EXTERNALSYM DBWATCHMODE_EXTEND}
  DBWATCHMODE_MOVE = $00000004;
  {$EXTERNALSYM DBWATCHMODE_MOVE}
  DBWATCHMODE_COUNT = $00000008;
  {$EXTERNALSYM DBWATCHMODE_COUNT}

// DBROWCHANGEKINDENUM constants
type
  DBROWCHANGEKINDENUM = TOleEnum;
  {$EXTERNALSYM DBROWCHANGEKINDENUM}
const
  DBROWCHANGEKIND_INSERT = $00000000;
  {$EXTERNALSYM DBROWCHANGEKIND_INSERT}
  DBROWCHANGEKIND_DELETE = $00000001;
  {$EXTERNALSYM DBROWCHANGEKIND_DELETE}
  DBROWCHANGEKIND_UPDATE = $00000002;
  {$EXTERNALSYM DBROWCHANGEKIND_UPDATE}
  DBROWCHANGEKIND_COUNT = $00000003;
  {$EXTERNALSYM DBROWCHANGEKIND_COUNT}

// DBCONVERTFLAGSENUM constants
type
  DBCONVERTFLAGSENUM = TOleEnum;
  {$EXTERNALSYM DBCONVERTFLAGSENUM}
const
  DBCONVERTFLAGS_COLUMN = $00000000;
  {$EXTERNALSYM DBCONVERTFLAGS_COLUMN}
  DBCONVERTFLAGS_PARAMETER = $00000001;
  {$EXTERNALSYM DBCONVERTFLAGS_PARAMETER}

// DBCONVERTFLAGSENUM20 constants
type
  DBCONVERTFLAGSENUM20 = TOleEnum;
  {$EXTERNALSYM DBCONVERTFLAGSENUM20}
const
  DBCONVERTFLAGS_ISLONG = $00000002;
  {$EXTERNALSYM DBCONVERTFLAGS_ISLONG}
  DBCONVERTFLAGS_ISFIXEDLENGTH = $00000004;
  {$EXTERNALSYM DBCONVERTFLAGS_ISFIXEDLENGTH}
  DBCONVERTFLAGS_FROMVARIANT = $00000008;
  {$EXTERNALSYM DBCONVERTFLAGS_FROMVARIANT}

// DBRESOURCEKINDENUM constants
type
  DBRESOURCEKINDENUM = TOleEnum;
  {$EXTERNALSYM DBRESOURCEKINDENUM}
const
  DBRESOURCE_INVALID = $00000000;
  {$EXTERNALSYM DBRESOURCE_INVALID}
  DBRESOURCE_TOTAL = $00000001;
  {$EXTERNALSYM DBRESOURCE_TOTAL}
  DBRESOURCE_CPU = $00000002;
  {$EXTERNALSYM DBRESOURCE_CPU}
  DBRESOURCE_MEMORY = $00000003;
  {$EXTERNALSYM DBRESOURCE_MEMORY}
  DBRESOURCE_DISK = $00000004;
  {$EXTERNALSYM DBRESOURCE_DISK}
  DBRESOURCE_NETWORK = $00000005;
  {$EXTERNALSYM DBRESOURCE_NETWORK}
  DBRESOURCE_RESPONSE = $00000006;
  {$EXTERNALSYM DBRESOURCE_RESPONSE}
  DBRESOURCE_ROWS = $00000007;
  {$EXTERNALSYM DBRESOURCE_ROWS}
  DBRESOURCE_OTHER = $00000008;
  {$EXTERNALSYM DBRESOURCE_OTHER}

// DBCOSTUNITENUM constants
type
  DBCOSTUNITENUM = TOleEnum;
  {$EXTERNALSYM DBCOSTUNITENUM}
const
  DBUNIT_INVALID = $00000000;
  {$EXTERNALSYM DBUNIT_INVALID}
  DBUNIT_WEIGHT = $00000001;
  {$EXTERNALSYM DBUNIT_WEIGHT}
  DBUNIT_PERCENT = $00000002;
  {$EXTERNALSYM DBUNIT_PERCENT}
  DBUNIT_MAXIMUM = $00000004;
  {$EXTERNALSYM DBUNIT_MAXIMUM}
  DBUNIT_MINIMUM = $00000008;
  {$EXTERNALSYM DBUNIT_MINIMUM}
  DBUNIT_MICRO_SECOND = $00000010;
  {$EXTERNALSYM DBUNIT_MICRO_SECOND}
  DBUNIT_MILLI_SECOND = $00000020;
  {$EXTERNALSYM DBUNIT_MILLI_SECOND}
  DBUNIT_SECOND = $00000040;
  {$EXTERNALSYM DBUNIT_SECOND}
  DBUNIT_MINUTE = $00000080;
  {$EXTERNALSYM DBUNIT_MINUTE}
  DBUNIT_HOUR = $00000100;
  {$EXTERNALSYM DBUNIT_HOUR}
  DBUNIT_BYTE = $00000200;
  {$EXTERNALSYM DBUNIT_BYTE}
  DBUNIT_KILO_BYTE = $00000400;
  {$EXTERNALSYM DBUNIT_KILO_BYTE}
  DBUNIT_MEGA_BYTE = $00000800;
  {$EXTERNALSYM DBUNIT_MEGA_BYTE}
  DBUNIT_GIGA_BYTE = $00001000;
  {$EXTERNALSYM DBUNIT_GIGA_BYTE}
  DBUNIT_NUM_MSGS = $00002000;
  {$EXTERNALSYM DBUNIT_NUM_MSGS}
  DBUNIT_NUM_LOCKS = $00004000;
  {$EXTERNALSYM DBUNIT_NUM_LOCKS}
  DBUNIT_NUM_ROWS = $00008000;
  {$EXTERNALSYM DBUNIT_NUM_ROWS}
  DBUNIT_OTHER = $00010000;
  {$EXTERNALSYM DBUNIT_OTHER}

// DBEXECLIMITSENUM constants
type
  DBEXECLIMITSENUM = TOleEnum;
  {$EXTERNALSYM DBEXECLIMITSENUM}
const
  DBEXECLIMITS_ABORT = $00000001;
  {$EXTERNALSYM DBEXECLIMITS_ABORT}
  DBEXECLIMITS_STOP = $00000002;
  {$EXTERNALSYM DBEXECLIMITS_STOP}
  DBEXECLIMITS_SUSPEND = $00000003;
  {$EXTERNALSYM DBEXECLIMITS_SUSPEND}

// DBCOMMANDREUSEENUM constants
type
  DBCOMMANDREUSEENUM = TOleEnum;
  {$EXTERNALSYM DBCOMMANDREUSEENUM}
const
  DBCOMMANDREUSE_NONE = $00000000;
  {$EXTERNALSYM DBCOMMANDREUSE_NONE}
  DBCOMMANDREUSE_PROPERTIES = $00000001;
  {$EXTERNALSYM DBCOMMANDREUSE_PROPERTIES}
  DBCOMMANDREUSE_PARAMETERS = $00000002;
  {$EXTERNALSYM DBCOMMANDREUSE_PARAMETERS}

// DBVALUEKINDENUM constants
type
  DBVALUEKINDENUM = TOleEnum;
  {$EXTERNALSYM DBVALUEKINDENUM}
const
  DBVALUEKIND_BYGUID = $00000100;
  {$EXTERNALSYM DBVALUEKIND_BYGUID}
  DBVALUEKIND_COLDESC = $00000101;
  {$EXTERNALSYM DBVALUEKIND_COLDESC}
  DBVALUEKIND_ID = $00000102;
  {$EXTERNALSYM DBVALUEKIND_ID}
  DBVALUEKIND_CONTENT = $00000103;
  {$EXTERNALSYM DBVALUEKIND_CONTENT}
  DBVALUEKIND_CONTENTVECTOR = $00000104;
  {$EXTERNALSYM DBVALUEKIND_CONTENTVECTOR}
  DBVALUEKIND_GROUPINFO = $00000105;
  {$EXTERNALSYM DBVALUEKIND_GROUPINFO}
  DBVALUEKIND_PARAMETER = $00000106;
  {$EXTERNALSYM DBVALUEKIND_PARAMETER}
  DBVALUEKIND_PROPERTY = $00000107;
  {$EXTERNALSYM DBVALUEKIND_PROPERTY}
  DBVALUEKIND_SETFUNC = $00000108;
  {$EXTERNALSYM DBVALUEKIND_SETFUNC}
  DBVALUEKIND_SORTINFO = $00000109;
  {$EXTERNALSYM DBVALUEKIND_SORTINFO}
  DBVALUEKIND_TEXT = $0000010A;
  {$EXTERNALSYM DBVALUEKIND_TEXT}
  DBVALUEKIND_COMMAND = $0000010B;
  {$EXTERNALSYM DBVALUEKIND_COMMAND}
  DBVALUEKIND_MONIKER = $0000010C;
  {$EXTERNALSYM DBVALUEKIND_MONIKER}
  DBVALUEKIND_ROWSET = $0000010D;
  {$EXTERNALSYM DBVALUEKIND_ROWSET}
  DBVALUEKIND_LIKE = $0000010E;
  {$EXTERNALSYM DBVALUEKIND_LIKE}
  DBVALUEKIND_CONTENTPROXIMITY = $0000010F;
  {$EXTERNALSYM DBVALUEKIND_CONTENTPROXIMITY}
  DBVALUEKIND_IDISPATCH = $00000009;
  {$EXTERNALSYM DBVALUEKIND_IDISPATCH}
  DBVALUEKIND_IUNKNOWN = $0000000D;
  {$EXTERNALSYM DBVALUEKIND_IUNKNOWN}
  DBVALUEKIND_EMPTY = $00000000;
  {$EXTERNALSYM DBVALUEKIND_EMPTY}
  DBVALUEKIND_NULL = $00000001;
  {$EXTERNALSYM DBVALUEKIND_NULL}
  DBVALUEKIND_I2 = $00000002;
  {$EXTERNALSYM DBVALUEKIND_I2}
  DBVALUEKIND_I4 = $00000003;
  {$EXTERNALSYM DBVALUEKIND_I4}
  DBVALUEKIND_R4 = $00000004;
  {$EXTERNALSYM DBVALUEKIND_R4}
  DBVALUEKIND_R8 = $00000005;
  {$EXTERNALSYM DBVALUEKIND_R8}
  DBVALUEKIND_CY = $00000006;
  {$EXTERNALSYM DBVALUEKIND_CY}
  DBVALUEKIND_DATE = $00000007;
  {$EXTERNALSYM DBVALUEKIND_DATE}
  DBVALUEKIND_BSTR = $00000008;
  {$EXTERNALSYM DBVALUEKIND_BSTR}
  DBVALUEKIND_ERROR = $0000000A;
  {$EXTERNALSYM DBVALUEKIND_ERROR}
  DBVALUEKIND_BOOL = $0000000B;
  {$EXTERNALSYM DBVALUEKIND_BOOL}
  DBVALUEKIND_VARIANT = $0000000C;
  {$EXTERNALSYM DBVALUEKIND_VARIANT}
  DBVALUEKIND_VECTOR = $00001000;
  {$EXTERNALSYM DBVALUEKIND_VECTOR}
  DBVALUEKIND_ARRAY = $00002000;
  {$EXTERNALSYM DBVALUEKIND_ARRAY}
  DBVALUEKIND_BYREF = $00004000;
  {$EXTERNALSYM DBVALUEKIND_BYREF}
  DBVALUEKIND_I1 = $00000010;
  {$EXTERNALSYM DBVALUEKIND_I1}
  DBVALUEKIND_UI1 = $00000011;
  {$EXTERNALSYM DBVALUEKIND_UI1}
  DBVALUEKIND_UI2 = $00000012;
  {$EXTERNALSYM DBVALUEKIND_UI2}
  DBVALUEKIND_UI4 = $00000013;
  {$EXTERNALSYM DBVALUEKIND_UI4}
  DBVALUEKIND_I8 = $00000014;
  {$EXTERNALSYM DBVALUEKIND_I8}
  DBVALUEKIND_UI8 = $00000015;
  {$EXTERNALSYM DBVALUEKIND_UI8}
  DBVALUEKIND_GUID = $00000048;
  {$EXTERNALSYM DBVALUEKIND_GUID}
  DBVALUEKIND_BYTES = $00000080;
  {$EXTERNALSYM DBVALUEKIND_BYTES}
  DBVALUEKIND_STR = $00000081;
  {$EXTERNALSYM DBVALUEKIND_STR}
  DBVALUEKIND_WSTR = $00000082;
  {$EXTERNALSYM DBVALUEKIND_WSTR}
  DBVALUEKIND_NUMERIC = $00000083;
  {$EXTERNALSYM DBVALUEKIND_NUMERIC}
  DBVALUEKIND_DBDATE = $00000085;
  {$EXTERNALSYM DBVALUEKIND_DBDATE}
  DBVALUEKIND_DBTIME = $00000086;
  {$EXTERNALSYM DBVALUEKIND_DBTIME}
  DBVALUEKIND_DBTIMESTAMP = $00000087;
  {$EXTERNALSYM DBVALUEKIND_DBTIMESTAMP}

// DBSOURCETYPEENUM constants
type
  DBSOURCETYPEENUM = TOleEnum;
  {$EXTERNALSYM DBSOURCETYPEENUM}
const
  DBSOURCETYPE_DATASOURCE = $00000001;
  {$EXTERNALSYM DBSOURCETYPE_DATASOURCE}
  DBSOURCETYPE_ENUMERATOR = $00000002;
  {$EXTERNALSYM DBSOURCETYPE_ENUMERATOR}

// DBSOURCETYPEENUM20 constants
type
  DBSOURCETYPEENUM20 = TOleEnum;
  {$EXTERNALSYM DBSOURCETYPEENUM20}
const
  DBSOURCETYPE_DATASOURCE_TDP = $00000001;
  {$EXTERNALSYM DBSOURCETYPE_DATASOURCE_TDP}
  DBSOURCETYPE_DATASOURCE_MDP = $00000003;
  {$EXTERNALSYM DBSOURCETYPE_DATASOURCE_MDP}

// DBLITERALENUM constants
type
  DBLITERALENUM = TOleEnum;
  {$EXTERNALSYM DBLITERALENUM}
const
  DBLITERAL_INVALID = $00000000;
  {$EXTERNALSYM DBLITERAL_INVALID}
  DBLITERAL_BINARY_LITERAL = $00000001;
  {$EXTERNALSYM DBLITERAL_BINARY_LITERAL}
  DBLITERAL_CATALOG_NAME = $00000002;
  {$EXTERNALSYM DBLITERAL_CATALOG_NAME}
  DBLITERAL_CATALOG_SEPARATOR = $00000003;
  {$EXTERNALSYM DBLITERAL_CATALOG_SEPARATOR}
  DBLITERAL_CHAR_LITERAL = $00000004;
  {$EXTERNALSYM DBLITERAL_CHAR_LITERAL}
  DBLITERAL_COLUMN_ALIAS = $00000005;
  {$EXTERNALSYM DBLITERAL_COLUMN_ALIAS}
  DBLITERAL_COLUMN_NAME = $00000006;
  {$EXTERNALSYM DBLITERAL_COLUMN_NAME}
  DBLITERAL_CORRELATION_NAME = $00000007;
  {$EXTERNALSYM DBLITERAL_CORRELATION_NAME}
  DBLITERAL_CURSOR_NAME = $00000008;
  {$EXTERNALSYM DBLITERAL_CURSOR_NAME}
  DBLITERAL_ESCAPE_PERCENT = $00000009;
  {$EXTERNALSYM DBLITERAL_ESCAPE_PERCENT}
  DBLITERAL_ESCAPE_UNDERSCORE = $0000000A;
  {$EXTERNALSYM DBLITERAL_ESCAPE_UNDERSCORE}
  DBLITERAL_INDEX_NAME = $0000000B;
  {$EXTERNALSYM DBLITERAL_INDEX_NAME}
  DBLITERAL_LIKE_PERCENT = $0000000C;
  {$EXTERNALSYM DBLITERAL_LIKE_PERCENT}
  DBLITERAL_LIKE_UNDERSCORE = $0000000D;
  {$EXTERNALSYM DBLITERAL_LIKE_UNDERSCORE}
  DBLITERAL_PROCEDURE_NAME = $0000000E;
  {$EXTERNALSYM DBLITERAL_PROCEDURE_NAME}
  DBLITERAL_QUOTE = $0000000F;
  {$EXTERNALSYM DBLITERAL_QUOTE}
  DBLITERAL_SCHEMA_NAME = $00000010;
  {$EXTERNALSYM DBLITERAL_SCHEMA_NAME}
  DBLITERAL_TABLE_NAME = $00000011;
  {$EXTERNALSYM DBLITERAL_TABLE_NAME}
  DBLITERAL_TEXT_COMMAND = $00000012;
  {$EXTERNALSYM DBLITERAL_TEXT_COMMAND}
  DBLITERAL_USER_NAME = $00000013;
  {$EXTERNALSYM DBLITERAL_USER_NAME}
  DBLITERAL_VIEW_NAME = $00000014;
  {$EXTERNALSYM DBLITERAL_VIEW_NAME}

// DBLITERALENUM20 constants
type
  DBLITERALENUM20 = TOleEnum;
  {$EXTERNALSYM DBLITERALENUM20}
const
  DBLITERAL_CUBE_NAME = $00000015;
  {$EXTERNALSYM DBLITERAL_CUBE_NAME}
  DBLITERAL_DIMENSION_NAME = $00000016;
  {$EXTERNALSYM DBLITERAL_DIMENSION_NAME}
  DBLITERAL_HIERARCHY_NAME = $00000017;
  {$EXTERNALSYM DBLITERAL_HIERARCHY_NAME}
  DBLITERAL_LEVEL_NAME = $00000018;
  {$EXTERNALSYM DBLITERAL_LEVEL_NAME}
  DBLITERAL_MEMBER_NAME = $00000019;
  {$EXTERNALSYM DBLITERAL_MEMBER_NAME}
  DBLITERAL_PROPERTY_NAME = $0000001A;
  {$EXTERNALSYM DBLITERAL_PROPERTY_NAME}
  DBLITERAL_SCHEMA_SEPARATOR = $0000001B;
  {$EXTERNALSYM DBLITERAL_SCHEMA_SEPARATOR}
  DBLITERAL_QUOTE_SUFFIX = $0000001C;
  {$EXTERNALSYM DBLITERAL_QUOTE_SUFFIX}

// ACCESS_MASKENUM constants
type
  ACCESS_MASKENUM = TOleEnum;
  {$EXTERNALSYM ACCESS_MASKENUM}
const
  PERM_EXCLUSIVE = $00000200;
  {$EXTERNALSYM PERM_EXCLUSIVE}
  PERM_READDESIGN = $00000400;
  {$EXTERNALSYM PERM_READDESIGN}
  PERM_WRITEDESIGN = $00000800;
  {$EXTERNALSYM PERM_WRITEDESIGN}
  PERM_WITHGRANT = $00001000;
  {$EXTERNALSYM PERM_WITHGRANT}
  PERM_REFERENCE = $00002000;
  {$EXTERNALSYM PERM_REFERENCE}
  PERM_CREATE = $00004000;
  {$EXTERNALSYM PERM_CREATE}
  PERM_INSERT = $00008000;
  {$EXTERNALSYM PERM_INSERT}
  PERM_DELETE = $00010000;
  {$EXTERNALSYM PERM_DELETE}
  PERM_READCONTROL = $00020000;
  {$EXTERNALSYM PERM_READCONTROL}
  PERM_WRITEPERMISSIONS = $00040000;
  {$EXTERNALSYM PERM_WRITEPERMISSIONS}
  PERM_WRITEOWNER = $00080000;
  {$EXTERNALSYM PERM_WRITEOWNER}
  PERM_MAXIMUM_ALLOWED = $02000000;
  {$EXTERNALSYM PERM_MAXIMUM_ALLOWED}
  PERM_ALL = $10000000;
  {$EXTERNALSYM PERM_ALL}
  PERM_EXECUTE = $20000000;
  {$EXTERNALSYM PERM_EXECUTE}
  PERM_READ = $80000000;
  {$EXTERNALSYM PERM_READ}
  PERM_UPDATE = $40000000;
  {$EXTERNALSYM PERM_UPDATE}
  PERM_DROP = $00000100;
  {$EXTERNALSYM PERM_DROP}

//MULTIPLE_TRUSTEE_OPERATION constants
type
  MULTIPLE_TRUSTEE_OPERATION = TOleEnum;
  {$EXTERNALSYM MULTIPLE_TRUSTEE_OPERATION}
const
  NO_MULTIPLE_TRUSTEE = $00000000;
  {$EXTERNALSYM NO_MULTIPLE_TRUSTEE}
  TRUSTEE_IS_IMPERSONATE = $00000001;
  {$EXTERNALSYM TRUSTEE_IS_IMPERSONATE}

// TRUSTEE_FORM constants
type
  TRUSTEE_FORM = TOleEnum;
  {$EXTERNALSYM TRUSTEE_FORM}
const
  TRUSTEE_IS_SID = $00000000;
  {$EXTERNALSYM TRUSTEE_IS_SID}
  TRUSTEE_IS_NAME = $00000001;
  {$EXTERNALSYM TRUSTEE_IS_NAME}
  TRUSTEE_BAD_FORM = $00000002;
  {$EXTERNALSYM TRUSTEE_BAD_FORM}

// TRUSTEE_TYPE constants
type
  TRUSTEE_TYPE = TOleEnum;
  {$EXTERNALSYM TRUSTEE_TYPE}
const
  TRUSTEE_IS_UNKNOWN = $00000000;
  {$EXTERNALSYM TRUSTEE_IS_UNKNOWN}
  TRUSTEE_IS_USER = $00000001;
  {$EXTERNALSYM TRUSTEE_IS_USER}
  TRUSTEE_IS_GROUP = $00000002;
  {$EXTERNALSYM TRUSTEE_IS_GROUP}
  TRUSTEE_IS_DOMAIN = $00000003;
  {$EXTERNALSYM TRUSTEE_IS_DOMAIN}
  TRUSTEE_IS_ALIAS = $00000004;
  {$EXTERNALSYM TRUSTEE_IS_ALIAS}
  TRUSTEE_IS_WELL_KNOWN_GROUP = $00000005;
  {$EXTERNALSYM TRUSTEE_IS_WELL_KNOWN_GROUP}
  TRUSTEE_IS_DELETED = $00000006;
  {$EXTERNALSYM TRUSTEE_IS_DELETED}
  TRUSTEE_IS_INVALID = $00000007;
  {$EXTERNALSYM TRUSTEE_IS_INVALID}

// ACCESS_MODE constants
type
  ACCESS_MODE = TOleEnum;
  {$EXTERNALSYM ACCESS_MODE}
const
  NOT_USED_ACCESS = $00000000;
  {$EXTERNALSYM NOT_USED_ACCESS}
  GRANT_ACCESS = $00000001;
  {$EXTERNALSYM GRANT_ACCESS}
  SET_ACCESS = $00000002;
  {$EXTERNALSYM SET_ACCESS}
  DENY_ACCESS = $00000003;
  {$EXTERNALSYM DENY_ACCESS}
  REVOKE_ACCESS = $00000004;
  {$EXTERNALSYM REVOKE_ACCESS}
  SET_AUDIT_SUCCESS = $00000005;
  {$EXTERNALSYM SET_AUDIT_SUCCESS}
  SET_AUDIT_FAILURE = $00000006;
  {$EXTERNALSYM SET_AUDIT_FAILURE}

// DBPROPTOPTIONS constants
type
  DBPROMPTOPTIONS = TOleEnum;
  {$EXTERNALSYM DBPROMPTOPTIONS}
const
  DBPROMPTOPTIONS_NONE = 0;
  {$EXTERNALSYM DBPROMPTOPTIONS_NONE}
  DBPROMPTOPTIONS_WIZARDSHEET = $1;
  {$EXTERNALSYM DBPROMPTOPTIONS_WIZARDSHEET}
  DBPROMPTOPTIONS_PROPERTYSHEET = $2;
  {$EXTERNALSYM DBPROMPTOPTIONS_PROPERTYSHEET}
  DBPROMPTOPTIONS_BROWSEONLY = $8;
  {$EXTERNALSYM DBPROMPTOPTIONS_BROWSEONLY}
  DBPROMPTOPTIONS_DISABLE_PROVIDER_SELECTION = $10;
  {$EXTERNALSYM DBPROMPTOPTIONS_DISABLE_PROVIDER_SELECTION}

type

// *********************************************************************//
// Declaration of structures, unions and aliases.                       //
// *********************************************************************//

  PIUnknown = ^IUnknown;
  SBYTE = Shortint;
  PUintArray = ^TUintArray;
  TUintArray = array[0..MAXBOUND] of UINT;
  PPByte = ^PByte;
  PPByteArray = ^TPByteArray;
  TPByteArray = array[0..MAXBOUND] of PByte;

  DBSTATUS = DWORD;
  {$EXTERNALSYM DBSTATUS}
  DBTYPE = Word;
  {$EXTERNALSYM DBTYPE}
  DBKIND = UINT;
  {$EXTERNALSYM DBKIND}
  DBPARAMIO = UINT;
  {$EXTERNALSYM DBPARAMIO}
  DBMEMOWNER = UINT;
  {$EXTERNALSYM DBMEMOWNER}
  DBPART = UINT;
  {$EXTERNALSYM DBPART}
  DBPROPSTATUS = UINT;
  {$EXTERNALSYM DBPROPSTATUS}
  DBPROPOPTIONS = UINT;
  {$EXTERNALSYM DBPROPOPTIONS}
  DBPROPFLAGS = UINT;
  {$EXTERNALSYM DBPROPFLAGS}
  DBBINDSTATUS = UINT;
  {$EXTERNALSYM DBBINDSTATUS}
  HWATCHREGION = UINT;
  {$EXTERNALSYM HWATCHREGION}
  DBINDEX_COL_ORDER = UINT;
  {$EXTERNALSYM DBINDEX_COL_ORDER}
  DBCOLUMNFLAGS = UINT;
  {$EXTERNALSYM DBCOLUMNFLAGS}
  DBCOMMANDOP = Word;
  {$EXTERNALSYM DBCOMMANDOP}
  DBASYNCHOP = UINT;
  {$EXTERNALSYM DBASYNCHOP}
  DBREASON = UINT;
  {$EXTERNALSYM DBREASON}
  DBEVENTPHASE = UINT;
  {$EXTERNALSYM DBEVENTPHASE}
  DBCOLUMNDESCFLAGS = UINT;
  {$EXTERNALSYM DBCOLUMNDESCFLAGS}
  DBPARAMFLAGS = UINT;
  {$EXTERNALSYM DBPARAMFLAGS}

  DBASYNCHPHASE = UINT;
  PDBASYNCHPHASE = ^DBASYNCHPHASE;
  {$EXTERNALSYM DBASYNCHPHASE}

  DBSORT = UINT;
  PDBSORT = ^DBSORT;
  {$EXTERNALSYM DBSORT}

  DBCOMPAREOP = UINT;
  PDBCOMPAREOP = ^DBCOMPAREOP;
  {$EXTERNALSYM DBCOMPAREOP}

  HACCESSOR = UINT;
  PHACCESSOR = ^HACCESSOR;
  {$EXTERNALSYM HACCESSOR}

  HSOURCE = Word;
  PHSOURCE = ^HSOURCE;
  {$EXTERNALSYM HSOURCE}

  HCHAPTER = UINT;
  PHCHAPTER = HCHAPTER;
  {$EXTERNALSYM HCHAPTER}

  HROW = UINT;
  PHROW = ^HROW;
  PPHROW = ^PHROW;
  {$EXTERNALSYM HROW}

  DBROWSTATUS = UINT;
  PDBROWSTATUS = ^DBROWSTATUS;
  PPDBROWSTATUS = ^PDBROWSTATUS;
  {$EXTERNALSYM DBROWSTATUS}

  DBPENDINGSTATUS = DWORD;
  PDBPENDINGSTATUS = ^DBPENDINGSTATUS;
  PPDBPENDINGSTATUS = ^PDBPENDINGSTATUS;
  {$EXTERNALSYM DBPENDINGSTATUS}

  DBROWOPTIONS = UINT;
  PDBROWOPTIONS = ^DBROWOPTIONS;
  {$EXTERNALSYM DBROWOPTIONS}

  DBSOURCETYPE = DWORD;
  PDBSOURCETYPE = ^DBSOURCETYPE;
  {$EXTERNALSYM DBSOURCETYPE}

  PBoid = ^TBoid;
  BOID = packed record
    rgb_: array[0..15] of Byte;
  end;
  TBoid = BOID;
  {$EXTERNALSYM BOID}

  PXactTransInfo = ^TXactTransInfo;
  XACTTRANSINFO = packed record
    uow: BOID;
    isoLevel: Integer;
    isoFlags: UINT;
    grfTCSupported: UINT;
    grfRMSupported: UINT;
    grfTCSupportedRetaining: UINT;
    grfRMSupportedRetaining: UINT;
  end;
  TXactTransInfo = XACTTRANSINFO;
  {$EXTERNALSYM XACTTRANSINFO}

  PXactOpt = ^TXactOpt;
  XACTOPT = packed record
    ulTimeout: UINT;
    szDescription: array[0..39] of Shortint;
  end;
  TXActOpt = XACTOPT;
  {$EXTERNALSYM XACTOPT}

  PXactStats = ^TXactStats;
  XACTSTATS = packed record
    cOpen: UINT;
    cCommitting: UINT;
    cCommitted: UINT;
    cAborting: UINT;
    cAborted: UINT;
    cInDoubt: UINT;
    cHeuristicDecision: UINT;
    timeTransactionsUp: FILETIME;
  end;
  TXactStats = XACTSTATS;
  {$EXTERNALSYM XACTSTATS}

  PDBBindExt = ^TDBBindExt;
  DBBINDEXT = packed record
    pExtension: PByte;
    ulExtension: UINT;
  end;
  TDBBindExt = DBBINDEXT;
  {$EXTERNALSYM DBBINDEXT}

  PDBObject = ^TDBObject;
  DBOBJECT = packed record
    dwFlags: UINT;
    iid: TGUID;
  end;
  TDBObject = DBOBJECT;
  {$EXTERNALSYM DBOBJECT}

  PDBBinding = ^TDBBinding;
  DBBINDING = packed record
    iOrdinal: UINT;
    obValue: UINT;
    obLength: UINT;
    obStatus: UINT;
    pTypeInfo: ITypeInfo;
    pObject: PDBObject;
    pBindExt: PDBBindExt;
    dwPart: DBPART;
    dwMemOwner: DBMEMOWNER;
    eParamIO: DBPARAMIO;
    cbMaxLen: UINT;
    dwFlags: UINT;
    wType: DBTYPE;
    bPrecision: Byte;
    bScale: Byte;
  end;
  TDBBinding = DBBINDING;
  {$EXTERNALSYM DBBINDING}

  PDBBindingArray = ^TDBBindingArray;
  TDBBindingArray = array[0..MAXBOUND] of TDBBinding;

  PDBIDName = ^TDBIDName;
  DBIDNAME = record
    case Integer of
      0: (pwszName: PWideChar);
      1: (ulPropid: UINT);
  end;
  TDBIDName = DBIDNAME;

  PDBIDGuid = ^TDBIDGuid;
  DBIDGUID = record
    case Integer of
      0: (guid: TGUID);
      1: (pguid: ^TGUID);
  end;
  TDBIDGuid = DBIDGUID;

  DBPROPID = UINT;
  {$EXTERNALSYM DBPROPID}
  PDBPROPID = ^DBPROPID;
  PDBPropIDArray = ^TDBPropIDArray;
  TDBPropIDArray = array[0..MAXBOUND] of DBPROPID;

  PPDBID = ^PDBID;
  PDBID = ^DBID;
  DBID = packed record
    uGuid: DBIDGUID;
    eKind: DBKIND;
    uName: DBIDNAME;
  end;
  TDBID = DBID;
  {$EXTERNALSYM DBID}

  PDBIDArray = ^TDBIDArray;
  TDBIDArray = array[0..MAXBOUND] of TDBID;

  PDBPropIDSet = ^TDBPropIDSet;
  DBPROPIDSET = packed record
    rgPropertyIDs: PDBPropIDArray;
    cPropertyIDs: UINT;
    guidPropertySet: TGUID;
  end;
  TDBPropIDSet = DBPROPIDSET;
  {$EXTERNALSYM DBPROPIDSET}

  PDBPropIDSetArray = ^TDBPropIDSetArray;
  TDBPropIDSetArray = array[0..MAXBOUND] of TDBPropIDSet;

  PDBProp = ^TDBProp;
  DBPROP = packed record
    dwPropertyID: DBPROPID;
    dwOptions: DBPROPOPTIONS;
    dwStatus: DBPROPSTATUS;
    colid: DBID;
    vValue: OleVariant;
  end;
  TDBProp = DBPROP;
  {$EXTERNALSYM DBPROP}

  PDBPropArray = ^TDBPropArray;
  TDBPropArray = array[0..MAXBOUND] of TDBProp;


  PPDBPropSet = ^PDBPropSet;
  PDBPropSet = ^TDBPropSet;
  DBPROPSET = packed record
    rgProperties: PDBPropArray;
    cProperties: UINT;
    guidPropertySet: TGUID;
  end;
  TDBPropSet = DBPROPSET;
  {$EXTERNALSYM DBPROPSET}

  PDBPropSetArray = ^TDBPropSetArray;
  TDBPropSetArray = array[0..MAXBOUND] of TDBPropSet;

  PDBPropInfo = ^TDBPropInfo;
  DBPROPINFO = packed record
    pwszDescription: PWideChar;
    dwPropertyID: DBPROPID;
    dwFlags: DBPROPFLAGS;
    vtType: Word;
    vValues: OleVariant;
  end;
  TDBPropInfo = DBPROPINFO;
  {$EXTERNALSYM DBPROPINFO}

  PDBPropInfoArray = ^TDBPropInfoArray;
  TDBPropInfoArray = array[0..MAXBOUND] of TDBPropInfo;

  PDBPropInfoSet = ^TDBPropInfoSet;
  DBPROPINFOSET = packed record
    rgPropertyInfos: PDBPropInfoArray;
    cPropertyInfos: UINT;
    guidPropertySet: TGUID;
  end;
  TDBPropInfoSet = DBPROPINFOSET;
  {$EXTERNALSYM DBPROPINFOSET}

  PDBPropInfoSetArray = ^TDBPropInfoSetArray;
  TDBPropInfoSetArray = array[0..MAXBOUND] of TDBPropInfoSet;

  PDBIndexColumnDesc = ^TDBIndexColumnDesc;
  DBINDEXCOLUMNDESC = packed record
    pColumnID: ^DBID;
    eIndexColOrder: DBINDEX_COL_ORDER;
  end;
  TDBIndexColumnDesc = DBINDEXCOLUMNDESC;
  {$EXTERNALSYM DBINDEXCOLUMNDESC}

  PDBIndexColumnDescArray = ^TDBIndexColumnDescArray;
  TDBIndexColumnDescArray = array[0..MAXBOUND] of TDBIndexColumnDesc;

  PDBParams = ^TDBPARAMS;
  DBPARAMS = packed record
    pData: Pointer;
    cParamSets: UINT;
    HACCESSOR: HACCESSOR;
  end;
  TDBParams = DBPARAMS;
  {$EXTERNALSYM DBPARAMS}

  PDBColumnInfo = ^TDBColumnInfo;
  DBCOLUMNINFO = packed record
    pwszName: PWideChar;
    pTypeInfo: ITypeInfo;
    iOrdinal: UINT;
    dwFlags: DBCOLUMNFLAGS;
    ulColumnSize: UINT;
    wType: DBTYPE;
    bPrecision: Byte;
    bScale: Byte;
    columnid: DBID;
  end;
  TDBColumnInfo = DBCOLUMNINFO;
  {$EXTERNALSYM DBCOLUMNINFO}

  PDBColumnInfoArray = ^TDBColumnInfoArray;
  TDBColumnInfoArray = array[0..MAXCOLS] of TDBColumnInfo;

  PDBLiteralInfo = ^DBLiteralInfo;
  DBLITERALINFO = packed record
    pwszLiteralValue: PWideChar;
    pwszInvalidChars: PWideChar;
    pwszInvalidStartingChars: PWideChar;
    lt: UINT;
    fSupported: BOOL;
    cchMaxLen: UINT;
  end;
  TDBLiteralInfo = DBLITERALINFO;
  {$EXTERNALSYM DBLITERALINFO}

  PDBLiteralInfoArray = ^TDBLiteralInfoArray;
  TDBLiteralInfoArray = array[0..MAXBOUND] of TDBLiteralInfo;

  PDBColumnDesc = ^TDBColumnDesc;
  DBCOLUMNDESC = packed record
    pwszTypeName: PWideChar;
    pTypeInfo: ITypeInfo;
    rgPropertySets: ^DBPROPSET;
    pclsid: ^TGUID;
    cPropertySets: UINT;
    ulColumnSize: UINT;
    dbcid: DBID;
    wType: DBTYPE;
    bPrecision: Byte;
    bScale: Byte;
  end;
  TDBColumnDesc = DBCOLUMNDESC;
  {$EXTERNALSYM DBCOLUMNDESC}

  PDBColumnDescArray = ^TDBColumnDescArray;
  TDBColumnDescArray = array[0..MAXBOUND] of TDBColumnDesc;

  PSecObjectElement = ^TSecObjectElement;
  SEC_OBJECT_ELEMENT = packed record
    guidObjectType: TGUID;
    ObjectID: DBID;
  end;
  TSecObjectElement = SEC_OBJECT_ELEMENT;
  {$EXTERNALSYM SEC_OBJECT_ELEMENT}

  PSecObjectElementArray = ^TSecObjectElementArray;
  TSecObjectElementArray = array[0..MAXBOUND] of TSecObjectElement;

  PSecObject = ^TSecObject;
  SEC_OBJECT = packed record
    cObjects: UINT;
    prgObjects: PSecObjectElementArray;
  end;
  TSecObject = SEC_OBJECT;
  {$EXTERNALSYM SEC_OBJECT}

  PPTrusteeW = ^PTrusteeW;
  PTrusteeW = ^TTrusteeW;
  TRUSTEE_W = packed record
    pMultipleTrustee: PTrusteeW;
    MultipleTrusteeOperation: MULTIPLE_TRUSTEE_OPERATION;
    TrusteeForm: TRUSTEE_FORM;
    TrusteeType: TRUSTEE_TYPE;
    ptstrName: PWideChar;
  end;
  TTrusteeW = ^TRUSTEE_W;
  {$EXTERNALSYM TRUSTEE_W}

  PDBParamInfo = ^TDBParamInfo;
  DBPARAMINFO = packed record
    dwFlags: DBPARAMFLAGS;
    iOrdinal: UINT;
    pwszName: PWideChar;
    pTypeInfo: ITypeInfo;
    ulParamSize: UINT;
    wType: DBTYPE;
    bPrecision: Byte;
    bScale: Byte;
  end;
  TDBParamInfo = DBPARAMINFO;
  {$EXTERNALSYM DBPARAMINFO}

  PDBParamInfoArray = ^TDBParamInfoArray;
  TDBParamInfoArray = array[0..MAXBOUND] of DBPARAMINFO;

  PDBNumeric = ^TDBNumeric;
  DB_NUMERIC = packed record
    precision: Byte;
    scale: Byte;
    sign: Byte;
    val: array[0..15] of Byte;
  end;
  TDBNumeric = DB_NUMERIC;
  {$EXTERNALSYM DB_NUMERIC}

  PDBVector = ^TDBVector;
  DBVECTOR = packed record
    size: UINT;
    ptr: Pointer;
  end;
  TDBVector = DBVECTOR;
  {$EXTERNALSYM DBVECTOR}

  PDBDate = ^TDBDate;
  DBDATE = packed record
    year: Smallint;
    month: Word;
    day: Word;
  end;
  TDBDate = DBDATE;
  {$EXTERNALSYM DBDATE}

  PDBTime = ^TDBTime;
  DBTIME = packed record
    hour: Word;
    minute: Word;
    second: Word;
  end;
  TDBTime = DBTIME;
  {$EXTERNALSYM DBTIME}

  PDBTimeStamp = ^TDBTimeStamp;
  DBTIMESTAMP = packed record
    year: Smallint;
    month: Word;
    day: Word;
    hour: Word;
    minute: Word;
    second: Word;
    fraction: UINT;
  end;
  TDBTimeStamp = DBTIMESTAMP;
  {$EXTERNALSYM DBTIMESTAMP}

  PDBFileTime = ^TDBFileTime;
  DBFILETIME = packed record
    dwLowDateTime: UINT;
    dwHighDateTime: UINT;
  end;
  TDBFileTime = DBFILETIME;
  { DBFILETIME should be FILETIME }

  PDBVarNumeric = ^TDBVarNumeric;
  DB_VARNUMERIC = packed record
    precision: Byte;
    scale: SBYTE;
    sign: Byte;
    val: ^Byte;
  end;
  TDBVarNumeric = DB_VARNUMERIC;
  {$EXTERNALSYM DB_VARNUMERIC}

  PDBFailureInfo = ^TDBFailureInfo;
  DBFAILUREINFO = packed record
    HROW: HROW;
    iColumn: UINT;
    failure: HResult;
  end;
  TDBFailureInfo = DBFAILUREINFO;
  {$EXTERNALSYM DBFAILUREINFO}

  PMDAxisInfo = ^TMDAxisInfo;
  MDAXISINFO = packed record
    cbSize: UINT;
    iAxis: UINT;
    cDimensions: UINT;
    cCoordinates: UINT;
    rgcColumns: ^UINT;
    rgpwszDimensionNames: ^PWideChar;
  end;
  TMDAxisInfo = MDAXISINFO;
  {$EXTERNALSYM MDAXISINFO}

  PDBParamBindInfo = ^TDBParamBindInfo;
  DBPARAMBINDINFO = packed record
    pwszDataSourceType: PWideChar;
    pwszName: PWideChar;
    ulParamSize: UINT;
    dwFlags: DBPARAMFLAGS;
    bPrecision: Byte;
    bScale: Byte;
  end;
  TDBParamBindInfo = DBPARAMBINDINFO;
  {$EXTERNALSYM DBPARAMBINDINFO}

  PDBParamBindInfoArray = ^TDBParamBindInfoArray;
  TDBParamBindInfoArray = array[0..MAXBOUND] of TDBParamBindInfo;

  PErrorInfo = ^TErrorInfo;
  ERRORINFO = packed record
    hrError: HResult;
    dwMinor: UINT;
    clsid: TGUID;
    iid: TGUID;
    dispid: Integer;
  end;
  TErrorInfo = ERRORINFO;
  {$EXTERNALSYM ERRORINFO}

  PPExplicitAccessW = ^PExplicitAccessW;
  PExplicitAccessW = ^TExplicitAccessW;
  EXPLICIT_ACCESS_W = packed record
    grfAccessPermissions: UINT;
    grfAccessMode: ACCESS_MODE;
    grfInheritance: UINT;
    Trustee: TRUSTEE_W;
  end;
  TExplicitAccessW = EXPLICIT_ACCESS_W;
  {$EXTERNALSYM EXPLICIT_ACCESS_W}

// *********************************************************************//
//  DBID Values
// *********************************************************************//
const
  DB_NULLID: DBID = (uguid: (guid: (D1: 0; D2: 0; D3:0; D4: (0, 0, 0, 0, 0, 0, 0, 0))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid:0));
  {$EXTERNALSYM DB_NULLID}
  DBCOLUMN_IDNAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 2));
  {$EXTERNALSYM DBCOLUMN_IDNAME}
  DBCOLUMN_NAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 3));
  {$EXTERNALSYM DBCOLUMN_NAME}
  DBCOLUMN_NUMBER: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 4));
  {$EXTERNALSYM DBCOLUMN_NUMBER}
  DBCOLUMN_TYPE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 5));
  {$EXTERNALSYM DBCOLUMN_TYPE}
  DBCOLUMN_PRECISION: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 7));
  {$EXTERNALSYM DBCOLUMN_PRECISION}
  DBCOLUMN_SCALE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 8));
  {$EXTERNALSYM DBCOLUMN_SCALE}
  DBCOLUMN_FLAGS: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 9));
  {$EXTERNALSYM DBCOLUMN_FLAGS}
  DBCOLUMN_BASECOLUMNNAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 10));
  {$EXTERNALSYM DBCOLUMN_BASECOLUMNNAME}
  DBCOLUMN_BASETABLENAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 11));
  {$EXTERNALSYM DBCOLUMN_BASETABLENAME}
  DBCOLUMN_COLLATINGSEQUENCE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 12));
  {$EXTERNALSYM DBCOLUMN_COLLATINGSEQUENCE}
  DBCOLUMN_COMPUTEMODE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 13));
  {$EXTERNALSYM DBCOLUMN_COMPUTEMODE}
  DBCOLUMN_DEFAULTVALUE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 14));
  {$EXTERNALSYM DBCOLUMN_DEFAULTVALUE}
  DBCOLUMN_DOMAINNAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 15));
  {$EXTERNALSYM DBCOLUMN_DOMAINNAME}
  DBCOLUMN_HASDEFAULT: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 16));
  {$EXTERNALSYM DBCOLUMN_HASDEFAULT}
  DBCOLUMN_ISAUTOINCREMENT: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 17));
  {$EXTERNALSYM DBCOLUMN_ISAUTOINCREMENT}
  DBCOLUMN_ISCASESENSITIVE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 18));
  {$EXTERNALSYM DBCOLUMN_ISCASESENSITIVE}
  DBCOLUMN_ISSEARCHABLE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 20));
  {$EXTERNALSYM DBCOLUMN_ISSEARCHABLE}
  DBCOLUMN_ISUNIQUE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 21));
  {$EXTERNALSYM DBCOLUMN_ISUNIQUE}
  DBCOLUMN_BASECATALOGNAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 223));
  {$EXTERNALSYM DBCOLUMN_BASECATALOGNAME}
  DBCOLUMN_BASESCHEMANAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 24));
  {$EXTERNALSYM DBCOLUMN_BASESCHEMANAME}
  DBCOLUMN_GUID: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 29));
  {$EXTERNALSYM DBCOLUMN_GUID}
  DBCOLUMN_PROPID: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 30));
  {$EXTERNALSYM DBCOLUMN_PROPID}
  DBCOLUMN_TYPEINFO: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 31));
  {$EXTERNALSYM DBCOLUMN_TYPEINFO}
  DBCOLUMN_DOMAINCATALOG: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 32));
  {$EXTERNALSYM DBCOLUMN_DOMAINCATALOG}
  DBCOLUMN_DOMAINSCHEMA: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 33));
  {$EXTERNALSYM DBCOLUMN_DOMAINSCHEMA}
  DBCOLUMN_DATETIMEPRECISION: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 34));
  {$EXTERNALSYM DBCOLUMN_DATETIMEPRECISION}
  DBCOLUMN_NUMERICPRECISIONRADIX: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 35));
  {$EXTERNALSYM DBCOLUMN_NUMERICPRECISIONRADIX}
  DBCOLUMN_OCTETLENGTH: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 36));
  {$EXTERNALSYM DBCOLUMN_OCTETLENGTH}
  DBCOLUMN_COLUMNSIZE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 37));
  {$EXTERNALSYM DBCOLUMN_COLUMNSIZE}
  DBCOLUMN_CLSID: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 38));
  {$EXTERNALSYM DBCOLUMN_CLSID}
  DBCOLUMN_BASETABLEVERSION: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 40));
  {$EXTERNALSYM DBCOLUMN_BASETABLEVERSION}
  DBCOLUMN_KEYCOLUMN: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 41));
  {$EXTERNALSYM DBCOLUMN_KEYCOLUMN}
  DBCOLUMN_MAYSORT: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 39));
  {$EXTERNALSYM DBCOLUMN_MAYSORT}

type

// *********************************************************************//
// Interface: ITransaction
// GUID:      {0FB15084-AF41-11CE-BD2B-204C4F4F5020}
// *********************************************************************//
  ITransaction = interface(IUnknown)
    ['{0FB15084-AF41-11CE-BD2B-204C4F4F5020}']
    function Commit(fRetaining: BOOL; grfTC: UINT; grfRM: UINT): HResult; stdcall;
    function Abort(pboidReason: PBOID; fRetaining: BOOL; fAsync: BOOL): HResult; stdcall;
    function GetTransactionInfo(out pinfo: XACTTRANSINFO): HResult; stdcall;
  end;

  { Safecall Version }
  ITransactionSC = interface(IUnknown)
    ['{0FB15084-AF41-11CE-BD2B-204C4F4F5020}']
    procedure Commit(fRetaining: BOOL; grfTC: UINT; grfRM: UINT); safecall;
    procedure Abort(pboidReason: PBOID; fRetaining: BOOL; fAsync: BOOL); safecall;
    procedure GetTransactionInfo(out pinfo: XACTTRANSINFO); safecall;
  end;

// *********************************************************************//
// Interface: ITransactionOptions
// GUID:      {3A6AD9E0-23B9-11CF-AD60-00AA00A74CCD}
// *********************************************************************//
  ITransactionOptions = interface(IUnknown)
    ['{3A6AD9E0-23B9-11CF-AD60-00AA00A74CCD}']
    function SetOptions(var pOptions: XACTOPT): HResult; stdcall;
    function GetOptions(var pOptions: XACTOPT): HResult; stdcall;
  end;

  { Safecall Version }
  ITransactionOptionsSC = interface(IUnknown)
    ['{3A6AD9E0-23B9-11CF-AD60-00AA00A74CCD}']
    procedure SetOptions(var pOptions: XACTOPT); safecall;
    procedure GetOptions(var pOptions: XACTOPT); safecall;
  end;

// *********************************************************************//
// Interface: ITransactionDispenser
// GUID:      {3A6AD9E1-23B9-11CF-AD60-00AA00A74CCD}
// *********************************************************************//
  ITransactionDispenser = interface(IUnknown)
    ['{3A6AD9E1-23B9-11CF-AD60-00AA00A74CCD}']
    function GetOptionsObject(out ppOptions: ITransactionOptions): HResult; stdcall;
    function BeginTransaction(const punkOuter: IUnknown; isoLevel: Integer; isoFlags: UINT;
      const pOptions: ITransactionOptions; out ppTransaction: ITransaction): HResult; stdcall;
  end;

  { Safecall Version }
  ITransactionDispenserSC = interface(IUnknown)
    ['{3A6AD9E1-23B9-11CF-AD60-00AA00A74CCD}']
    procedure GetOptionsObject(out ppOptions: ITransactionOptions); safecall;
    procedure BeginTransaction(const punkOuter: IUnknown; isoLevel: Integer; isoFlags: UINT;
      const pOptions: ITransactionOptions; out ppTransaction: ITransaction); safecall;
  end;

// *********************************************************************//
// Interface: ITransactionOutcomeEvents
// GUID:      {3A6AD9E2-23B9-11CF-AD60-00AA00A74CCD}
// *********************************************************************//
  ITransactionOutcomeEvents = interface(IUnknown)
    ['{3A6AD9E2-23B9-11CF-AD60-00AA00A74CCD}']
    function Committed(fRetaining: BOOL; pNewUOW: PBOID; hr: HResult): HResult; stdcall;
    function Aborted(pboidReason: PBOID; fRetaining: BOOL; pNewUOW: PBOID;
      hr: HResult): HResult; stdcall;
    function HeuristicDecision(dwDecision: UINT; pboidReason: PBOID;
      hr: HResult): HResult; stdcall;
    function Indoubt: HResult; stdcall;
  end;

  { Safecall Version }
  ITransactionOutcomeEventsSC = interface(IUnknown)
    ['{3A6AD9E2-23B9-11CF-AD60-00AA00A74CCD}']
    procedure Committed(fRetaining: BOOL; pNewUOW: PBOID; hr: HResult); safecall;
    procedure Aborted(pboidReason: PBOID; fRetaining: BOOL; pNewUOW: PBOID;
      hr: HResult); safecall;
    procedure HeuristicDecision(dwDecision: UINT; pboidReason: PBOID;
      hr: HResult); safecall;
    function Indoubt: HResult; stdcall;
  end;

// *********************************************************************//
// Interface: IAccessor
// GUID:      {0C733A8C-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IAccessor = interface(IUnknown)
    ['{0C733A8C-2A1C-11CE-ADE5-00AA0044773D}']
    function AddRefAccessor(HACCESSOR: HACCESSOR; pcRefCount: PUINT): HResult; stdcall;
    function CreateAccessor(dwAccessorFlags: UINT; cBindings: UINT; rgBindings: PDBBindingArray;
      cbRowSize: UINT; var phAccessor: HACCESSOR; rgStatus: PUintArray): HResult; stdcall;
    function GetBindings(HACCESSOR: HACCESSOR; pdwAccessorFlags: PUINT; var pcBindings: UINT;
      out prgBindings: PDBBinding): HResult; stdcall;
    function ReleaseAccessor(HACCESSOR: HACCESSOR; pcRefCount: PUINT): HResult; stdcall;
  end;

  { Safecall Version }
  IAccessorSC = interface(IUnknown)
    ['{0C733A8C-2A1C-11CE-ADE5-00AA0044773D}']
    procedure AddRefAccessor(HACCESSOR: HACCESSOR; pcRefCount: PUINT); safecall;
    procedure CreateAccessor(dwAccessorFlags: UINT; cBindings: UINT; rgBindings: PDBBindingArray;
      cbRowSize: UINT; var phAccessor: HACCESSOR; rgStatus: PUintArray); safecall;
    procedure GetBindings(HACCESSOR: HACCESSOR; pdwAccessorFlags: PUINT; var pcBindings: UINT;
      out prgBindings: PDBBinding); safecall;
    procedure ReleaseAccessor(HACCESSOR: HACCESSOR; pcRefCount: PUINT); safecall;
  end;

// *********************************************************************//
// Interface: IRowset
// GUID:      {0C733A7C-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowset = interface(IUnknown)
    ['{0C733A7C-2A1C-11CE-ADE5-00AA0044773D}']
    function AddRefRows(cRows: UINT; rghRows: PUintArray; rgRefCounts: PUintArray;
      rgRowStatus: PUintArray): HResult; stdcall;
    function GetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: Pointer): HResult; stdcall;
    function GetNextRows(hReserved: HCHAPTER; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; var prghRows: PUintArray): HResult; stdcall;
    function ReleaseRows(cRows: UINT; rghRows: PUintArray; rgRowOptions,
      rgRefCounts, rgRowStatus: PUintArray): HResult; stdcall;
    function RestartPosition(hReserved: HCHAPTER): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetSC = interface(IUnknown)
    ['{0C733A7C-2A1C-11CE-ADE5-00AA0044773D}']
    procedure AddRefRows(cRows: UINT; rghRows: PUintArray; rgRefCounts: PUintArray;
      rgRowStatus: PUintArray); safecall;
    procedure GetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: Pointer); safecall;
    procedure GetNextRows(hReserved: HCHAPTER; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; var prghRows: PUintArray); safecall;
    procedure ReleaseRows(cRows: UINT; rghRows: PUintArray; rgRowOptions,
      rgRefCounts, rgRowStatus: PUintArray); safecall;
    procedure RestartPosition(hReserved: HCHAPTER); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetInfo
// GUID:      {0C733A55-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetInfo = interface(IUnknown)
    ['{0C733A55-2A1C-11CE-ADE5-00AA0044773D}']
    function GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      out pcPropertySets: UINT; out prgPropertySets: PDBPropSet): HResult; stdcall;
    function GetReferencedRowset(iOrdinal: UINT; const riid: TGUID;
      out ppReferencedRowset: IUnknown): HResult; stdcall;
    function GetSpecification(const riid: TGUID; out ppSpecification: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetInfoSC = interface(IUnknown)
    ['{0C733A55-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      out pcPropertySets: UINT; out prgPropertySets: PDBPropSet); safecall;
    procedure GetReferencedRowset(iOrdinal: UINT; const riid: TGUID;
      out ppReferencedRowset: IUnknown); safecall;
    procedure GetSpecification(const riid: TGUID; out ppSpecification: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetLocate
// GUID:      {0C733A7D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetLocate = interface(IRowset)
    ['{0C733A7D-2A1C-11CE-ADE5-00AA0044773D}']
    function Compare(hReserved: HCHAPTER; cbBookmark1: UINT; pBookmark1: PByte;
      cbBookmark2: UINT; pBookmark2: PByte; out pComparison: UINT): HResult; stdcall;
    function GetRowsAt(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; cbBookmark: UINT;
      pBookmark: PByte; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; out prghRows: PHROW): HResult; stdcall;
    function GetRowsByBookmark(hReserved: HCHAPTER; cRows: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rghRows, rgRowStatus: PUintArray): HResult; stdcall;
    function Hash(hReserved: HCHAPTER; cBookmarks: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rgHashedValues,
        rgBookmarkStatus: PUintArray): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetLocateSC = interface(IRowset)
    ['{0C733A7D-2A1C-11CE-ADE5-00AA0044773D}']
    procedure Compare(hReserved: HCHAPTER; cbBookmark1: UINT; pBookmark1: PByte;
      cbBookmark2: UINT; pBookmark2: PByte; out pComparison: UINT); safecall;
    procedure GetRowsAt(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; cbBookmark: UINT;
      pBookmark: PByte; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; out prghRows: PHROW); safecall;
    procedure GetRowsByBookmark(hReserved: HCHAPTER; cRows: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rghRows, rgRowStatus: PUintArray); safecall;
    procedure Hash(hReserved: HCHAPTER; cBookmarks: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rgHashedValues,
        rgBookmarkStatus: PUintArray); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetResynch
// GUID:      {0C733A84-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetResynch = interface(IUnknown)
    ['{0C733A84-2A1C-11CE-ADE5-00AA0044773D}']
    function GetVisibleData(HROW: HROW; HACCESSOR: HACCESSOR;
      out pData: Pointer): HResult; stdcall;
    function ResynchRows(cRows: UINT; rghRows: PUintArray; pcRowsResynched: PUINT;
      out prghRowsResynched: PHROW; prgRowStatus: PPDBROWSTATUS): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetResynchSC = interface(IUnknown)
    ['{0C733A84-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetVisibleData(HROW: HROW; HACCESSOR: HACCESSOR;
      out pData: Pointer); safecall;
    procedure ResynchRows(cRows: UINT; rghRows: PUintArray; pcRowsResynched: PUINT;
      out prghRowsResynched: PHROW; prgRowStatus: PPDBROWSTATUS); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetScroll
// GUID:      {0C733A7E-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetScroll = interface(IRowsetLocate)
    ['{0C733A7E-2A1C-11CE-ADE5-00AA0044773D}']
    function GetApproximatePosition(hReserved: HCHAPTER; cbBookmark: UINT; pBookmark: PByte;
      pulPosition: PUINT; pcRows: PUINT): HResult; stdcall;
    function GetRowsAtRatio(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; ulNumerator: UINT;
      ulDenominator: UINT; cRows: Integer; out pcRowsObtained: UINT;
      var prghRows: PHROW): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetScrollSC = interface(IRowsetLocate)
    ['{0C733A7E-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetApproximatePosition(hReserved: HCHAPTER; cbBookmark: UINT; pBookmark: PByte;
      pulPosition: PUINT; pcRows: PUINT); safecall;
    procedure GetRowsAtRatio(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; ulNumerator: UINT;
      ulDenominator: UINT; cRows: Integer; out pcRowsObtained: UINT;
      var prghRows: PHROW); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetChange
// GUID:      {0C733A05-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetChange = interface(IUnknown)
    ['{0C733A05-2A1C-11CE-ADE5-00AA0044773D}']
    function DeleteRows(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgRowStatus: PUintArray): HResult; stdcall;
    function SetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: Pointer): HResult; stdcall;
    function InsertRow(hReserved: HCHAPTER; HACCESSOR: HACCESSOR; pData: Pointer;
      phRow: PHROW): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetChangeSC = interface(IUnknown)
    ['{0C733A05-2A1C-11CE-ADE5-00AA0044773D}']
    procedure DeleteRows(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgRowStatus: PUintArray); safecall;
    procedure SetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: Pointer); safecall;
    procedure InsertRow(hReserved: HCHAPTER; HACCESSOR: HACCESSOR; pData: Pointer;
      phRow: PHROW); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetUpdate
// GUID:      {0C733A6D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetUpdate = interface(IRowsetChange)
    ['{0C733A6D-2A1C-11CE-ADE5-00AA0044773D}']
    function GetOriginalData(HROW: HROW; HACCESSOR: HACCESSOR; pData: Pointer): HResult; stdcall;
    function GetPendingRows(hReserved: HCHAPTER; dwRowStatus: DBPENDINGSTATUS; pcPendingRows: PUINT;
      prgPendingRows: PPHROW; prgPendingStatus: PPDBPENDINGSTATUS): HResult; stdcall;
    function GetRowStatus(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgPendingStatus: PUintArray): HResult; stdcall;
    function Undo(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray; pcRowsUndone: PUINT;
      prgRowsUndone: PPHROW; prgRowStatus: PPDBROWSTATUS): HResult; stdcall;
    function Update(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray; pcRows: PUINT;
      prgRows: PPHROW; prgRowStatus: PPDBROWSTATUS): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetUpdateSC = interface(IRowsetChange)
    ['{0C733A6D-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetOriginalData(HROW: HROW; HACCESSOR: HACCESSOR; pData: Pointer); safecall;
    procedure GetPendingRows(hReserved: HCHAPTER; dwRowStatus: DBPENDINGSTATUS; pcPendingRows: PUINT;
      prgPendingRows: PPHROW; prgPendingStatus: PPDBPENDINGSTATUS); safecall;
    procedure GetRowStatus(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgPendingStatus: PUintArray); safecall;
    procedure Undo(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray; pcRowsUndone: PUINT;
      prgRowsUndone: PPHROW; prgRowStatus: PPDBROWSTATUS); safecall;
    procedure Update(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray; pcRows: PUINT;
      prgRows: PPHROW; prgRowStatus: PPDBROWSTATUS); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetIndex
// GUID:      {0C733A82-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetIndex = interface(IUnknown)
    ['{0C733A82-2A1C-11CE-ADE5-00AA0044773D}']
    function GetIndexInfo(var pcKeyColumns: UINT; out prgIndexColumnDesc: PDBINDEXCOLUMNDESC;
      var pcIndexProperties: UINT; out prgIndexProperties: PDBPropSet): HResult; stdcall;
    function Seek(HACCESSOR: HACCESSOR; cKeyValues: UINT; pData: Pointer;
      dwSeekOptions: UINT): HResult; stdcall;
    function SetRange(HACCESSOR: HACCESSOR; cStartKeyColumns: UINT; pStartData: Pointer;
      cEndKeyColumns: UINT; pEndData: Pointer; dwRangeOptions: UINT): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetIndexSC = interface(IUnknown)
    ['{0C733A82-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetIndexInfo(var pcKeyColumns: UINT; out prgIndexColumnDesc: PDBINDEXCOLUMNDESC;
      var pcIndexProperties: UINT; out prgIndexProperties: PDBPropSet); safecall;
    procedure Seek(HACCESSOR: HACCESSOR; cKeyValues: UINT; pData: Pointer;
      dwSeekOptions: UINT); safecall;
    procedure SetRange(HACCESSOR: HACCESSOR; cStartKeyColumns: UINT; pStartData: Pointer;
      cEndKeyColumns: UINT; pEndData: Pointer; dwRangeOptions: UINT); safecall;
  end;

// *********************************************************************//
// Interface: IMultipleResults
// GUID:      {0C733A90-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IMultipleResults = interface(IUnknown)
    ['{0C733A90-2A1C-11CE-ADE5-00AA0044773D}']
    function GetResult(const punkOuter: IUnknown; reserved: Integer; const riid: TGUID;
      pcRowsAffected: PInteger; ppRowset: PIUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IMultipleResultsSC = interface(IUnknown)
    ['{0C733A90-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetResult(const punkOuter: IUnknown; reserved: Integer; const riid: TGUID;
      pcRowsAffected: PInteger; ppRowset: PIUnknown); safecall;
  end;

// *********************************************************************//
// Interface: IConvertType
// GUID:      {0C733A88-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IConvertType = interface(IUnknown)
    ['{0C733A88-2A1C-11CE-ADE5-00AA0044773D}']
    function CanConvert(wFromType: DBTYPE; wToType: DBTYPE;
      dwConvertFlags: UINT): HResult; stdcall;
  end;

  { Safecall Version }
  IConvertTypeSC = interface(IUnknown)
    ['{0C733A88-2A1C-11CE-ADE5-00AA0044773D}']
    procedure CanConvert(wFromType: DBTYPE; wToType: DBTYPE;
      dwConvertFlags: UINT); safecall;
  end;

// *********************************************************************//
// Interface: ICommandPrepare
// GUID:      {0C733A26-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ICommandPrepare = interface(IUnknown)
    ['{0C733A26-2A1C-11CE-ADE5-00AA0044773D}']
    function Prepare(cExpectedRuns: UINT): HResult; stdcall;
    function Unprepare: HResult; stdcall;
  end;

  { Safecall Version }
  ICommandPrepareSC = interface(IUnknown)
    ['{0C733A26-2A1C-11CE-ADE5-00AA0044773D}']
    procedure Prepare(cExpectedRuns: UINT); safecall;
    procedure Unprepare; safecall;
  end;

// *********************************************************************//
// Interface: ICommandProperties
// GUID:      {0C733A79-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//

  ICommandProperties = interface(IUnknown)
    ['{0C733A79-2A1C-11CE-ADE5-00AA0044773D}']
    function GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet): HResult; stdcall;
    function SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray): HResult; stdcall;
  end;

  { Safecall Version }
  ICommandPropertiesSC = interface(IUnknown)
    ['{0C733A79-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet); safecall;
    procedure SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray); safecall;
  end;

// *********************************************************************//
// Interface: ICommand
// GUID:      {0C733A63-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ICommand = interface(IUnknown)
    ['{0C733A63-2A1C-11CE-ADE5-00AA0044773D}']
    function Cancel: HResult; stdcall;
    function Execute(const punkOuter: IUnknown; const riid: TGUID; var pParams: DBPARAMS;
      pcRowsAffected: PInteger; ppRowset: PIUnknown): HResult; stdcall;
    function GetDBSession(const riid: TGUID; out ppSession: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  ICommandSC = interface(IUnknown)
    ['{0C733A63-2A1C-11CE-ADE5-00AA0044773D}']
    procedure Cancel; safecall;
    procedure Execute(const punkOuter: IUnknown; const riid: TGUID; var pParams: DBPARAMS;
      pcRowsAffected: PInteger; ppRowset: PIUnknown); safecall;
    procedure GetDBSession(const riid: TGUID; out ppSession: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: ICommandWithParameters
// GUID:      {0C733A64-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ICommandWithParameters = interface(IUnknown)
    ['{0C733A64-2A1C-11CE-ADE5-00AA0044773D}']
    function GetParameterInfo(var pcParams: UINT; out prgParamInfo: PDBPARAMINFO;
      ppNamesBuffer: PPOleStr): HResult; stdcall;
    function MapParameterNames(cParamNames: UINT; rgParamNames: POleStrList;
      rgParamOrdinals: PUintArray): HResult; stdcall;
    function SetParameterInfo(cParams: UINT; rgParamOrdinals: PUintArray;
      rgParamBindInfo: PDBParamBindInfoArray): HResult; stdcall;
  end;

  { Safecall Version }
  ICommandWithParametersSC = interface(IUnknown)
    ['{0C733A64-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetParameterInfo(var pcParams: UINT; out prgParamInfo: PDBPARAMINFO;
      ppNamesBuffer: PPOleStr); safecall;
    procedure MapParameterNames(cParamNames: UINT; rgParamNames: POleStrList;
      rgParamOrdinals: PUintArray); safecall;
    procedure SetParameterInfo(cParams: UINT; rgParamOrdinals: PUintArray;
      rgParamBindInfo: PDBParamBindInfoArray); safecall;
  end;

// *********************************************************************//
// Interface: ICommandText
// GUID:      {0C733A27-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ICommandText = interface(ICommand)
    ['{0C733A27-2A1C-11CE-ADE5-00AA0044773D}']
    function GetCommandText(var pguidDialect: TGUID;
      out ppwszCommand: PWideChar): HResult; stdcall;
    function SetCommandText(const guidDialect: TGUID;
      pwszCommand: PWideChar): HResult; stdcall;
  end;

  { Safecall Version }
  ICommandTextSC = interface(ICommand)
    ['{0C733A27-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetCommandText(var pguidDialect: TGUID;
      out ppwszCommand: PWideChar); safecall;
    procedure SetCommandText(const guidDialect: TGUID;
      pwszCommand: PWideChar); safecall;
  end;

// *********************************************************************//
// Interface: IColumnsRowset
// GUID:      {0C733A10-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IColumnsRowset = interface(IUnknown)
    ['{0C733A10-2A1C-11CE-ADE5-00AA0044773D}']
    function GetAvailableColumns(var pcOptColumns: UINT;
      var prgOptColumns: PDBID): HResult; stdcall;
    function GetColumnsRowset(const punkOuter: IUnknown; cOptColumns: UINT;
      rgOptColumns: PDBIDArray; const riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; out pColRowset: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IColumnsRowsetSC = interface(IUnknown)
    ['{0C733A10-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetAvailableColumns(var pcOptColumns: UINT;
      var prgOptColumns: PDBID); safecall;
    procedure GetColumnsRowset(const punkOuter: IUnknown; cOptColumns: UINT;
      rgOptColumns: PDBIDArray; const riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; out pColRowset: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: IColumnsInfo
// GUID:      {0C733A11-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IColumnsInfo = interface(IUnknown)
    ['{0C733A11-2A1C-11CE-ADE5-00AA0044773D}']
    function GetColumnInfo(var pcColumns: UINT; out prgInfo: PDBColumnInfo;
      out ppStringsBuffer: PWideChar): HResult; stdcall;
    function MapColumnIDs(cColumnIDs: UINT; rgColumnIDs: PDBIDArray;
      rgColumns: PUintArray): HResult; stdcall;
  end;

  { Safecall Version }
  IColumnsInfoSC = interface(IUnknown)
    ['{0C733A11-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetColumnInfo(var pcColumns: UINT; out prgInfo: PDBColumnInfo;
      out ppStringsBuffer: PWideChar); safecall;
    procedure MapColumnIDs(cColumnIDs: UINT; rgColumnIDs: PDBIDArray;
      rgColumns: PUINTArray); safecall;
  end;

// *********************************************************************//
// Interface: IDBCreateCommand
// GUID:      {0C733A1D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IDBCreateCommand = interface(IUnknown)
    ['{0C733A1D-2A1C-11CE-ADE5-00AA0044773D}']
    function CreateCommand(const punkOuter: IUnknown; const riid: TGUID;
      out ppCommand: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IDBCreateCommandSC = interface(IUnknown)
    ['{0C733A1D-2A1C-11CE-ADE5-00AA0044773D}']
    procedure CreateCommand(const punkOuter: IUnknown; const riid: TGUID;
      out ppCommand: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: IDBCreateSession
// GUID:      {0C733A5D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IDBCreateSession = interface(IUnknown)
    ['{0C733A5D-2A1C-11CE-ADE5-00AA0044773D}']
    function CreateSession(const punkOuter: IUnknown; const riid: TGUID;
      out ppDBSession: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IDBCreateSessionSC = interface(IUnknown)
    ['{0C733A5D-2A1C-11CE-ADE5-00AA0044773D}']
    procedure CreateSession(const punkOuter: IUnknown; const riid: TGUID;
      out ppDBSession: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: ISourcesRowset
// GUID:      {0C733A1E-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ISourcesRowset = interface(IUnknown)
    ['{0C733A1E-2A1C-11CE-ADE5-00AA0044773D}']
    function GetSourcesRowset(const punkOuter: IUnknown; const riid: TGUID; cPropertySets: UINT;
      rgProperties: PDBPropSetArray; out ppSourcesRowset: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  ISourcesRowsetSC = interface(IUnknown)
    ['{0C733A1E-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetSourcesRowset(const punkOuter: IUnknown; const riid: TGUID; cPropertySets: UINT;
      rgProperties: PDBPropSetArray; out ppSourcesRowset: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: IDBProperties
// GUID:      {0C733A8A-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IDBProperties = interface(IUnknown)
    ['{0C733A8A-2A1C-11CE-ADE5-00AA0044773D}']
    function GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet): HResult; stdcall;
    function GetPropertyInfo(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertyInfoSets: UINT; out prgPropertyInfoSets: PDBPropInfoSet;
      ppDescBuffer: PPOleStr): HResult; stdcall;
    function SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray): HResult; stdcall;
  end;

  { Safecall Version }
  IDBPropertiesSC = interface(IUnknown)
    ['{0C733A8A-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet); safecall;
    procedure GetPropertyInfo(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertyInfoSets: UINT; out prgPropertyInfoSets: PDBPropInfoSet;
      ppDescBuffer: PPOleStr); safecall;
    procedure SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSet); safecall;
  end;

// *********************************************************************//
// Interface: IDBInitialize
// GUID:      {0C733A8B-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IDBInitialize = interface(IUnknown)
    ['{0C733A8B-2A1C-11CE-ADE5-00AA0044773D}']
    function Initialize: HResult; stdcall;
    function Uninitialize: HResult; stdcall;
  end;

  { SafeCall version }
  IDBInitializeSC = interface(IUnknown)
    ['{0C733A8B-2A1C-11CE-ADE5-00AA0044773D}']
    procedure Initialize; safecall;
    procedure Uninitialize; safecall;
  end;

// *********************************************************************//
// Interface: IDBInfo
// GUID:      {0C733A89-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IDBInfo = interface(IUnknown)
    ['{0C733A89-2A1C-11CE-ADE5-00AA0044773D}']
    function GetKeywords(out ppwszKeywords: PWideChar): HResult; stdcall;
    function GetLiteralInfo(cLiterals: UINT; rgLiterals: PUintArray;
      var pcLiteralInfo: UINT; out prgLiteralInfo: PDBLiteralInfo;
      out ppCharBuffer: PWideChar): HResult; stdcall;
  end;

  { SafeCall Version }
  IDBInfoSC = interface(IUnknown)
    ['{0C733A89-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetKeywords(out ppwszKeywords: PWideChar); safecall;
    procedure GetLiteralInfo(cLiterals: UINT; rgLiterals: PUintArray;
      var pcLiteralInfo: UINT;  out prgLiteralInfo: PDBLiteralInfo;
      out ppCharBuffer: PWideChar); safecall;
  end;

// *********************************************************************//
// Interface: IDBDataSourceAdmin
// GUID:      {0C733A7A-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IDBDataSourceAdmin = interface(IUnknown)
    ['{0C733A7A-2A1C-11CE-ADE5-00AA0044773D}']
    function CreateDataSource(cPropertySets: UINT; rgPropertySets: PDBPropSetArray;
      const punkOuter: IUnknown; const riid: TGUID; out ppDBSession: IUnknown): HResult; stdcall;
    function DestroyDataSource: HResult; stdcall;
    function GetCreationProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      pcPropertyInfoSets: PUINT; out prgPropertyInfoSets: PDBPropInfoSet;
      ppDescBuffer: PPOleStr): HResult; stdcall;
    function ModifyDataSource(cPropertySets: UINT; rgPropertySets: PDBPropSetArray): HResult; stdcall;
  end;

  { Safecall Version }
  IDBDataSourceAdminSC = interface(IUnknown)
    ['{0C733A7A-2A1C-11CE-ADE5-00AA0044773D}']
    procedure CreateDataSource(cPropertySets: UINT; rgPropertySets: PDBPropSetArray;
      const punkOuter: IUnknown; const riid: TGUID; out ppDBSession: IUnknown); safecall;
    procedure DestroyDataSource; safecall;
    procedure GetCreationProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      pcPropertyInfoSets: PUINT; out prgPropertyInfoSets: PDBPropInfoSet;
      ppDescBuffer: PPOleStr); safecall;
    procedure ModifyDataSource(cPropertySets: UINT; rgPropertySets: PDBPropSetArray); safecall;
  end;

// *********************************************************************//
// Interface: ISessionProperties
// GUID:      {0C733A85-2A1C-11CE-ADE5-00AA0044773d}
// *********************************************************************//
  ISessionProperties = interface(IUnknown)
    ['{0C733A85-2A1C-11CE-ADE5-00AA0044773d}']
    function GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet): HResult; stdcall;
    function SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray): HResult; stdcall;
  end;

  { Safecall Version }
  ISessionPropertiesSC = interface(IUnknown)
    ['{0C733A85-2A1C-11CE-ADE5-00AA0044773d}']
    procedure GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet); safecall;
    procedure SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray); safecall;
  end;

// *********************************************************************//
// Interface: IIndexDefinition
// GUID:      {0C733A68-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IIndexDefinition = interface(IUnknown)
    ['{0C733A68-2A1C-11CE-ADE5-00AA0044773D}']
    function CreateIndex(var pTableID: DBID; pIndexID: PDBID; cIndexColumnDescs: UINT;
      rgIndexColumnDescs: PDBIndexColumnDescArray; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; ppIndexID: PPDBID): HResult; stdcall;
    function DropIndex(var TableID: DBID; pIndexID: PDBID): HResult; stdcall;
  end;

  { Safecall Version }
  IIndexDefinitionSC = interface(IUnknown)
    ['{0C733A68-2A1C-11CE-ADE5-00AA0044773D}']
    procedure CreateIndex(var pTableID: DBID; pIndexID: PDBID; cIndexColumnDescs: UINT;
      rgIndexColumnDescs: PDBIndexColumnDescArray; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; ppIndexID: PPDBID); safecall;
    procedure DropIndex(var TableID: DBID; pIndexID: PDBID); safecall;
  end;

// *********************************************************************//
// Interface: ITableDefinition
// GUID:      {0C733A86-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ITableDefinition = interface(IUnknown)
    ['{0C733A86-2A1C-11CE-ADE5-00AA0044773D}']
    function CreateTable(const punkOuter: IUnknown; pTableID: PDBID; cColumnDescs: UINT;
      rgColumnDescs: PDBColumnDescArray; const riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; ppTableID: PPDBID; ppRowset: PIUnknown): HResult; stdcall;
    function DropTable(var pTableID: DBID): HResult; stdcall;
    function AddColumn(var pTableID: DBID; var pColumnDesc: DBCOLUMNDESC;
      ppColumnID: PPDBID): HResult; stdcall;
    function DropColumn(var pTableID: DBID; var pColumnID: DBID): HResult; stdcall;
  end;

  { Safecall Version }
  ITableDefinitionSC = interface(IUnknown)
    ['{0C733A86-2A1C-11CE-ADE5-00AA0044773D}']
    procedure CreateTable(const punkOuter: IUnknown; pTableID: PDBID; cColumnDescs: UINT;
      rgColumnDescs: PDBColumnDescArray; const riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; ppTableID: PPDBID; ppRowset: PIUnknown); safecall;
    procedure DropTable(var pTableID: DBID); safecall;
    procedure AddColumn(var pTableID: DBID; var pColumnDesc: DBCOLUMNDESC;
      ppColumnID: PPDBID); safecall;
    procedure DropColumn(var pTableID: DBID; var pColumnID: DBID); safecall;
  end;

// *********************************************************************//
// Interface: IOpenRowset
// GUID:      {0C733A69-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IOpenRowset = interface(IUnknown)
    ['{0C733A69-2A1C-11CE-ADE5-00AA0044773D}']
    function OpenRowset(const punkOuter: IUnknown; pTableID: PDBID; pIndexID: PDBID;
      const riid: TGUID; cPropertySets: UINT; rgPropertySets: PDBPropSetArray;
      ppRowset: PIUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IOpenRowsetSC = interface(IUnknown)
    ['{0C733A69-2A1C-11CE-ADE5-00AA0044773D}']
    procedure OpenRowset(const punkOuter: IUnknown; pTableID: PDBID; pIndexID: PDBID;
      const riid: TGUID; cPropertySets: UINT; rgPropertySets: PDBPropSetArray;
      ppRowset: PIUnknown); safecall;
  end;

// *********************************************************************//
// Interface: IErrorLookup
// GUID:      {0C733A66-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IErrorLookup = interface(IUnknown)
    ['{0C733A66-2A1C-11CE-ADE5-00AA0044773D}']
    function GetErrorDescription(hrError: HResult; dwLookupID: UINT;
      pdispparams: PDISPPARAMS; lcid: UINT; out pbstrSource: WideString;
      out pbstrDescription: WideString): HResult; stdcall;
    function GetHelpInfo(hrError: HResult; dwLookupID: UINT; lcid: UINT;
      out pbstrHelpFile: WideString; out pdwHelpContext: UINT): HResult; stdcall;
    function ReleaseErrors(dwDynamicErrorID: UINT): HResult; stdcall;
  end;

  { Safecall Version }
  IErrorLookupSC = interface(IUnknown)
    ['{0C733A66-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetErrorDescription(hrError: HResult; dwLookupID: UINT;
      pdispparams: PDISPPARAMS; lcid: UINT; out pbstrSource: WideString;
      out pbstrDescription: WideString); safecall;
    procedure GetHelpInfo(hrError: HResult; dwLookupID: UINT; lcid: UINT;
      out pbstrHelpFile: WideString; out pdwHelpContext: UINT); safecall;
    procedure ReleaseErrors(dwDynamicErrorID: UINT); safecall;
  end;

// *********************************************************************//
// Interface: ISQLErrorInfo
// GUID:      {0C733A74-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ISQLErrorInfo = interface(IUnknown)
    ['{0C733A74-2A1C-11CE-ADE5-00AA0044773D}']
    function GetSQLInfo(out pbstrSQLState: WideString;
      out plNativeError: Integer): HResult; stdcall;
  end;

  { Safecall Version }
  ISQLErrorInfoSC = interface(IUnknown)
    ['{0C733A74-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetSQLInfo(out pbstrSQLState: WideString;
      out plNativeError: Integer); safecall;
  end;

// *********************************************************************//
// Interface: IGetDataSource
// GUID:      {0C733A75-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IGetDataSource = interface(IUnknown)
    ['{0C733A75-2A1C-11CE-ADE5-00AA0044773D}']
    function GetDataSource(const riid: TGUID; out ppDataSource: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IGetDataSourceSC = interface(IUnknown)
    ['{0C733A75-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetDataSource(const riid: TGUID; out ppDataSource: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: ITransactionLocal
// GUID:      {0C733A5F-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ITransactionLocal = interface(ITransaction)
    ['{0C733A5F-2A1C-11CE-ADE5-00AA0044773D}']
    function GetOptionsObject(out ppOptions: ITransactionOptions): HResult; stdcall;
    function StartTransaction(isoLevel: Integer; isoFlags: UINT;
      const pOtherOptions: ITransactionOptions; pulTransactionLevel: PUINT): HResult; stdcall;
  end;

  { Safecall Version }
  ITransactionLocalSC = interface(ITransaction)
    ['{0C733A5F-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetOptionsObject(out ppOptions: ITransactionOptions); safecall;
    procedure StartTransaction(isoLevel: Integer; isoFlags: UINT;
      const pOtherOptions: ITransactionOptions; pulTransactionLevel: PUINT); safecall;
  end;

// *********************************************************************//
// Interface: ITransactionJoin
// GUID:      {0C733A5E-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ITransactionJoin = interface(IUnknown)
    ['{0C733A5E-2A1C-11CE-ADE5-00AA0044773D}']
    function GetOptionsObject(out ppOptions: ITransactionOptions): HResult; stdcall;
    function JoinTransaction(const punkTransactionCoord: IUnknown; isoLevel: Integer;
      isoFlags: UINT; const pOtherOptions: ITransactionOptions): HResult; stdcall;
  end;

  { Safecall Version }
  ITransactionJoinSC = interface(IUnknown)
    ['{0C733A5E-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetOptionsObject(out ppOptions: ITransactionOptions); safecall;
    procedure JoinTransaction(const punkTransactionCoord: IUnknown; isoLevel: Integer;
      isoFlags: UINT; const pOtherOptions: ITransactionOptions); safecall;
  end;

// *********************************************************************//
// Interface: ITransactionObject
// GUID:      {0C733A60-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ITransactionObject = interface(IUnknown)
    ['{0C733A60-2A1C-11CE-ADE5-00AA0044773D}']
    function GetTransactionObject(ulTransactionLevel: UINT;
      out ppTransactionObject: ITransaction): HResult; stdcall;
  end;

  { Safecall Version }
  ITransactionObjectSC = interface(IUnknown)
    ['{0C733A60-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetTransactionObject(ulTransactionLevel: UINT;
      out ppTransactionObject: ITransaction); safecall;
  end;

// *********************************************************************//
// Interface: IDBAsynchStatus
// GUID:      {0C733A95-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IDBAsynchStatus = interface(IUnknown)
    ['{0C733A95-2A1C-11CE-ADE5-00AA0044773D}']
    function Abort(HCHAPTER: HCHAPTER; eOperation: DBASYNCHOP): HResult; stdcall;
    function GetStatus(HCHAPTER: HCHAPTER; eOperation: DBASYNCHOP; pulProgress: PUINT;
      pulProgressMax: PUINT; peAsynchPhase: PDBASYNCHPHASE;
      ppwszStatusText: PPOleStr): HResult; stdcall;
  end;

  { Safecall Version }
  IDBAsynchStatusSC = interface(IUnknown)
    ['{0C733A95-2A1C-11CE-ADE5-00AA0044773D}']
    procedure Abort(HCHAPTER: HCHAPTER; eOperation: DBASYNCHOP); safecall;
    procedure GetStatus(HCHAPTER: HCHAPTER; eOperation: DBASYNCHOP; pulProgress: PUINT;
      pulProgressMax: PUINT; peAsynchPhase: PDBASYNCHPHASE;
      ppwszStatusText: PPOleStr); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetFind
// GUID:      {0C733A9D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetFind = interface(IUnknown)
    ['{0C733A9D-2A1C-11CE-ADE5-00AA0044773D}']
    function FindNextRow(HCHAPTER: HCHAPTER; HACCESSOR: HACCESSOR; pFindValue: Pointer;
      CompareOp: DBCOMPAREOP; cbBookmark: UINT; pBookmark: PByte;
      lRowsOffset: Integer; cRows: Integer; var pcRowsObtained: UINT;
      out prghRows: PHROW): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetFindSC = interface(IUnknown)
    ['{0C733A9D-2A1C-11CE-ADE5-00AA0044773D}']
    procedure FindNextRow(HCHAPTER: HCHAPTER; HACCESSOR: HACCESSOR; pFindValue: Pointer;
      CompareOp: DBCOMPAREOP; cbBookmark: UINT; pBookmark: PByte;
      lRowsOffset: Integer; cRows: Integer; var pcRowsObtained: UINT;
      out prghRows: PHROW); safecall;
  end;

// *********************************************************************//
// Interface: IRowPosition
// GUID:      {0C733A94-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowPosition = interface(IUnknown)
    ['{0C733A94-2A1C-11CE-ADE5-00AA0044773D}']
    function ClearRowPosition: HResult; stdcall;
    function GetRowPosition(out phChapter: HCHAPTER; out phRow: HROW;
      out pdwPositionFlags: UINT): HResult; stdcall;
    function GetRowset(const riid: TGUID; out ppRowset: IUnknown): HResult; stdcall;
    function Initialize(const pRowset: IUnknown): HResult; stdcall;
    function SetRowPosition(HCHAPTER: HCHAPTER; HROW: HROW; dwPositionFlags: UINT): HResult; stdcall;
  end;

  { Safecall Version }
  IRowPositionSC = interface(IUnknown)
    ['{0C733A94-2A1C-11CE-ADE5-00AA0044773D}']
    procedure ClearRowPosition; safecall;
    procedure GetRowPosition(out phChapter: HCHAPTER; out phRow: HROW;
      out pdwPositionFlags: UINT); safecall;
    procedure GetRowset(const riid: TGUID; out ppRowset: IUnknown); safecall;
    procedure Initialize(const pRowset: IUnknown); safecall;
    procedure SetRowPosition(HCHAPTER: HCHAPTER; HROW: HROW; dwPositionFlags: UINT); safecall;
  end;

// *********************************************************************//
// Interface: IRowPositionChange
// GUID:      {0997A571-126E-11D0-9F8A-00A0C9A0631E}
// *********************************************************************//
  IRowPositionChange = interface(IUnknown)
    ['{0997A571-126E-11D0-9F8A-00A0C9A0631E}']
    function OnRowPositionChange(eReason: DBREASON; ePhase: DBEVENTPHASE;
      fCantDeny: BOOL): HResult; stdcall;
  end;

  { Safecall Version }
  IRowPositionChangeSC = interface(IUnknown)
    ['{0997A571-126E-11D0-9F8A-00A0C9A0631E}']
    procedure OnRowPositionChange(eReason: DBREASON; ePhase: DBEVENTPHASE;
      fCantDeny: BOOL); safecall;
  end;

// *********************************************************************//
// Interface: IViewRowset
// GUID:      {0C733A97-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IViewRowset = interface(IUnknown)
    ['{0C733A97-2A1C-11CE-ADE5-00AA0044773D}']
    function GetSpecification(const riid: TGUID; out ppObject: IUnknown): HResult; stdcall;
    function OpenViewRowset(const punkOuter: IUnknown; const riid: TGUID;
      out ppRowset: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IViewRowsetSC = interface(IUnknown)
    ['{0C733A97-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetSpecification(const riid: TGUID; out ppObject: IUnknown); safecall;
    procedure OpenViewRowset(const punkOuter: IUnknown; const riid: TGUID;
      out ppRowset: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: IViewChapter
// GUID:      {0C733A98-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IViewChapter = interface(IUnknown)
    ['{0C733A98-2A1C-11CE-ADE5-00AA0044773D}']
    function GetSpecification(const riid: TGUID; out ppRowset: IUnknown): HResult; stdcall;
    function OpenViewChapter(hSource: HCHAPTER; out phViewChapter: HCHAPTER): HResult; stdcall;
  end;

  { Safecall Version }
  IViewChapterSC = interface(IUnknown)
    ['{0C733A98-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetSpecification(const riid: TGUID; out ppRowset: IUnknown); safecall;
    procedure OpenViewChapter(hSource: HCHAPTER; out phViewChapter: HCHAPTER); safecall;
  end;

// *********************************************************************//
// Interface: IViewSort
// GUID:      {0C733A9A-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IViewSort = interface(IUnknown)
    ['{0C733A9A-2A1C-11CE-ADE5-00AA0044773D}']
    function GetSortOrder(out pcValues: UINT; out prgColumns: PUintArray;
      out prgOrders: PUintArray): HResult; stdcall;
    function SetSortOrder(cValues: UINT; rgColumns: PUintArray;
      rgOrders: PUintArray): HResult; stdcall;
  end;

  { Safecall Version }
  IViewSortSC = interface(IUnknown)
    ['{0C733A9A-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetSortOrder(out pcValues: UINT; out prgColumns: PUintArray;
      out prgOrders: PUintArray); safecall;
    procedure SetSortOrder(cValues: UINT; rgColumns: PUintArray;
      rgOrders: PUintArray); safecall;
  end;

// *********************************************************************//
// Interface: IViewFilter
// GUID:      {0C733A9B-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IViewFilter = interface(IUnknown)
    ['{0C733A9B-2A1C-11CE-ADE5-00AA0044773D}']
    function GetFilter(HACCESSOR: HACCESSOR; out pcRows: UINT; out pCompareOps: PDBCOMPAREOP;
      pCriteriaData: Pointer): HResult; stdcall;
    function GetFilterBindings(out pcBindings: UINT; out prgBindings: PDBBinding): HResult; stdcall;
    function SetFilter(HACCESSOR: HACCESSOR; cRows: UINT; var CompareOps: DBCOMPAREOP;
      pCriteriaData: Pointer): HResult; stdcall;
  end;

  { Safecall Version }
  IViewFilterSC = interface(IUnknown)
    ['{0C733A9B-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetFilter(HACCESSOR: HACCESSOR; out pcRows: UINT; out pCompareOps: PDBCOMPAREOP;
      pCriteriaData: Pointer); safecall;
    procedure GetFilterBindings(out pcBindings: UINT; out prgBindings: PDBBinding); safecall;
    procedure SetFilter(HACCESSOR: HACCESSOR; cRows: UINT; var CompareOps: DBCOMPAREOP;
      pCriteriaData: Pointer); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetView
// GUID:      {0C733A99-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetView = interface(IUnknown)
    ['{0C733A99-2A1C-11CE-ADE5-00AA0044773D}']
    function CreateView(const punkOuter: IUnknown; const riid: TGUID;
      out ppView: IUnknown): HResult; stdcall;
    function GetView(HCHAPTER: HCHAPTER; const riid: TGUID; out phChapterSource: HCHAPTER;
      out ppView: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetViewSC = interface(IUnknown)
    ['{0C733A99-2A1C-11CE-ADE5-00AA0044773D}']
    procedure CreateView(const punkOuter: IUnknown; const riid: TGUID;
      out ppView: IUnknown); safecall;
    procedure GetView(HCHAPTER: HCHAPTER; const riid: TGUID; out phChapterSource: HCHAPTER;
      out ppView: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: IMDFind
// GUID:      {A07CCCD2-8148-11D0-87BB-00C04FC33942}
// *********************************************************************//
  IMDFind = interface(IUnknown)
    ['{A07CCCD2-8148-11D0-87BB-00C04FC33942}']
    function FindCell(ulStartingOrdinal: UINT; cMembers: UINT; rgpwszMember: PPOleStr;
      out pulCellOrdinal: UINT): HResult; stdcall;
    function FindTuple(ulAxisIdentifier: UINT; ulStartingOrdinal: UINT; cMembers: UINT;
      rgpwszMember: PPOleStr; out pulTupleOrdinal: UINT): HResult; stdcall;
  end;

  { Safecall Version }
  IMDFindSC = interface(IUnknown)
    ['{A07CCCD2-8148-11D0-87BB-00C04FC33942}']
    procedure FindCell(ulStartingOrdinal: UINT; cMembers: UINT; rgpwszMember: PPOleStr;
      out pulCellOrdinal: UINT); safecall;
    procedure FindTuple(ulAxisIdentifier: UINT; ulStartingOrdinal: UINT; cMembers: UINT;
      rgpwszMember: PPOleStr; out pulTupleOrdinal: UINT); safecall;
  end;

// *********************************************************************//
// Interface: IMDRangeRowset
// GUID:      {0C733AA0-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IMDRangeRowset = interface(IUnknown)
    ['{0C733AA0-2A1C-11CE-ADE5-00AA0044773D}']
    function GetRangeRowset(const punkOuter: IUnknown; ulStartCell: UINT; ulEndCell: UINT;
      const riid: TGUID; cPropertySets: UINT; rgPropertySets: PDBPropSetArray;
      out ppRowset: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IMDRangeRowsetSC = interface(IUnknown)
    ['{0C733AA0-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetRangeRowset(const punkOuter: IUnknown; ulStartCell: UINT; ulEndCell: UINT;
      const riid: TGUID; cPropertySets: UINT; rgPropertySets: PDBPropSetArray;
      out ppRowset: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: IAlterTable
// GUID:      {0C733AA5-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IAlterTable = interface(IUnknown)
    ['{0C733AA5-2A1C-11CE-ADE5-00AA0044773D}']
    function AlterColumn(var pTableID: DBID; var pColumnID: DBID;
      ColumnDescFlags: DBCOLUMNDESCFLAGS; var pColumnDesc: DBCOLUMNDESC): HResult; stdcall;
    function AlterTable(var pTableID: DBID; pNewTableId: PDBID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray): HResult; stdcall;
  end;

  { Safecall Version }
  IAlterTableSC = interface(IUnknown)
    ['{0C733AA5-2A1C-11CE-ADE5-00AA0044773D}']
    procedure AlterColumn(var pTableID: DBID; var pColumnID: DBID;
      ColumnDescFlags: DBCOLUMNDESCFLAGS; var pColumnDesc: DBCOLUMNDESC); safecall;
    procedure AlterTable(var pTableID: DBID; pNewTableId: PDBID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray); safecall;
  end;

// *********************************************************************//
// Interface: IAlterIndex
// GUID:      {0C733AA6-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IAlterIndex = interface(IUnknown)
    ['{0C733AA6-2A1C-11CE-ADE5-00AA0044773D}']
    function AlterIndex(var pTableID: DBID; var pIndexID: DBID; pNewIndexId: PDBID;
      cPropertySets: UINT; rgPropertySet: PDBPropSetArray): HResult; stdcall;
  end;

  { Safecall Version }
  IAlterIndexSC = interface(IUnknown)
    ['{0C733AA6-2A1C-11CE-ADE5-00AA0044773D}']
    procedure AlterIndex(var pTableID: DBID; var pIndexID: DBID; pNewIndexId: PDBID;
      cPropertySets: UINT; rgPropertySet: PDBPropSetArray); safecall;
  end;

// *********************************************************************//
// Interface: ICommandPersist
// GUID:      {0C733AA7-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ICommandPersist = interface(IUnknown)
    ['{0C733AA7-2A1C-11CE-ADE5-00AA0044773D}']
    function DeleteCommand(var pCommandID: DBID): HResult; stdcall;
    function GetCurrentCommand(out ppCommandID: PDBID): HResult; stdcall;
    function LoadCommand(var pCommandID: DBID; dwFlags: UINT): HResult; stdcall;
    function SaveCommand(var pCommandID: DBID; dwFlags: UINT): HResult; stdcall;
  end;

  { Safecall Version }
  ICommandPersistSC = interface(IUnknown)
    ['{0C733AA7-2A1C-11CE-ADE5-00AA0044773D}']
    procedure DeleteCommand(var pCommandID: DBID); safecall;
    procedure GetCurrentCommand(out ppCommandID: PDBID); safecall;
    procedure LoadCommand(var pCommandID: DBID; dwFlags: UINT); safecall;
    procedure SaveCommand(var pCommandID: DBID; dwFlags: UINT); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetChapterMember
// GUID:      {0C733AA8-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetChapterMember = interface(IUnknown)
    ['{0C733AA8-2A1C-11CE-ADE5-00AA0044773D}']
    function IsRowInChapter(HCHAPTER: HCHAPTER; HROW: HROW): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetChapterMemberSC = interface(IUnknown)
    ['{0C733AA8-2A1C-11CE-ADE5-00AA0044773D}']
    procedure IsRowInChapter(HCHAPTER: HCHAPTER; HROW: HROW); safecall;
  end;

// *********************************************************************//
// Interface: IRowsetRefresh
// GUID:      {0C733AA9-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IRowsetRefresh = interface(IUnknown)
    ['{0C733AA9-2A1C-11CE-ADE5-00AA0044773D}']
    function RefreshVisibleData(HCHAPTER: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      fOverWrite: BOOL; pcRowsRefreshed: PUINT;
      out prghRowsRefreshed: PHROW; prgRowStatus: PPDBROWSTATUS): HResult; stdcall;
    function GetLastVisibleData(HROW: HROW; HACCESSOR: HACCESSOR;
      pData: Pointer): HResult; stdcall;
  end;

  { Safecall Version }
  IRowsetRefreshSC = interface(IUnknown)
    ['{0C733AA9-2A1C-11CE-ADE5-00AA0044773D}']
    procedure RefreshVisibleData(HCHAPTER: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      fOverWrite: BOOL; pcRowsRefreshed: PUINT;
      out prghRowsRefreshed: PHROW; prgRowStatus: PPDBROWSTATUS); safecall;
    procedure GetLastVisibleData(HROW: HROW; HACCESSOR: HACCESSOR;
      pData: Pointer); safecall;
  end;

// *********************************************************************//
// Interface: IParentRowset
// GUID:      {0C733AAA-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IParentRowset = interface(IUnknown)
    ['{0C733AAA-2A1C-11CE-ADE5-00AA0044773D}']
    function GetChildRowset(const punkOuter: IUnknown; iOrdinal: UINT; const riid: TGUID;
      out ppRowset: IUnknown): HResult; stdcall;
  end;

  { Safecall Version }
  IParentRowsetSC = interface(IUnknown)
    ['{0C733AAA-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetChildRowset(const punkOuter: IUnknown; iOrdinal: UINT; const riid: TGUID;
      out ppRowset: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: ITrusteeGroupAdmin
// GUID:      {0C733AA2-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ITrusteeGroupAdmin = interface(IUnknown)
    ['{0C733AA2-2A1C-11CE-ADE5-00AA0044773D}']
    function AddMember(pMembershipTrustee: PTrusteeW;
      pMemberTrustee: PTrusteeW): HResult; stdcall;
    function DeleteMember(pMembershipTrustee: PTrusteeW;
      pMemberTrustee: PTrusteeW): HResult; stdcall;
    function IsMember(pMembershipTrustee: PTrusteeW; pMemberTrustee: PTrusteeW;
      out pfStatus: BOOL): HResult; stdcall;
    function GetMembers(pMembershipTrustee: PTrusteeW; pcMembers: PUINT;
      out prgMembers: PTrusteeW): HResult; stdcall;
    function GetMemberships(pTrustee: PTrusteeW; pcMemberships: PUINT;
      out prgMemberships: PTrusteeW): HResult; stdcall;
  end;

  { Safecall Version }
  ITrusteeGroupAdminSC = interface(IUnknown)
    ['{0C733AA2-2A1C-11CE-ADE5-00AA0044773D}']
    procedure AddMember(pMembershipTrustee: PTrusteeW;
      pMemberTrustee: PTrusteeW); safecall;
    procedure DeleteMember(pMembershipTrustee: PTrusteeW;
      pMemberTrustee: PTrusteeW); safecall;
    procedure IsMember(pMembershipTrustee: PTrusteeW; pMemberTrustee: PTrusteeW;
      out pfStatus: BOOL); safecall;
    procedure GetMembers(pMembershipTrustee: PTrusteeW; pcMembers: PUINT;
      out prgMembers: PTrusteeW); safecall;
    procedure GetMemberships(pTrustee: PTrusteeW; pcMemberships: PUINT;
      out prgMemberships: PTrusteeW); safecall;
  end;

// *********************************************************************//
// Interface: IObjectAccessControl
// GUID:      {0C733AA3-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  IObjectAccessControl = interface(IUnknown)
    ['{0C733AA3-2A1C-11CE-ADE5-00AA0044773D}']
    function GetObjectAccessRights(pObject: PSecObject; pcAccessEntries: PUINT;
      prgAccessEntries: PExplicitAccessW): HResult; stdcall;
    function GetObjectOwner(pObject: PSecObject; ppOwner: PPTrusteeW): HResult; stdcall;
    function IsObjectAccessAllowed(pObject: PSecObject; pAccessEntry: PExplicitAccessW;
      pfResult: PBOOL): HResult; stdcall;
    function SetObjectAccessRights(pObject: PSecObject; cAccessEntries: UINT;
      prgAccessEntries: PExplicitAccessW): HResult; stdcall;
    function SetObjectOwner(pObject: PSecObject; pOwner: PTrusteeW): HResult; stdcall;
  end;

  { Safecall Version }
  IObjectAccessControlSC = interface(IUnknown)
    ['{0C733AA3-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetObjectAccessRights(pObject: PSecObject; pcAccessEntries: PUINT;
      prgAccessEntries: PExplicitAccessW); safecall;
    procedure GetObjectOwner(pObject: PSecObject; ppOwner: PPTrusteeW); safecall;
    procedure IsObjectAccessAllowed(pObject: PSecObject; pAccessEntry: PExplicitAccessW;
      pfResult: PBOOL); safecall;
    procedure SetObjectAccessRights(pObject: PSecObject; cAccessEntries: UINT;
      prgAccessEntries: PExplicitAccessW); safecall;
    procedure SetObjectOwner(pObject: PSecObject; pOwner: PTrusteeW); safecall;
  end;

// *********************************************************************//
// Interface: ISecurityInfo
// GUID:      {0C733AA4-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  ISecurityInfo = interface(IUnknown)
    ['{0C733AA4-2A1C-11CE-ADE5-00AA0044773D}']
    function GetCurrentTrustee(ppTrustee: PPTrusteeW): HResult; stdcall;
    function GetObjectTypes(out cObjectTypes: UINT; out rgObjectTypes: PGUID): HResult; stdcall;
    function GetPermissions(ObjectType: TGUID; out pPermissions: UINT): HResult; stdcall;
  end;

  { Safecall Version }
  ISecurityInfoSC = interface(IUnknown)
    ['{0C733AA4-2A1C-11CE-ADE5-00AA0044773D}']
    procedure GetCurrentTrustee(ppTrustee: PPTrusteeW); safecall;
    procedure GetObjectTypes(out cObjectTypes: UINT; out rgObjectTypes: PGUID); safecall;
    procedure GetPermissions(ObjectType: TGUID; out pPermissions: UINT); safecall;
  end;

// *********************************************************************//
// Interface: IDBPromptInitialize
// GUID:      {2206CCB0-19C1-11D1-89E0-00C04FD7A829}
// *********************************************************************//
  IDBPromptInitialize = interface(IUnknown)
    ['{2206CCB0-19C1-11D1-89E0-00C04FD7A829}']
    function PromptDataSource(const pUnkOuter: IUnknown; hWndParent: HWND;
      dwPromptOptions: DBPROMPTOPTIONS; cSourceTypeFilter: ULONG;
      rgSourceTypeFilter: PDBSOURCETYPE; pszProviderFilter: POleStr;
      const riid: TIID; var DataSource: IUnknown): HResult; stdcall;
    function PromptFileName(hWndParent: HWND; dwPromptOptions: DBPROMPTOPTIONS;
      pwszInitialDirectory, pwszInitialFile: POleStr;
      var ppwszSelectedFile: POleStr): HResult; stdcall;
  end;

  { Safecall Version }
  IDBPromptInitializeSC = interface(IUnknown)
    ['{2206CCB0-19C1-11D1-89E0-00C04FD7A829}']
    procedure PromptDataSource(const pUnkOuter: IUnknown; hWndParent: HWND;
      dwPromptOptions: DBPROMPTOPTIONS; cSourceTypeFilter: ULONG;
      rgSourceTypeFilter: PDBSOURCETYPE; pszProviderFilter: POleStr;
      const riid: TIID; var DataSource: IUnknown); safecall;
    procedure PromptFileName(hWndParent: HWND; dwPromptOptions: DBPROMPTOPTIONS;
      pwszInitialDirectory, pwszInitialFile: POleStr;
      var ppwszSelectedFile: POleStr); safecall;
  end;

// *********************************************************************//
// Interface: IDataInitialize
// GUID:      {2206CCB1-19C1-11D1-89E0-00C04FD7A829}
// *********************************************************************//
  IDataInitialize = interface(IUnknown)
    ['{2206CCB1-19C1-11D1-89E0-00C04FD7A829}']
    function GetDataSource(const pUnkOuter: IUnknown; dwClsCtx: DWORD;
      pwszInitializationString: POleStr; const riid: TIID;
      var DataSource: IUnknown): HResult; stdcall;
    function GetInitializationString(const DataSource: IUnknown;
      fIncludePassword: Boolean; out pwszInitString: POleStr): HResult; stdcall;
    function CreateDBInstance(const clsidProvider: TGUID;
      const pUnkOuter: IUnknown; dwClsCtx: DWORD; pwszReserved: POleStr;
      riid: TIID; var DataSource: IUnknown): HResult; stdcall;
    function CreateDBInstanceEx(const clsidProvider: TGUID;
      const pUnkOuter: IUnknown; dwClsCtx: DWORD; pwszReserved: POleStr;
      pServerInfo: PCoServerInfo; cmq: ULONG; rgmqResults: PMultiQI): HResult; stdcall;
    function LoadStringFromStorage(pwszFileName: POleStr;
      out pwszInitializationString: POleStr): HResult; stdcall;
    function WriteStringToStorage(pwszFileName, pwszInitializationString: POleStr;
      dwCreationDisposition: DWORD): HResult; stdcall;
  end;

  { Safecall Version }
  IDataInitializeSC = interface(IUnknown)
    ['{2206CCB1-19C1-11D1-89E0-00C04FD7A829}']
    procedure GetDataSource(const pUnkOuter: IUnknown; dwClsCtx: DWORD;
      pwszInitializationString: POleStr; const riid: TIID;
      var DataSource: IUnknown); safecall;
    procedure GetInitializationString(const DataSource: IUnknown;
      fIncludePassword: Boolean; out pwszInitString: POleStr); safecall;
    procedure CreateDBInstance(const clsidProvider: TGUID;
      const pUnkOuter: IUnknown; dwClsCtx: DWORD; pwszReserved: POleStr;
      riid: TIID; var DataSource: IUnknown); safecall;
    procedure CreateDBInstanceEx(const clsidProvider: TGUID;
      const pUnkOuter: IUnknown; dwClsCtx: DWORD; pwszReserved: POleStr;
      pServerInfo: PCoServerInfo; cmq: ULONG; rgmqResults: PMultiQI); safecall;
    procedure LoadStringFromStorage(pwszFileName: POleStr;
      out pwszInitializationString: POleStr); safecall;
    procedure WriteStringToStorage(pwszFileName, pwszInitializationString: POleStr;
      dwCreationDisposition: DWORD); safecall;
  end;

// *********************************************************************//
// Error Constants from OLEDBERR.H
// *********************************************************************//

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +-+-+-+-+-+---------------------+-------------------------------+
//  |S|R|C|N|r|    Facility         |               Code            |
//  +-+-+-+-+-+---------------------+-------------------------------+
//
//  where
//
//      S - Severity - indicates success/fail
//
//          0 - Success
//          1 - Fail (COERROR)
//
//      R - reserved portion of the facility code, corresponds to NT's
//              second severity bit.
//
//      C - reserved portion of the facility code, corresponds to NT's
//              C field.
//
//      N - reserved portion of the facility code. Used to indicate a
//              mapped NT status value.
//
//      r - reserved portion of the facility code. Reserved for internal
//              use. Used to indicate HRESULT values that are not status
//              values, but are instead message ids for display strings.
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
const
  FACILITY_WINDOWS                     = $8;
  {$EXTERNALSYM FACILITY_WINDOWS}
  FACILITY_ITF                         = $4;
  {$EXTERNALSYM FACILITY_ITF}


//
// Define the severity codes
//
  STATUS_SEVERITY_SUCCESS              = $0;
  {$EXTERNALSYM STATUS_SEVERITY_SUCCESS}
  STATUS_SEVERITY_COERROR              = $2;
  {$EXTERNALSYM STATUS_SEVERITY_COERROR}


//
// MessageId: DB_E_BOGUS
//
// MessageText:
//
//  Dummy error - need this error so that mc puts the above defines
//  inside the FACILITY_WINDOWS guard, instead of leaving it empty
//
  DB_E_BOGUS                           = HResult($80040EFF);
  {$EXTERNALSYM DB_E_BOGUS}


//
// Codes 0x0e00-0x0eff are reserved for the OLE DB group of
// interfaces.
//
// Free codes are:
//
// Error:
//   -none-
//
// Success:
//   0x0eea
//   0x0ed7
//


//
// MessageId: DB_E_BADACCESSORHANDLE
//
// MessageText:
//
//  Invalid accessor
//
  DB_E_BADACCESSORHANDLE               = HResult($80040E00);
  {$EXTERNALSYM DB_E_BADACCESSORHANDLE}

//
// MessageId: DB_E_ROWLIMITEXCEEDED
//
// MessageText:
//
//  Creating another row would have exceeded the total number of active
//  rows supported by the rowset
//
  DB_E_ROWLIMITEXCEEDED                = HResult($80040E01);
  {$EXTERNALSYM DB_E_ROWLIMITEXCEEDED}

//
// MessageId: DB_E_READONLYACCESSOR
//
// MessageText:
//
//  Unable to write with a read-only accessor
//
  DB_E_READONLYACCESSOR                = HResult($80040E02);
  {$EXTERNALSYM DB_E_READONLYACCESSOR}

//
// MessageId: DB_E_SCHEMAVIOLATION
//
// MessageText:
//
//  Given values violate the database schema
//
  DB_E_SCHEMAVIOLATION                 = HResult($80040E03);
  {$EXTERNALSYM DB_E_SCHEMAVIOLATION}

//
// MessageId: DB_E_BADROWHANDLE
//
// MessageText:
//
//  Invalid row handle
//
  DB_E_BADROWHANDLE                    = HResult($80040E04);
  {$EXTERNALSYM DB_E_BADROWHANDLE}

//
// MessageId: DB_E_OBJECTOPEN
//
// MessageText:
//
//  An object was open
//
  DB_E_OBJECTOPEN                      = HResult($80040E05);
  {$EXTERNALSYM DB_E_OBJECTOPEN}

// @@@+ V1.5
//
// MessageId: DB_E_BADCHAPTER
//
// MessageText:
//
//  Invalid chapter
//
  DB_E_BADCHAPTER                      = HResult($80040E06);
  {$EXTERNALSYM DB_E_BADCHAPTER}

// @@@- V1.5

//
// MessageId: DB_E_CANTCONVERTVALUE
//
// MessageText:
//
//  A literal value in the command could not be converted to the
//  correct type due to a reason other than data overflow
//
  DB_E_CANTCONVERTVALUE                = HResult($80040E07);
  {$EXTERNALSYM DB_E_CANTCONVERTVALUE}

//
// MessageId: DB_E_BADBINDINFO
//
// MessageText:
//
//  Invalid binding info
//
  DB_E_BADBINDINFO                     = HResult($80040E08);
  {$EXTERNALSYM DB_E_BADBINDINFO}

//
// MessageId: DB_SEC_E_PERMISSIONDENIED
//
// MessageText:
//
//  Permission denied
//
  DB_SEC_E_PERMISSIONDENIED            = HResult($80040E09);
  {$EXTERNALSYM DB_SEC_E_PERMISSIONDENIED}

//
// MessageId: DB_E_NOTAREFERENCECOLUMN
//
// MessageText:
//
//  Specified column does not contain bookmarks or chapters
//
  DB_E_NOTAREFERENCECOLUMN             = HResult($80040E0A);
  {$EXTERNALSYM DB_E_NOTAREFERENCECOLUMN}

// @@@+ V2.5
//
// MessageId: DB_E_LIMITREJECTED
//
// MessageText:
//
//  Some cost limits were rejected
//
  DB_E_LIMITREJECTED                   = HResult($80040E0B);
  {$EXTERNALSYM DB_E_LIMITREJECTED}

// @@@- V2.5

//
// MessageId: DB_E_NOCOMMAND
//
// MessageText:
//
//  No command has been set for the command object
//
  DB_E_NOCOMMAND                       = HResult($80040E0C);
  {$EXTERNALSYM DB_E_NOCOMMAND}

// @@@+ V2.5
//
// MessageId: DB_E_COSTLIMIT
//
// MessageText:
//
//  Unable to find a query plan within the given cost limit
//
  DB_E_COSTLIMIT                       = HResult($80040E0D);
  {$EXTERNALSYM DB_E_COSTLIMIT}

// @@@- V2.5

//
// MessageId: DB_E_BADBOOKMARK
//
// MessageText:
//
//  Invalid bookmark
//
  DB_E_BADBOOKMARK                     = HResult($80040E0E);
  {$EXTERNALSYM DB_E_BADBOOKMARK}

//
// MessageId: DB_E_BADLOCKMODE
//
// MessageText:
//
//  Invalid lock mode
//
  DB_E_BADLOCKMODE                     = HResult($80040E0F);
  {$EXTERNALSYM DB_E_BADLOCKMODE}

//
// MessageId: DB_E_PARAMNOTOPTIONAL
//
// MessageText:
//
//  No value given for one or more required parameters
//
  DB_E_PARAMNOTOPTIONAL                = HResult($80040E10);
  {$EXTERNALSYM DB_E_PARAMNOTOPTIONAL}

//
// MessageId: DB_E_BADCOLUMNID
//
// MessageText:
//
//  Invalid column ID
//
  DB_E_BADCOLUMNID                     = HResult($80040E11);
  {$EXTERNALSYM DB_E_BADCOLUMNID}

//
// MessageId: DB_E_BADRATIO
//
// MessageText:
//
//  Invalid ratio
//
  DB_E_BADRATIO                        = HResult($80040E12);
  {$EXTERNALSYM DB_E_BADRATIO}

// @@@+ V2.0
//
// MessageId: DB_E_BADVALUES
//
// MessageText:
//
//  Invalid value
//
  DB_E_BADVALUES                       = HResult($80040E13);
  {$EXTERNALSYM DB_E_BADVALUES}

// @@@- V2.0

//
// MessageId: DB_E_ERRORSINCOMMAND
//
// MessageText:
//
//  The command contained one or more errors
//
  DB_E_ERRORSINCOMMAND                 = HResult($80040E14);
  {$EXTERNALSYM DB_E_ERRORSINCOMMAND}

//
// MessageId: DB_E_CANTCANCEL
//
// MessageText:
//
//  The executing command cannot be canceled
//
  DB_E_CANTCANCEL                      = HResult($80040E15);
  {$EXTERNALSYM DB_E_CANTCANCEL}

//
// MessageId: DB_E_DIALECTNOTSUPPORTED
//
// MessageText:
//
//  The provider does not support the specified dialect
//
  DB_E_DIALECTNOTSUPPORTED             = HResult($80040E16);
  {$EXTERNALSYM DB_E_DIALECTNOTSUPPORTED}

//
// MessageId: DB_E_DUPLICATEDATASOURCE
//
// MessageText:
//
//  A data source with the specified name already exists
//
  DB_E_DUPLICATEDATASOURCE             = HResult($80040E17);
  {$EXTERNALSYM DB_E_DUPLICATEDATASOURCE}

//
// MessageId: DB_E_CANNOTRESTART
//
// MessageText:
//
//  The rowset was built over a live data feed and cannot be restarted
//
  DB_E_CANNOTRESTART                   = HResult($80040E18);
  {$EXTERNALSYM DB_E_CANNOTRESTART}

//
// MessageId: DB_E_NOTFOUND
//
// MessageText:
//
//  No key matching the described characteristics could be found within
//  the current range
//
  DB_E_NOTFOUND                        = HResult($80040E19);
  {$EXTERNALSYM DB_E_NOTFOUND}

//
// MessageId: DB_E_NEWLYINSERTED
//
// MessageText:
//
//  The provider is unable to determine identity for newly inserted
//  rows
//
  DB_E_NEWLYINSERTED                   = HResult($80040E1B);
  {$EXTERNALSYM DB_E_NEWLYINSERTED}

// @@@+ V2.5
//
// MessageId: DB_E_CANNOTFREE
//
// MessageText:
//
//  Ownership of this tree has been given to the provider
//
  DB_E_CANNOTFREE                      = HResult($80040E1A);
  {$EXTERNALSYM DB_E_CANNOTFREE}

//
// MessageId: DB_E_GOALREJECTED
//
// MessageText:
//
//  No nonzero weights specified for any goals supported, so goal was
//  rejected; current goal was not changed
//
  DB_E_GOALREJECTED                    = HResult($80040E1C);
  {$EXTERNALSYM DB_E_GOALREJECTED}

// @@@- V2.5

//
// MessageId: DB_E_UNSUPPORTEDCONVERSION
//
// MessageText:
//
//  Requested conversion is not supported
//
  DB_E_UNSUPPORTEDCONVERSION           = HResult($80040E1D);
  {$EXTERNALSYM DB_E_UNSUPPORTEDCONVERSION}

//
// MessageId: DB_E_BADSTARTPOSITION
//
// MessageText:
//
//  lRowsOffset would position you past either end of the rowset,
//  regardless of the cRows value specified; cRowsObtained is 0
//
  DB_E_BADSTARTPOSITION                = HResult($80040E1E);
  {$EXTERNALSYM DB_E_BADSTARTPOSITION}

// @@@+ V2.0
//
// MessageId: DB_E_NOQUERY
//
// MessageText:
//
//  Information was requested for a query, and the query was not set
//
  DB_E_NOQUERY                         = HResult($80040E1F);
  {$EXTERNALSYM DB_E_NOQUERY}

// @@@- V2.0

//
// MessageId: DB_E_NOTREENTRANT
//
// MessageText:
//
//  Provider called a method from IRowsetNotify in the consumer and the
//  method has not yet returned
//
  DB_E_NOTREENTRANT                    = HResult($80040E20);
  {$EXTERNALSYM DB_E_NOTREENTRANT}

//
// MessageId: DB_E_ERRORSOCCURRED
//
// MessageText:
//
//  Errors occurred
//
  DB_E_ERRORSOCCURRED                  = HResult($80040E21);
  {$EXTERNALSYM DB_E_ERRORSOCCURRED}

//
// MessageId: DB_E_NOAGGREGATION
//
// MessageText:
//
//  A non-NULL controlling IUnknown was specified and the object being
//  created does not support aggregation
//
  DB_E_NOAGGREGATION                   = HResult($80040E22);
  {$EXTERNALSYM DB_E_NOAGGREGATION}

//
// MessageId: DB_E_DELETEDROW
//
// MessageText:
//
//  A given HROW referred to a hard- or soft-deleted row
//
  DB_E_DELETEDROW                      = HResult($80040E23);
  {$EXTERNALSYM DB_E_DELETEDROW}

//
// MessageId: DB_E_CANTFETCHBACKWARDS
//
// MessageText:
//
//  The rowset does not support fetching backwards
//
  DB_E_CANTFETCHBACKWARDS              = HResult($80040E24);
  {$EXTERNALSYM DB_E_CANTFETCHBACKWARDS}

//
// MessageId: DB_E_ROWSNOTRELEASED
//
// MessageText:
//
//  All HROWs must be released before new ones can be obtained
//
  DB_E_ROWSNOTRELEASED                 = HResult($80040E25);
  {$EXTERNALSYM DB_E_ROWSNOTRELEASED}

//
// MessageId: DB_E_BADSTORAGEFLAG
//
// MessageText:
//
//  One of the specified storage flags was not supported
//
  DB_E_BADSTORAGEFLAG                  = HResult($80040E26);
  {$EXTERNALSYM DB_E_BADSTORAGEFLAG}

// @@@+ V1.5
//
// MessageId: DB_E_BADCOMPAREOP
//
// MessageText:
//
//  The comparison operator was invalid
//
  DB_E_BADCOMPAREOP                    = HResult($80040E27);
  {$EXTERNALSYM DB_E_BADCOMPAREOP}

// @@@- V1.5

//
// MessageId: DB_E_BADSTATUSVALUE
//
// MessageText:
//
//  The specified status flag was neither DBCOLUMNSTATUS_OK nor
//  DBCOLUMNSTATUS_ISNULL
//
  DB_E_BADSTATUSVALUE                  = HResult($80040E28);
  {$EXTERNALSYM DB_E_BADSTATUSVALUE}

//
// MessageId: DB_E_CANTSCROLLBACKWARDS
//
// MessageText:
//
//  The rowset cannot scroll backwards
//
  DB_E_CANTSCROLLBACKWARDS             = HResult($80040E29);
  {$EXTERNALSYM DB_E_CANTSCROLLBACKWARDS}

// @@@+ V2.5
//
// MessageId: DB_E_BADREGIONHANDLE
//
// MessageText:
//
//  Invalid region handle
//
  DB_E_BADREGIONHANDLE                 = HResult($80040E2A);
  {$EXTERNALSYM DB_E_BADREGIONHANDLE}

//
// MessageId: DB_E_NONCONTIGUOUSRANGE
//
// MessageText:
//
//  The specified set of rows was not contiguous to or overlapping the
//  rows in the specified watch region
//
  DB_E_NONCONTIGUOUSRANGE              = HResult($80040E2B);
  {$EXTERNALSYM DB_E_NONCONTIGUOUSRANGE}

//
// MessageId: DB_E_INVALIDTRANSITION
//
// MessageText:
//
//  A transition from ALL* to MOVE* or EXTEND* was specified
//
  DB_E_INVALIDTRANSITION               = HResult($80040E2C);
  {$EXTERNALSYM DB_E_INVALIDTRANSITION}

//
// MessageId: DB_E_NOTASUBREGION
//
// MessageText:
//
//  The specified region is not a proper subregion of the region
//  identified by the given watch region handle
//
  DB_E_NOTASUBREGION                   = HResult($80040E2D);
  {$EXTERNALSYM DB_E_NOTASUBREGION}

// @@@- V2.5

//
// MessageId: DB_E_MULTIPLESTATEMENTS
//
// MessageText:
//
//  The provider does not support multi-statement commands
//
  DB_E_MULTIPLESTATEMENTS              = HResult($80040E2E);
  {$EXTERNALSYM DB_E_MULTIPLESTATEMENTS}

//
// MessageId: DB_E_INTEGRITYVIOLATION
//
// MessageText:
//
//  A specified value violated the integrity constraints for a column or
//  table
//
  DB_E_INTEGRITYVIOLATION              = HResult($80040E2F);
  {$EXTERNALSYM DB_E_INTEGRITYVIOLATION}

//
// MessageId: DB_E_BADTYPENAME
//
// MessageText:
//
//  The given type name was unrecognized
//
  DB_E_BADTYPENAME                     = HResult($80040E30);
  {$EXTERNALSYM DB_E_BADTYPENAME}

//
// MessageId: DB_E_ABORTLIMITREACHED
//
// MessageText:
//
//  Execution aborted because a resource limit has been reached; no
//  results have been returned
//
  DB_E_ABORTLIMITREACHED               = HResult($80040E31);
  {$EXTERNALSYM DB_E_ABORTLIMITREACHED}

// @@@+ V2.0
//
// MessageId: DB_E_ROWSETINCOMMAND
//
// MessageText:
//
//  Cannot clone a command object whose command tree contains a rowset
//  or rowsets
//
  DB_E_ROWSETINCOMMAND                 = HResult($80040E32);
  {$EXTERNALSYM DB_E_ROWSETINCOMMAND}

//
// MessageId: DB_E_CANTTRANSLATE
//
// MessageText:
//
//  Cannot represent the current tree as text
//
  DB_E_CANTTRANSLATE                   = HResult($80040E33);
  {$EXTERNALSYM DB_E_CANTTRANSLATE}

// @@@- V2.0

//
// MessageId: DB_E_DUPLICATEINDEXID
//
// MessageText:
//
//  The specified index already exists
//
  DB_E_DUPLICATEINDEXID                = HResult($80040E34);
  {$EXTERNALSYM DB_E_DUPLICATEINDEXID}

//
// MessageId: DB_E_NOINDEX
//
// MessageText:
//
//  The specified index does not exist
//
  DB_E_NOINDEX                         = HResult($80040E35);
  {$EXTERNALSYM DB_E_NOINDEX}

//
// MessageId: DB_E_INDEXINUSE
//
// MessageText:
//
//  The specified index was in use
//
  DB_E_INDEXINUSE                      = HResult($80040E36);
  {$EXTERNALSYM DB_E_INDEXINUSE}

//
// MessageId: DB_E_NOTABLE
//
// MessageText:
//
//  The specified table does not exist
//
  DB_E_NOTABLE                         = HResult($80040E37);
  {$EXTERNALSYM DB_E_NOTABLE}

//
// MessageId: DB_E_CONCURRENCYVIOLATION
//
// MessageText:
//
//  The rowset was using optimistic concurrency and the value of a
//  column has been changed since it was last read
//
  DB_E_CONCURRENCYVIOLATION            = HResult($80040E38);
  {$EXTERNALSYM DB_E_CONCURRENCYVIOLATION}

//
// MessageId: DB_E_BADCOPY
//
// MessageText:
//
//  Errors were detected during the copy
//
  DB_E_BADCOPY                         = HResult($80040E39);
  {$EXTERNALSYM DB_E_BADCOPY}

//
// MessageId: DB_E_BADPRECISION
//
// MessageText:
//
//  A specified precision was invalid
//
  DB_E_BADPRECISION                    = HResult($80040E3A);
  {$EXTERNALSYM DB_E_BADPRECISION}

//
// MessageId: DB_E_BADSCALE
//
// MessageText:
//
//  A specified scale was invalid
//
  DB_E_BADSCALE                        = HResult($80040E3B);
  {$EXTERNALSYM DB_E_BADSCALE}

//
// MessageId: DB_E_BADTABLEID
//
// MessageText:
//
//  Invalid table ID
//
  DB_E_BADTABLEID                      = HResult($80040E3C);
  {$EXTERNALSYM DB_E_BADTABLEID}

// DB_E_BADID is deprecated; use DB_E_BADTABLEID instead
  DB_E_BADID     = DB_E_BADTABLEID;
  {$EXTERNALSYM DB_E_BADID}

//
// MessageId: DB_E_BADTYPE
//
// MessageText:
//
//  A specified type was invalid
//
  DB_E_BADTYPE                         = HResult($80040E3D);
  {$EXTERNALSYM DB_E_BADTYPE}

//
// MessageId: DB_E_DUPLICATECOLUMNID
//
// MessageText:
//
//  A column ID was occurred more than once in the specification
//
  DB_E_DUPLICATECOLUMNID               = HResult($80040E3E);
  {$EXTERNALSYM DB_E_DUPLICATECOLUMNID}

//
// MessageId: DB_E_DUPLICATETABLEID
//
// MessageText:
//
//  The specified table already exists
//
  DB_E_DUPLICATETABLEID                = HResult($80040E3F);
  {$EXTERNALSYM DB_E_DUPLICATETABLEID}

//
// MessageId: DB_E_TABLEINUSE
//
// MessageText:
//
//  The specified table was in use
//
  DB_E_TABLEINUSE                      = HResult($80040E40);
  {$EXTERNALSYM DB_E_TABLEINUSE}

//
// MessageId: DB_E_NOLOCALE
//
// MessageText:
//
//  The specified locale ID was not supported
//
  DB_E_NOLOCALE                        = HResult($80040E41);
  {$EXTERNALSYM DB_E_NOLOCALE}

//
// MessageId: DB_E_BADRECORDNUM
//
// MessageText:
//
//  The specified record number is invalid
//
  DB_E_BADRECORDNUM                    = HResult($80040E42);
  {$EXTERNALSYM DB_E_BADRECORDNUM}

//
// MessageId: DB_E_BOOKMARKSKIPPED
//
// MessageText:
//
//  Although the bookmark was validly formed, no row could be found to
//  match it
//
  DB_E_BOOKMARKSKIPPED                 = HResult($80040E43);
  {$EXTERNALSYM DB_E_BOOKMARKSKIPPED}

//
// MessageId: DB_E_BADPROPERTYVALUE
//
// MessageText:
//
//  The value of a property was invalid
//
  DB_E_BADPROPERTYVALUE                = HResult($80040E44);
  {$EXTERNALSYM DB_E_BADPROPERTYVALUE}

//
// MessageId: DB_E_INVALID
//
// MessageText:
//
//  The rowset was not chaptered
//
  DB_E_INVALID                         = HResult($80040E45);
  {$EXTERNALSYM DB_E_INVALID}

//
// MessageId: DB_E_BADACCESSORFLAGS
//
// MessageText:
//
//  Invalid accessor
//
  DB_E_BADACCESSORFLAGS                = HResult($80040E46);
  {$EXTERNALSYM DB_E_BADACCESSORFLAGS}

//
// MessageId: DB_E_BADSTORAGEFLAGS
//
// MessageText:
//
//  Invalid storage flags
//
  DB_E_BADSTORAGEFLAGS                 = HResult($80040E47);
  {$EXTERNALSYM DB_E_BADSTORAGEFLAGS}

//
// MessageId: DB_E_BYREFACCESSORNOTSUPPORTED
//
// MessageText:
//
//  By-ref accessors are not supported by this provider
//
  DB_E_BYREFACCESSORNOTSUPPORTED       = HResult($80040E48);
  {$EXTERNALSYM DB_E_BYREFACCESSORNOTSUPPORTED}

//
// MessageId: DB_E_NULLACCESSORNOTSUPPORTED
//
// MessageText:
//
//  Null accessors are not supported by this provider
//
  DB_E_NULLACCESSORNOTSUPPORTED        = HResult($80040E49);
  {$EXTERNALSYM DB_E_NULLACCESSORNOTSUPPORTED}

//
// MessageId: DB_E_NOTPREPARED
//
// MessageText:
//
//  The command was not prepared
//
  DB_E_NOTPREPARED                     = HResult($80040E4A);
  {$EXTERNALSYM DB_E_NOTPREPARED}

//
// MessageId: DB_E_BADACCESSORTYPE
//
// MessageText:
//
//  The specified accessor was not a parameter accessor
//
  DB_E_BADACCESSORTYPE                 = HResult($80040E4B);
  {$EXTERNALSYM DB_E_BADACCESSORTYPE}

//
// MessageId: DB_E_WRITEONLYACCESSOR
//
// MessageText:
//
//  The given accessor was write-only
//
  DB_E_WRITEONLYACCESSOR               = HResult($80040E4C);
  {$EXTERNALSYM DB_E_WRITEONLYACCESSOR}

//
// MessageId: DB_SEC_E_AUTH_FAILED
//
// MessageText:
//
//  Authentication failed
//
  DB_SEC_E_AUTH_FAILED                 = HResult($80040E4D);
  {$EXTERNALSYM DB_SEC_E_AUTH_FAILED}

//
// MessageId: DB_E_CANCELED
//
// MessageText:
//
//  The change was canceled during notification; no columns are changed
//
  DB_E_CANCELED                        = HResult($80040E4E);
  {$EXTERNALSYM DB_E_CANCELED}

// @@@+ V2.0
//
// MessageId: DB_E_CHAPTERNOTRELEASED
//
// MessageText:
//
//  The rowset was single-chaptered and the chapter was not released
//
  DB_E_CHAPTERNOTRELEASED              = HResult($80040E4F);
  {$EXTERNALSYM DB_E_CHAPTERNOTRELEASED}

// @@@- V2.0

//
// MessageId: DB_E_BADSOURCEHANDLE
//
// MessageText:
//
//  Invalid source handle
//
  DB_E_BADSOURCEHANDLE                 = HResult($80040E50);
  {$EXTERNALSYM DB_E_BADSOURCEHANDLE}

//
// MessageId: DB_E_PARAMUNAVAILABLE
//
// MessageText:
//
//  The provider cannot derive parameter info and SetParameterInfo has
//  not been called
//
  DB_E_PARAMUNAVAILABLE                = HResult($80040E51);
  {$EXTERNALSYM DB_E_PARAMUNAVAILABLE}

//
// MessageId: DB_E_ALREADYINITIALIZED
//
// MessageText:
//
//  The data source object is already initialized
//
  DB_E_ALREADYINITIALIZED              = HResult($80040E52);
  {$EXTERNALSYM DB_E_ALREADYINITIALIZED}

//
// MessageId: DB_E_NOTSUPPORTED
//
// MessageText:
//
//  The provider does not support this method
//
  DB_E_NOTSUPPORTED                    = HResult($80040E53);
  {$EXTERNALSYM DB_E_NOTSUPPORTED}

//
// MessageId: DB_E_MAXPENDCHANGESEXCEEDED
//
// MessageText:
//
//  The number of rows with pending changes has exceeded the set limit
//
  DB_E_MAXPENDCHANGESEXCEEDED          = HResult($80040E54);
  {$EXTERNALSYM DB_E_MAXPENDCHANGESEXCEEDED}

//
// MessageId: DB_E_BADORDINAL
//
// MessageText:
//
//  The specified column did not exist
//
  DB_E_BADORDINAL                      = HResult($80040E55);
  {$EXTERNALSYM DB_E_BADORDINAL}

//
// MessageId: DB_E_PENDINGCHANGES
//
// MessageText:
//
//  There are pending changes on a row with a reference count of zero
//
  DB_E_PENDINGCHANGES                  = HResult($80040E56);
  {$EXTERNALSYM DB_E_PENDINGCHANGES}

//
// MessageId: DB_E_DATAOVERFLOW
//
// MessageText:
//
//  A literal value in the command overflowed the range of the type of
//  the associated column
//
  DB_E_DATAOVERFLOW                    = HResult($80040E57);
  {$EXTERNALSYM DB_E_DATAOVERFLOW}

//
// MessageId: DB_E_BADHRESULT
//
// MessageText:
//
//  The supplied HRESULT was invalid
//
  DB_E_BADHRESULT                      = HResult($80040E58);
  {$EXTERNALSYM DB_E_BADHRESULT}

//
// MessageId: DB_E_BADLOOKUPID
//
// MessageText:
//
//  The supplied LookupID was invalid
//
  DB_E_BADLOOKUPID                     = HResult($80040E59);
  {$EXTERNALSYM DB_E_BADLOOKUPID}

//
// MessageId: DB_E_BADDYNAMICERRORID
//
// MessageText:
//
//  The supplied DynamicErrorID was invalid
//
  DB_E_BADDYNAMICERRORID               = HResult($80040E5A);
  {$EXTERNALSYM DB_E_BADDYNAMICERRORID}

//
// MessageId: DB_E_PENDINGINSERT
//
// MessageText:
//
//  Unable to get visible data for a newly-inserted row that has not
//  yet been updated
//
  DB_E_PENDINGINSERT                   = HResult($80040E5B);
  {$EXTERNALSYM DB_E_PENDINGINSERT}

//
// MessageId: DB_E_BADCONVERTFLAG
//
// MessageText:
//
//  Invalid conversion flag
//
  DB_E_BADCONVERTFLAG                  = HResult($80040E5C);
  {$EXTERNALSYM DB_E_BADCONVERTFLAG}

//
// MessageId: DB_E_BADPARAMETERNAME
//
// MessageText:
//
//  The given parameter name was unrecognized
//
  DB_E_BADPARAMETERNAME                = HResult($80040E5D);
  {$EXTERNALSYM DB_E_BADPARAMETERNAME}

//
// MessageId: DB_E_MULTIPLESTORAGE
//
// MessageText:
//
//  Multiple storage objects can not be open simultaneously
//
  DB_E_MULTIPLESTORAGE                 = HResult($80040E5E);
  {$EXTERNALSYM DB_E_MULTIPLESTORAGE}

//
// MessageId: DB_E_CANTFILTER
//
// MessageText:
//
//  The requested filter could not be opened
//
  DB_E_CANTFILTER                      = HResult($80040E5F);
  {$EXTERNALSYM DB_E_CANTFILTER}

//
// MessageId: DB_E_CANTORDER
//
// MessageText:
//
//  The requested order could not be opened
//
  DB_E_CANTORDER                       = HResult($80040E60);
  {$EXTERNALSYM DB_E_CANTORDER}

// @@@+ V2.0
//
// MessageId: MD_E_BADTUPLE
//
// MessageText:
//
//  Bad tuple
//
  MD_E_BADTUPLE                        = HResult($80040E61);
  {$EXTERNALSYM MD_E_BADTUPLE}

//
// MessageId: MD_E_BADCOORDINATE
//
// MessageText:
//
//  Bad coordinate
//
  MD_E_BADCOORDINATE                   = HResult($80040E62);
  {$EXTERNALSYM MD_E_BADCOORDINATE}

//
// MessageId: MD_E_INVALIDAXIS
//
// MessageText:
//
//  The given aixs was not valid for this Dataset
//
  MD_E_INVALIDAXIS                     = HResult($80040E63);
  {$EXTERNALSYM MD_E_INVALIDAXIS}

//
// MessageId: MD_E_INVALIDCELLRANGE
//
// MessageText:
//
//  One or more of the given cell ordinals was invalid
//
  MD_E_INVALIDCELLRANGE                = HResult($80040E64);
  {$EXTERNALSYM MD_E_INVALIDCELLRANGE}

//
// MessageId: DB_E_NOCOLUMN
//
// MessageText:
//
//  The supplied columnID was invalid
//
  DB_E_NOCOLUMN                        = HResult($80040E65);
  {$EXTERNALSYM DB_E_NOCOLUMN}

//
// MessageId: DB_E_COMMANDNOTPERSISTED
//
// MessageText:
//
//  The supplied command does not have a DBID
//
  DB_E_COMMANDNOTPERSISTED             = HResult($80040E67);
  {$EXTERNALSYM DB_E_COMMANDNOTPERSISTED}

//
// MessageId: DB_E_DUPLICATEID
//
// MessageText:
//
//  The supplied DBID already exists
//
  DB_E_DUPLICATEID                     = HResult($80040E68);
  {$EXTERNALSYM DB_E_DUPLICATEID}

//
// MessageId: DB_E_OBJECTCREATIONLIMITREACHED
//
// MessageText:
//
//  The maximum number of Sessions supported by the provider has
//  already been created. The consumer must release one or more
//  currently held Sessions before obtaining a new Session Object
//
  DB_E_OBJECTCREATIONLIMITREACHED      = HResult($80040E69);
  {$EXTERNALSYM DB_E_OBJECTCREATIONLIMITREACHED}

//
// MessageId: DB_E_BADINDEXID
//
// MessageText:
//
//  The index ID is invalid
//
  DB_E_BADINDEXID                      = HResult($80040E72);
  {$EXTERNALSYM DB_E_BADINDEXID}

//
// MessageId: DB_E_BADINITSTRING
//
// MessageText:
//
//  The initialization string specified does not conform to specificiation
//
  DB_E_BADINITSTRING                   = HResult($80040E73);
  {$EXTERNALSYM DB_E_BADINITSTRING}

//
// MessageId: DB_E_NOPROVIDERSREGISTERED
//
// MessageText:
//
//  The OLE DB root enumerator did not return any providers that
//  matched any of the SOURCES_TYPEs requested
//
  DB_E_NOPROVIDERSREGISTERED           = HResult($80040E74);
  {$EXTERNALSYM DB_E_NOPROVIDERSREGISTERED}

//
// MessageId: DB_E_MISMATCHEDPROVIDER
//
// MessageText:
//
//  The initialization string specifies a provider which does not match the currently active provider
//
  DB_E_MISMATCHEDPROVIDER              = HResult($80040E75);
  {$EXTERNALSYM DB_E_MISMATCHEDPROVIDER}

//
// MessageId: SEC_E_BADTRUSTEEID
//
// MessageText:
//
//  Invalid trustee value
//
  SEC_E_BADTRUSTEEID                   = HResult($80040E6A);
  {$EXTERNALSYM SEC_E_BADTRUSTEEID}

//
// MessageId: SEC_E_NOTRUSTEEID
//
// MessageText:
//
//  The trustee is not for the current data source
//
  SEC_E_NOTRUSTEEID                    = HResult($80040E6B);
  {$EXTERNALSYM SEC_E_NOTRUSTEEID}

//
// MessageId: SEC_E_NOMEMBERSHIPSUPPORT
//
// MessageText:
//
//  The trustee does not support memberships/collections
//
  SEC_E_NOMEMBERSHIPSUPPORT            = HResult($80040E6C);
  {$EXTERNALSYM SEC_E_NOMEMBERSHIPSUPPORT}

//
// MessageId: SEC_E_INVALIDOBJECT
//
// MessageText:
//
//  The object is invalid or unknown to the provider
//
  SEC_E_INVALIDOBJECT                  = HResult($80040E6D);
  {$EXTERNALSYM SEC_E_INVALIDOBJECT}

//
// MessageId: SEC_E_NOOWNER
//
// MessageText:
//
//  No owner exists for the object
//
  SEC_E_NOOWNER                        = HResult($80040E6E);
  {$EXTERNALSYM SEC_E_NOOWNER}

//
// MessageId: SEC_E_INVALIDACCESSENTRYLIST
//
// MessageText:
//
//  The access entry list supplied is invalid
//
  SEC_E_INVALIDACCESSENTRYLIST         = HResult($80040E6F);
  {$EXTERNALSYM SEC_E_INVALIDACCESSENTRYLIST}

//
// MessageId: SEC_E_INVALIDOWNER
//
// MessageText:
//
//  The trustee supplied as owner is invalid or unknown to the provider
//
  SEC_E_INVALIDOWNER                   = HResult($80040E70);
  {$EXTERNALSYM SEC_E_INVALIDOWNER}

//
// MessageId: SEC_E_INVALIDACCESSENTRY
//
// MessageText:
//
//  The permission supplied in the access entry list is invalid
//
  SEC_E_INVALIDACCESSENTRY             = HResult($80040E71);
  {$EXTERNALSYM SEC_E_INVALIDACCESSENTRY}

  SEC_E_PERMISSIONDENIED     = DB_SEC_E_PERMISSIONDENIED;
  {$EXTERNALSYM SEC_E_PERMISSIONDENIED}
// @@@- V2.1

//
// MessageId: DB_S_ROWLIMITEXCEEDED
//
// MessageText:
//
//  Fetching requested number of rows would have exceeded total number
//  of active rows supported by the rowset
//
  DB_S_ROWLIMITEXCEEDED                = $00040EC0;
  {$EXTERNALSYM DB_S_ROWLIMITEXCEEDED}

//
// MessageId: DB_S_COLUMNTYPEMISMATCH
//
// MessageText:
//
//  One or more column types are incompatible; conversion errors will
//  occur during copying
//
  DB_S_COLUMNTYPEMISMATCH              = $00040EC1;
  {$EXTERNALSYM DB_S_COLUMNTYPEMISMATCH}

//
// MessageId: DB_S_TYPEINFOOVERRIDDEN
//
// MessageText:
//
//  Parameter type information has been overridden by caller
//
  DB_S_TYPEINFOOVERRIDDEN              = $00040EC2;
  {$EXTERNALSYM DB_S_TYPEINFOOVERRIDDEN}

//
// MessageId: DB_S_BOOKMARKSKIPPED
//
// MessageText:
//
//  Skipped bookmark for deleted or non-member row
//
  DB_S_BOOKMARKSKIPPED                 = $00040EC3;
  {$EXTERNALSYM DB_S_BOOKMARKSKIPPED}

// @@@+ V2.0
//
// MessageId: DB_S_NONEXTROWSET
//
// MessageText:
//
//  There are no more rowsets
//
  DB_S_NONEXTROWSET                    = $00040EC5;
  {$EXTERNALSYM DB_S_NONEXTROWSET}

// @@@- V2.0

//
// MessageId: DB_S_ENDOFROWSET
//
// MessageText:
//
//  Reached start or end of rowset or chapter
//
  DB_S_ENDOFROWSET                     = $00040EC6;
  {$EXTERNALSYM DB_S_ENDOFROWSET}

//
// MessageId: DB_S_COMMANDREEXECUTED
//
// MessageText:
//
//  The provider re-executed the command
//
  DB_S_COMMANDREEXECUTED               = $00040EC7;
  {$EXTERNALSYM DB_S_COMMANDREEXECUTED}

//
// MessageId: DB_S_BUFFERFULL
//
// MessageText:
//
//  Variable data buffer full
//
  DB_S_BUFFERFULL                      = $00040EC8;
  {$EXTERNALSYM DB_S_BUFFERFULL}

//
// MessageId: DB_S_NORESULT
//
// MessageText:
//
//  There are no more results
//
  DB_S_NORESULT                        = $00040EC9;
  {$EXTERNALSYM DB_S_NORESULT}

//
// MessageId: DB_S_CANTRELEASE
//
// MessageText:
//
//  Server cannot release or downgrade a lock until the end of the
//  transaction
//
  DB_S_CANTRELEASE                     = $00040ECA;
  {$EXTERNALSYM DB_S_CANTRELEASE}

// @@@+ V2.5
//
// MessageId: DB_S_GOALCHANGED
//
// MessageText:
//
//  Specified weight was not supported or exceeded the supported limit
//  and was set to 0 or the supported limit
//
  DB_S_GOALCHANGED                     = $00040ECB;
  {$EXTERNALSYM DB_S_GOALCHANGED}

// @@@- V2.5

// @@@+ V1.5
//
// MessageId: DB_S_UNWANTEDOPERATION
//
// MessageText:
//
//  Consumer is uninterested in receiving further notification calls for
//  this reason
//
  DB_S_UNWANTEDOPERATION               = $00040ECC;
  {$EXTERNALSYM DB_S_UNWANTEDOPERATION}

// @@@- V1.5

//
// MessageId: DB_S_DIALECTIGNORED
//
// MessageText:
//
//  Input dialect was ignored and text was returned in different
//  dialect
//
  DB_S_DIALECTIGNORED                  = $00040ECD;
  {$EXTERNALSYM DB_S_DIALECTIGNORED}

//
// MessageId: DB_S_UNWANTEDPHASE
//
// MessageText:
//
//  Consumer is uninterested in receiving further notification calls for
//  this phase
//
  DB_S_UNWANTEDPHASE                   = $00040ECE;
  {$EXTERNALSYM DB_S_UNWANTEDPHASE}

//
// MessageId: DB_S_UNWANTEDREASON
//
// MessageText:
//
//  Consumer is uninterested in receiving further notification calls for
//  this reason
//
  DB_S_UNWANTEDREASON                  = $00040ECF;
  {$EXTERNALSYM DB_S_UNWANTEDREASON}

// @@@+ V1.5
//
// MessageId: DB_S_ASYNCHRONOUS
//
// MessageText:
//
//  The operation is being processed asynchronously
//
  DB_S_ASYNCHRONOUS                    = $00040ED0;
  {$EXTERNALSYM DB_S_ASYNCHRONOUS}

// @@@- V1.5

//
// MessageId: DB_S_COLUMNSCHANGED
//
// MessageText:
//
//  In order to reposition to the start of the rowset, the provider had
//  to reexecute the query; either the order of the columns changed or
//  columns were added to or removed from the rowset
//
  DB_S_COLUMNSCHANGED                  = $00040ED1;
  {$EXTERNALSYM DB_S_COLUMNSCHANGED}

//
// MessageId: DB_S_ERRORSRETURNED
//
// MessageText:
//
//  The method had some errors; errors have been returned in the error
//  array
//
  DB_S_ERRORSRETURNED                  = $00040ED2;
  {$EXTERNALSYM DB_S_ERRORSRETURNED}

//
// MessageId: DB_S_BADROWHANDLE
//
// MessageText:
//
//  Invalid row handle
//
  DB_S_BADROWHANDLE                    = $00040ED3;
  {$EXTERNALSYM DB_S_BADROWHANDLE}

//
// MessageId: DB_S_DELETEDROW
//
// MessageText:
//
//  A given HROW referred to a hard-deleted row
//
  DB_S_DELETEDROW                      = $00040ED4;
  {$EXTERNALSYM DB_S_DELETEDROW}

// @@@+ V2.5
//
// MessageId: DB_S_TOOMANYCHANGES
//
// MessageText:
//
//  The provider was unable to keep track of all the changes; the client
//  must refetch the data associated with the watch region using another
//  method
//
  DB_S_TOOMANYCHANGES                  = $00040ED5;
  {$EXTERNALSYM DB_S_TOOMANYCHANGES}

// @@@- V2.5

//
// MessageId: DB_S_STOPLIMITREACHED
//
// MessageText:
//
//  Execution stopped because a resource limit has been reached; results
//  obtained so far have been returned but execution cannot be resumed
//
  DB_S_STOPLIMITREACHED                = $00040ED6;
  {$EXTERNALSYM DB_S_STOPLIMITREACHED}

//
// MessageId: DB_S_LOCKUPGRADED
// 
// MessageText:
// 
//  A lock was upgraded from the value specified
// 
  DB_S_LOCKUPGRADED                    = $00040ED8; 
  {$EXTERNALSYM DB_S_LOCKUPGRADED}

//
// MessageId: DB_S_PROPERTIESCHANGED
//
// MessageText:
//
//  One or more properties were changed as allowed by provider
//
  DB_S_PROPERTIESCHANGED               = $00040ED9;
  {$EXTERNALSYM DB_S_PROPERTIESCHANGED}

//
// MessageId: DB_S_ERRORSOCCURRED
//
// MessageText:
//
//  Errors occurred
//
  DB_S_ERRORSOCCURRED                  = $00040EDA;
  {$EXTERNALSYM DB_S_ERRORSOCCURRED}

//
// MessageId: DB_S_PARAMUNAVAILABLE
//
// MessageText:
//
//  A specified parameter was invalid
//
  DB_S_PARAMUNAVAILABLE                = $00040EDB;
  {$EXTERNALSYM DB_S_PARAMUNAVAILABLE}

//
// MessageId: DB_S_MULTIPLECHANGES
//
// MessageText:
//
//  Updating this row caused more than one row to be updated in the
//  data source
//
  DB_S_MULTIPLECHANGES                 = $00040EDC;
  {$EXTERNALSYM DB_S_MULTIPLECHANGES}

implementation

uses ComObj;

end.
